/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.PricingPlanSubscription;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.PricingPlanSubscriptionListParams;
import com.stripe.param.v2.billing.PricingPlanSubscriptionUpdateParams;
import com.stripe.service.v2.billing.pricingplansubscriptions.ComponentService;
import java.lang.reflect.Type;

public final class PricingPlanSubscriptionService
extends ApiService {
    public PricingPlanSubscriptionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PricingPlanSubscription> list(PricingPlanSubscriptionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PricingPlanSubscription> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PricingPlanSubscription> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PricingPlanSubscription> list(PricingPlanSubscriptionListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/pricing_plan_subscriptions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PricingPlanSubscription>>(){}.getType());
    }

    public PricingPlanSubscription retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public PricingPlanSubscription retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plan_subscriptions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (PricingPlanSubscription)this.request(request, (Type)((Object)PricingPlanSubscription.class));
    }

    public PricingPlanSubscription update(String id, PricingPlanSubscriptionUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public PricingPlanSubscription update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public PricingPlanSubscription update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public PricingPlanSubscription update(String id, PricingPlanSubscriptionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plan_subscriptions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PricingPlanSubscription)this.request(request, (Type)((Object)PricingPlanSubscription.class));
    }

    public ComponentService components() {
        return new ComponentService(this.getResponseGetter());
    }
}

