/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.RateCard;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.RateCardCreateParams;
import com.stripe.param.v2.billing.RateCardListParams;
import com.stripe.param.v2.billing.RateCardUpdateParams;
import com.stripe.service.v2.billing.ratecards.RateService;
import com.stripe.service.v2.billing.ratecards.VersionService;
import java.lang.reflect.Type;

public final class RateCardService
extends ApiService {
    public RateCardService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<RateCard> list(RateCardListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<RateCard> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<RateCard> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<RateCard> list(RateCardListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/rate_cards";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<RateCard>>(){}.getType());
    }

    public RateCard create(RateCardCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public RateCard create(RateCardCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/rate_cards";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RateCard)this.request(request, (Type)((Object)RateCard.class));
    }

    public RateCard retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public RateCard retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (RateCard)this.request(request, (Type)((Object)RateCard.class));
    }

    public RateCard update(String id, RateCardUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public RateCard update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public RateCard update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public RateCard update(String id, RateCardUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RateCard)this.request(request, (Type)((Object)RateCard.class));
    }

    public RateService rates() {
        return new RateService(this.getResponseGetter());
    }

    public VersionService versions() {
        return new VersionService(this.getResponseGetter());
    }
}

