/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.RateCardSubscription;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.RateCardSubscriptionCreateParams;
import com.stripe.param.v2.billing.RateCardSubscriptionListParams;
import com.stripe.param.v2.billing.RateCardSubscriptionUpdateParams;
import java.lang.reflect.Type;

public final class RateCardSubscriptionService
extends ApiService {
    public RateCardSubscriptionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<RateCardSubscription> list(RateCardSubscriptionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<RateCardSubscription> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<RateCardSubscription> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<RateCardSubscription> list(RateCardSubscriptionListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/rate_card_subscriptions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<RateCardSubscription>>(){}.getType());
    }

    public RateCardSubscription create(RateCardSubscriptionCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public RateCardSubscription create(RateCardSubscriptionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/rate_card_subscriptions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RateCardSubscription)this.request(request, (Type)((Object)RateCardSubscription.class));
    }

    public RateCardSubscription retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public RateCardSubscription retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_card_subscriptions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (RateCardSubscription)this.request(request, (Type)((Object)RateCardSubscription.class));
    }

    public RateCardSubscription update(String id, RateCardSubscriptionUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public RateCardSubscription update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public RateCardSubscription update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public RateCardSubscription update(String id, RateCardSubscriptionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_card_subscriptions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RateCardSubscription)this.request(request, (Type)((Object)RateCardSubscription.class));
    }

    public RateCardSubscription cancel(String id) throws StripeException {
        return this.cancel(id, null);
    }

    public RateCardSubscription cancel(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_card_subscriptions/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (RateCardSubscription)this.request(request, (Type)((Object)RateCardSubscription.class));
    }
}

