/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.stripe.exception.StripeException;
import com.stripe.model.v2.billing.ServiceAction;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.ActionServiceCreateParams;
import com.stripe.param.v2.billing.ActionServiceUpdateParams;
import java.lang.reflect.Type;

public final class ServiceActionService
extends ApiService {
    public ServiceActionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public ServiceAction create(ActionServiceCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public ServiceAction create(ActionServiceCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/service_actions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (ServiceAction)this.request(request, (Type)((Object)ServiceAction.class));
    }

    public ServiceAction retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public ServiceAction retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/service_actions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (ServiceAction)this.request(request, (Type)((Object)ServiceAction.class));
    }

    public ServiceAction update(String id, ActionServiceUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public ServiceAction update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public ServiceAction update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public ServiceAction update(String id, ActionServiceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/service_actions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (ServiceAction)this.request(request, (Type)((Object)ServiceAction.class));
    }
}

