/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing.intents;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.IntentAction;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.intents.ActionListParams;
import java.lang.reflect.Type;

public final class ActionService
extends ApiService {
    public ActionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<IntentAction> list(String intentId, ActionListParams params) throws StripeException {
        return this.list(intentId, params, null);
    }

    public StripeCollection<IntentAction> list(String intentId, RequestOptions options) throws StripeException {
        return this.list(intentId, null, options);
    }

    public StripeCollection<IntentAction> list(String intentId) throws StripeException {
        return this.list(intentId, null, null);
    }

    public StripeCollection<IntentAction> list(String intentId, ActionListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/intents/%s/actions", ApiResource.urlEncodeId(intentId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<IntentAction>>(){}.getType());
    }

    public IntentAction retrieve(String intentId, String id) throws StripeException {
        return this.retrieve(intentId, id, null);
    }

    public IntentAction retrieve(String intentId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/intents/%s/actions/%s", ApiResource.urlEncodeId(intentId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (IntentAction)this.request(request, (Type)((Object)IntentAction.class));
    }
}

