/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing.licensefees;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.LicenseFeeVersion;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.licensefees.VersionListParams;
import java.lang.reflect.Type;

public final class VersionService
extends ApiService {
    public VersionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<LicenseFeeVersion> list(String licenseFeeId, VersionListParams params) throws StripeException {
        return this.list(licenseFeeId, params, null);
    }

    public StripeCollection<LicenseFeeVersion> list(String licenseFeeId, RequestOptions options) throws StripeException {
        return this.list(licenseFeeId, null, options);
    }

    public StripeCollection<LicenseFeeVersion> list(String licenseFeeId) throws StripeException {
        return this.list(licenseFeeId, null, null);
    }

    public StripeCollection<LicenseFeeVersion> list(String licenseFeeId, VersionListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/license_fees/%s/versions", ApiResource.urlEncodeId(licenseFeeId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<LicenseFeeVersion>>(){}.getType());
    }

    public LicenseFeeVersion retrieve(String licenseFeeId, String id) throws StripeException {
        return this.retrieve(licenseFeeId, id, null);
    }

    public LicenseFeeVersion retrieve(String licenseFeeId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/license_fees/%s/versions/%s", ApiResource.urlEncodeId(licenseFeeId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (LicenseFeeVersion)this.request(request, (Type)((Object)LicenseFeeVersion.class));
    }
}

