/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing.pricingplans;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.DeletedObject;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.PricingPlanComponent;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.pricingplans.ComponentCreateParams;
import com.stripe.param.v2.billing.pricingplans.ComponentListParams;
import com.stripe.param.v2.billing.pricingplans.ComponentUpdateParams;
import java.lang.reflect.Type;

public final class ComponentService
extends ApiService {
    public ComponentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PricingPlanComponent> list(String pricingPlanId, ComponentListParams params) throws StripeException {
        return this.list(pricingPlanId, params, null);
    }

    public StripeCollection<PricingPlanComponent> list(String pricingPlanId, RequestOptions options) throws StripeException {
        return this.list(pricingPlanId, null, options);
    }

    public StripeCollection<PricingPlanComponent> list(String pricingPlanId) throws StripeException {
        return this.list(pricingPlanId, null, null);
    }

    public StripeCollection<PricingPlanComponent> list(String pricingPlanId, ComponentListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s/components", ApiResource.urlEncodeId(pricingPlanId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PricingPlanComponent>>(){}.getType());
    }

    public PricingPlanComponent create(String pricingPlanId, ComponentCreateParams params) throws StripeException {
        return this.create(pricingPlanId, params, null);
    }

    public PricingPlanComponent create(String pricingPlanId, ComponentCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s/components", ApiResource.urlEncodeId(pricingPlanId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PricingPlanComponent)this.request(request, (Type)((Object)PricingPlanComponent.class));
    }

    public DeletedObject delete(String pricingPlanId, String id) throws StripeException {
        return this.delete(pricingPlanId, id, null);
    }

    public DeletedObject delete(String pricingPlanId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s/components/%s", ApiResource.urlEncodeId(pricingPlanId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (DeletedObject)this.request(request, (Type)((Object)DeletedObject.class));
    }

    public PricingPlanComponent retrieve(String pricingPlanId, String id) throws StripeException {
        return this.retrieve(pricingPlanId, id, null);
    }

    public PricingPlanComponent retrieve(String pricingPlanId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s/components/%s", ApiResource.urlEncodeId(pricingPlanId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (PricingPlanComponent)this.request(request, (Type)((Object)PricingPlanComponent.class));
    }

    public PricingPlanComponent update(String pricingPlanId, String id, ComponentUpdateParams params) throws StripeException {
        return this.update(pricingPlanId, id, params, null);
    }

    public PricingPlanComponent update(String pricingPlanId, String id, RequestOptions options) throws StripeException {
        return this.update(pricingPlanId, id, null, options);
    }

    public PricingPlanComponent update(String pricingPlanId, String id) throws StripeException {
        return this.update(pricingPlanId, id, null, null);
    }

    public PricingPlanComponent update(String pricingPlanId, String id, ComponentUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s/components/%s", ApiResource.urlEncodeId(pricingPlanId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PricingPlanComponent)this.request(request, (Type)((Object)PricingPlanComponent.class));
    }
}

