/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing.pricingplans;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.PricingPlanVersion;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.pricingplans.VersionListParams;
import java.lang.reflect.Type;

public final class VersionService
extends ApiService {
    public VersionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PricingPlanVersion> list(String pricingPlanId, VersionListParams params) throws StripeException {
        return this.list(pricingPlanId, params, null);
    }

    public StripeCollection<PricingPlanVersion> list(String pricingPlanId, RequestOptions options) throws StripeException {
        return this.list(pricingPlanId, null, options);
    }

    public StripeCollection<PricingPlanVersion> list(String pricingPlanId) throws StripeException {
        return this.list(pricingPlanId, null, null);
    }

    public StripeCollection<PricingPlanVersion> list(String pricingPlanId, VersionListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s/versions", ApiResource.urlEncodeId(pricingPlanId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PricingPlanVersion>>(){}.getType());
    }

    public PricingPlanVersion retrieve(String pricingPlanId, String id) throws StripeException {
        return this.retrieve(pricingPlanId, id, null);
    }

    public PricingPlanVersion retrieve(String pricingPlanId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s/versions/%s", ApiResource.urlEncodeId(pricingPlanId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (PricingPlanVersion)this.request(request, (Type)((Object)PricingPlanVersion.class));
    }
}

