/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing.ratecards;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.DeletedObject;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.RateCardRate;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.ratecards.RateCreateParams;
import com.stripe.param.v2.billing.ratecards.RateListParams;
import java.lang.reflect.Type;

public final class RateService
extends ApiService {
    public RateService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<RateCardRate> list(String rateCardId, RateListParams params) throws StripeException {
        return this.list(rateCardId, params, null);
    }

    public StripeCollection<RateCardRate> list(String rateCardId, RequestOptions options) throws StripeException {
        return this.list(rateCardId, null, options);
    }

    public StripeCollection<RateCardRate> list(String rateCardId) throws StripeException {
        return this.list(rateCardId, null, null);
    }

    public StripeCollection<RateCardRate> list(String rateCardId, RateListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s/rates", ApiResource.urlEncodeId(rateCardId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<RateCardRate>>(){}.getType());
    }

    public RateCardRate create(String rateCardId, RateCreateParams params) throws StripeException {
        return this.create(rateCardId, params, null);
    }

    public RateCardRate create(String rateCardId, RequestOptions options) throws StripeException {
        return this.create(rateCardId, null, options);
    }

    public RateCardRate create(String rateCardId) throws StripeException {
        return this.create(rateCardId, null, null);
    }

    public RateCardRate create(String rateCardId, RateCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s/rates", ApiResource.urlEncodeId(rateCardId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RateCardRate)this.request(request, (Type)((Object)RateCardRate.class));
    }

    public DeletedObject delete(String rateCardId, String id) throws StripeException {
        return this.delete(rateCardId, id, null);
    }

    public DeletedObject delete(String rateCardId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s/rates/%s", ApiResource.urlEncodeId(rateCardId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (DeletedObject)this.request(request, (Type)((Object)DeletedObject.class));
    }

    public RateCardRate retrieve(String rateCardId, String id) throws StripeException {
        return this.retrieve(rateCardId, id, null);
    }

    public RateCardRate retrieve(String rateCardId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s/rates/%s", ApiResource.urlEncodeId(rateCardId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (RateCardRate)this.request(request, (Type)((Object)RateCardRate.class));
    }
}

