/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing.ratecards;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.RateCardVersion;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.ratecards.VersionListParams;
import java.lang.reflect.Type;

public final class VersionService
extends ApiService {
    public VersionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<RateCardVersion> list(String rateCardId, VersionListParams params) throws StripeException {
        return this.list(rateCardId, params, null);
    }

    public StripeCollection<RateCardVersion> list(String rateCardId, RequestOptions options) throws StripeException {
        return this.list(rateCardId, null, options);
    }

    public StripeCollection<RateCardVersion> list(String rateCardId) throws StripeException {
        return this.list(rateCardId, null, null);
    }

    public StripeCollection<RateCardVersion> list(String rateCardId, VersionListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s/versions", ApiResource.urlEncodeId(rateCardId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<RateCardVersion>>(){}.getType());
    }

    public RateCardVersion retrieve(String rateCardId, String id) throws StripeException {
        return this.retrieve(rateCardId, id, null);
    }

    public RateCardVersion retrieve(String rateCardId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/rate_cards/%s/versions/%s", ApiResource.urlEncodeId(rateCardId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (RateCardVersion)this.request(request, (Type)((Object)RateCardVersion.class));
    }
}

