/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.core.vault;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.BlockedByStripeException;
import com.stripe.exception.ControlledByDashboardException;
import com.stripe.exception.InvalidPaymentMethodException;
import com.stripe.exception.QuotaExceededException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.core.vault.UsBankAccount;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.core.vault.UsBankAccountConfirmMicrodepositsParams;
import com.stripe.param.v2.core.vault.UsBankAccountCreateParams;
import com.stripe.param.v2.core.vault.UsBankAccountListParams;
import com.stripe.param.v2.core.vault.UsBankAccountUpdateParams;
import java.lang.reflect.Type;

public final class UsBankAccountService
extends ApiService {
    public UsBankAccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<UsBankAccount> list(UsBankAccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<UsBankAccount> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<UsBankAccount> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<UsBankAccount> list(UsBankAccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/core/vault/us_bank_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<UsBankAccount>>(){}.getType());
    }

    public UsBankAccount create(UsBankAccountCreateParams params) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.create(params, null);
    }

    public UsBankAccount create(UsBankAccountCreateParams params, RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        String path = "/v2/core/vault/us_bank_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public UsBankAccount retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount update(String id, UsBankAccountUpdateParams params) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.update(id, params, null);
    }

    public UsBankAccount update(String id, RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.update(id, null, options);
    }

    public UsBankAccount update(String id) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.update(id, null, null);
    }

    public UsBankAccount update(String id, UsBankAccountUpdateParams params, RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount archive(String id) throws StripeException, ControlledByDashboardException {
        return this.archive(id, null);
    }

    public UsBankAccount archive(String id, RequestOptions options) throws StripeException, ControlledByDashboardException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s/archive", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount confirmMicrodeposits(String id, UsBankAccountConfirmMicrodepositsParams params) throws StripeException {
        return this.confirmMicrodeposits(id, params, null);
    }

    public UsBankAccount confirmMicrodeposits(String id, RequestOptions options) throws StripeException {
        return this.confirmMicrodeposits(id, null, options);
    }

    public UsBankAccount confirmMicrodeposits(String id) throws StripeException {
        return this.confirmMicrodeposits(id, null, null);
    }

    public UsBankAccount confirmMicrodeposits(String id, UsBankAccountConfirmMicrodepositsParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s/confirm_microdeposits", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount sendMicrodeposits(String id) throws StripeException {
        return this.sendMicrodeposits(id, null);
    }

    public UsBankAccount sendMicrodeposits(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s/send_microdeposits", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }
}

