/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.stripe.exception.StripeException;
import com.stripe.model.v2.moneymanagement.RecipientVerification;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.RecipientVerificationCreateParams;
import java.lang.reflect.Type;

public final class RecipientVerificationService
extends ApiService {
    public RecipientVerificationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public RecipientVerification create(RecipientVerificationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public RecipientVerification create(RecipientVerificationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/recipient_verifications";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RecipientVerification)this.request(request, (Type)((Object)RecipientVerification.class));
    }

    public RecipientVerification retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public RecipientVerification retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/recipient_verifications/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (RecipientVerification)this.request(request, (Type)((Object)RecipientVerification.class));
    }

    public RecipientVerification acknowledge(String id) throws StripeException {
        return this.acknowledge(id, null);
    }

    public RecipientVerification acknowledge(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/recipient_verifications/%s/acknowledge", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (RecipientVerification)this.request(request, (Type)((Object)RecipientVerification.class));
    }
}

