/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.tax;

import com.stripe.exception.StripeException;
import com.stripe.model.v2.tax.AutomaticRule;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.tax.AutomaticRuleCreateParams;
import com.stripe.param.v2.tax.AutomaticRuleFindParams;
import com.stripe.param.v2.tax.AutomaticRuleUpdateParams;
import java.lang.reflect.Type;

public final class AutomaticRuleService
extends ApiService {
    public AutomaticRuleService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public AutomaticRule create(AutomaticRuleCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public AutomaticRule create(AutomaticRuleCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/tax/automatic_rules";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (AutomaticRule)this.request(request, (Type)((Object)AutomaticRule.class));
    }

    public AutomaticRule find(AutomaticRuleFindParams params) throws StripeException {
        return this.find(params, null);
    }

    public AutomaticRule find(AutomaticRuleFindParams params, RequestOptions options) throws StripeException {
        String path = "/v2/tax/automatic_rules/find";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (AutomaticRule)this.request(request, (Type)((Object)AutomaticRule.class));
    }

    public AutomaticRule retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public AutomaticRule retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/tax/automatic_rules/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (AutomaticRule)this.request(request, (Type)((Object)AutomaticRule.class));
    }

    public AutomaticRule update(String id, AutomaticRuleUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public AutomaticRule update(String id, AutomaticRuleUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/tax/automatic_rules/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (AutomaticRule)this.request(request, (Type)((Object)AutomaticRule.class));
    }

    public AutomaticRule deactivate(String id) throws StripeException {
        return this.deactivate(id, null);
    }

    public AutomaticRule deactivate(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/tax/automatic_rules/%s/deactivate", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (AutomaticRule)this.request(request, (Type)((Object)AutomaticRule.class));
    }
}

