/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.exception;

import com.google.gson.JsonObject;
import com.stripe.exception.AlreadyCanceledException;
import com.stripe.exception.AlreadyExistsException;
import com.stripe.exception.BlockedByStripeException;
import com.stripe.exception.ControlledByDashboardException;
import com.stripe.exception.FeatureNotEnabledException;
import com.stripe.exception.FinancialAccountNotOpenException;
import com.stripe.exception.InsufficientFundsException;
import com.stripe.exception.InvalidPaymentMethodException;
import com.stripe.exception.InvalidPayoutMethodException;
import com.stripe.exception.NonZeroBalanceException;
import com.stripe.exception.NotCancelableException;
import com.stripe.exception.QuotaExceededException;
import com.stripe.exception.RateLimitException;
import com.stripe.exception.RecipientNotNotifiableException;
import com.stripe.exception.TemporarySessionExpiredException;
import com.stripe.model.StripeError;
import com.stripe.net.ApiMode;
import com.stripe.net.StripeResponseGetter;
import lombok.Generated;

public abstract class StripeException
extends Exception {
    private static final long serialVersionUID = 2L;
    transient StripeError stripeError;
    ApiMode stripeErrorApiMode;
    private String code;
    private String requestId;
    private Integer statusCode;

    public void setStripeError(StripeError err) {
        this.stripeError = err;
        this.stripeErrorApiMode = ApiMode.V1;
    }

    public void setStripeV2Error(StripeError err) {
        this.stripeError = err;
        this.stripeErrorApiMode = ApiMode.V2;
    }

    protected StripeException(String message, String requestId, String code, Integer statusCode) {
        this(message, requestId, code, statusCode, null);
    }

    protected StripeException(String message, String requestId, String code, Integer statusCode, Throwable e) {
        super(message, e);
        this.code = code;
        this.requestId = requestId;
        this.statusCode = statusCode;
    }

    @Override
    public String getMessage() {
        String additionalInfo = "";
        if (this.code != null) {
            additionalInfo = additionalInfo + "; code: " + this.code;
        }
        if (this.requestId != null) {
            additionalInfo = additionalInfo + "; request-id: " + this.requestId;
        }
        if (this.stripeErrorApiMode == ApiMode.V2 && this.getUserMessage() != null) {
            additionalInfo = additionalInfo + "; user-message: " + this.getUserMessage();
        }
        return super.getMessage() + additionalInfo;
    }

    public String getUserMessage() {
        if (this.getStripeError() != null) {
            switch (this.stripeErrorApiMode) {
                case V1: {
                    return this.getStripeError().getMessage();
                }
                case V2: {
                    return this.getStripeError().getUserMessage();
                }
            }
        }
        return null;
    }

    public static StripeException parseV2Exception(String type, JsonObject body, int statusCode, String requestId, StripeResponseGetter responseGetter) {
        switch (type) {
            case "already_canceled": {
                return AlreadyCanceledException.parse(body, statusCode, requestId, responseGetter);
            }
            case "already_exists": {
                return AlreadyExistsException.parse(body, statusCode, requestId, responseGetter);
            }
            case "blocked_by_stripe": {
                return BlockedByStripeException.parse(body, statusCode, requestId, responseGetter);
            }
            case "controlled_by_dashboard": {
                return ControlledByDashboardException.parse(body, statusCode, requestId, responseGetter);
            }
            case "feature_not_enabled": {
                return FeatureNotEnabledException.parse(body, statusCode, requestId, responseGetter);
            }
            case "financial_account_not_open": {
                return FinancialAccountNotOpenException.parse(body, statusCode, requestId, responseGetter);
            }
            case "insufficient_funds": {
                return InsufficientFundsException.parse(body, statusCode, requestId, responseGetter);
            }
            case "invalid_payment_method": {
                return InvalidPaymentMethodException.parse(body, statusCode, requestId, responseGetter);
            }
            case "invalid_payout_method": {
                return InvalidPayoutMethodException.parse(body, statusCode, requestId, responseGetter);
            }
            case "non_zero_balance": {
                return NonZeroBalanceException.parse(body, statusCode, requestId, responseGetter);
            }
            case "not_cancelable": {
                return NotCancelableException.parse(body, statusCode, requestId, responseGetter);
            }
            case "quota_exceeded": {
                return QuotaExceededException.parse(body, statusCode, requestId, responseGetter);
            }
            case "rate_limit": {
                return RateLimitException.parse(body, statusCode, requestId, responseGetter);
            }
            case "recipient_not_notifiable": {
                return RecipientNotNotifiableException.parse(body, statusCode, requestId, responseGetter);
            }
            case "temporary_session_expired": {
                return TemporarySessionExpiredException.parse(body, statusCode, requestId, responseGetter);
            }
        }
        return null;
    }

    @Generated
    public StripeError getStripeError() {
        return this.stripeError;
    }

    @Generated
    public ApiMode getStripeErrorApiMode() {
        return this.stripeErrorApiMode;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }
}

