/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.FxQuoteCollection;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.FxQuoteCreateParams;
import com.stripe.param.FxQuoteListParams;
import com.stripe.param.FxQuoteRetrieveParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class FxQuote
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="lock_duration")
    String lockDuration;
    @SerializedName(value="lock_expires_at")
    Long lockExpiresAt;
    @SerializedName(value="lock_status")
    String lockStatus;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="rates")
    Map<String, Rate> rates;
    @SerializedName(value="to_currency")
    String toCurrency;
    @SerializedName(value="usage")
    Usage usage;

    public static FxQuote create(Map<String, Object> params) throws StripeException {
        return FxQuote.create(params, (RequestOptions)null);
    }

    public static FxQuote create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/fx_quotes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (FxQuote)FxQuote.getGlobalResponseGetter().request(request, (Type)((Object)FxQuote.class));
    }

    public static FxQuote create(FxQuoteCreateParams params) throws StripeException {
        return FxQuote.create(params, (RequestOptions)null);
    }

    public static FxQuote create(FxQuoteCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/fx_quotes";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FxQuote)FxQuote.getGlobalResponseGetter().request(request, (Type)((Object)FxQuote.class));
    }

    public static FxQuoteCollection list(Map<String, Object> params) throws StripeException {
        return FxQuote.list(params, (RequestOptions)null);
    }

    public static FxQuoteCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/fx_quotes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (FxQuoteCollection)FxQuote.getGlobalResponseGetter().request(request, (Type)((Object)FxQuoteCollection.class));
    }

    public static FxQuoteCollection list(FxQuoteListParams params) throws StripeException {
        return FxQuote.list(params, (RequestOptions)null);
    }

    public static FxQuoteCollection list(FxQuoteListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/fx_quotes";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FxQuoteCollection)FxQuote.getGlobalResponseGetter().request(request, (Type)((Object)FxQuoteCollection.class));
    }

    public static FxQuote retrieve(String id) throws StripeException {
        return FxQuote.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static FxQuote retrieve(String id, RequestOptions options) throws StripeException {
        return FxQuote.retrieve(id, (Map<String, Object>)null, options);
    }

    public static FxQuote retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/fx_quotes/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (FxQuote)FxQuote.getGlobalResponseGetter().request(request, (Type)((Object)FxQuote.class));
    }

    public static FxQuote retrieve(String id, FxQuoteRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/fx_quotes/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FxQuote)FxQuote.getGlobalResponseGetter().request(request, (Type)((Object)FxQuote.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.usage, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getLockDuration() {
        return this.lockDuration;
    }

    @Generated
    public Long getLockExpiresAt() {
        return this.lockExpiresAt;
    }

    @Generated
    public String getLockStatus() {
        return this.lockStatus;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Map<String, Rate> getRates() {
        return this.rates;
    }

    @Generated
    public String getToCurrency() {
        return this.toCurrency;
    }

    @Generated
    public Usage getUsage() {
        return this.usage;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLockDuration(String lockDuration) {
        this.lockDuration = lockDuration;
    }

    @Generated
    public void setLockExpiresAt(Long lockExpiresAt) {
        this.lockExpiresAt = lockExpiresAt;
    }

    @Generated
    public void setLockStatus(String lockStatus) {
        this.lockStatus = lockStatus;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setRates(Map<String, Rate> rates) {
        this.rates = rates;
    }

    @Generated
    public void setToCurrency(String toCurrency) {
        this.toCurrency = toCurrency;
    }

    @Generated
    public void setUsage(Usage usage) {
        this.usage = usage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FxQuote)) {
            return false;
        }
        FxQuote other = (FxQuote)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$lockExpiresAt = this.getLockExpiresAt();
        Long other$lockExpiresAt = other.getLockExpiresAt();
        if (this$lockExpiresAt == null ? other$lockExpiresAt != null : !((Object)this$lockExpiresAt).equals(other$lockExpiresAt)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lockDuration = this.getLockDuration();
        String other$lockDuration = other.getLockDuration();
        if (this$lockDuration == null ? other$lockDuration != null : !this$lockDuration.equals(other$lockDuration)) {
            return false;
        }
        String this$lockStatus = this.getLockStatus();
        String other$lockStatus = other.getLockStatus();
        if (this$lockStatus == null ? other$lockStatus != null : !this$lockStatus.equals(other$lockStatus)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Map<String, Rate> this$rates = this.getRates();
        Map<String, Rate> other$rates = other.getRates();
        if (this$rates == null ? other$rates != null : !((Object)this$rates).equals(other$rates)) {
            return false;
        }
        String this$toCurrency = this.getToCurrency();
        String other$toCurrency = other.getToCurrency();
        if (this$toCurrency == null ? other$toCurrency != null : !this$toCurrency.equals(other$toCurrency)) {
            return false;
        }
        Usage this$usage = this.getUsage();
        Usage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FxQuote;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $lockExpiresAt = this.getLockExpiresAt();
        result = result * 59 + ($lockExpiresAt == null ? 43 : ((Object)$lockExpiresAt).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lockDuration = this.getLockDuration();
        result = result * 59 + ($lockDuration == null ? 43 : $lockDuration.hashCode());
        String $lockStatus = this.getLockStatus();
        result = result * 59 + ($lockStatus == null ? 43 : $lockStatus.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Map<String, Rate> $rates = this.getRates();
        result = result * 59 + ($rates == null ? 43 : ((Object)$rates).hashCode());
        String $toCurrency = this.getToCurrency();
        result = result * 59 + ($toCurrency == null ? 43 : $toCurrency.hashCode());
        Usage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Usage
    extends StripeObject {
        @SerializedName(value="payment")
        Payment payment;
        @SerializedName(value="transfer")
        Transfer transfer;
        @SerializedName(value="type")
        String type;

        @Generated
        public Payment getPayment() {
            return this.payment;
        }

        @Generated
        public Transfer getTransfer() {
            return this.transfer;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setPayment(Payment payment) {
            this.payment = payment;
        }

        @Generated
        public void setTransfer(Transfer transfer) {
            this.transfer = transfer;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Usage)) {
                return false;
            }
            Usage other = (Usage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Payment this$payment = this.getPayment();
            Payment other$payment = other.getPayment();
            if (this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment)) {
                return false;
            }
            Transfer this$transfer = this.getTransfer();
            Transfer other$transfer = other.getTransfer();
            if (this$transfer == null ? other$transfer != null : !((Object)this$transfer).equals(other$transfer)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Usage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Payment $payment = this.getPayment();
            result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
            Transfer $transfer = this.getTransfer();
            result = result * 59 + ($transfer == null ? 43 : ((Object)$transfer).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Payment
        extends StripeObject {
            @SerializedName(value="destination")
            String destination;
            @SerializedName(value="on_behalf_of")
            String onBehalfOf;

            @Generated
            public String getDestination() {
                return this.destination;
            }

            @Generated
            public String getOnBehalfOf() {
                return this.onBehalfOf;
            }

            @Generated
            public void setDestination(String destination) {
                this.destination = destination;
            }

            @Generated
            public void setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payment)) {
                    return false;
                }
                Payment other = (Payment)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$destination = this.getDestination();
                String other$destination = other.getDestination();
                if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
                    return false;
                }
                String this$onBehalfOf = this.getOnBehalfOf();
                String other$onBehalfOf = other.getOnBehalfOf();
                return !(this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payment;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $destination = this.getDestination();
                result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
                String $onBehalfOf = this.getOnBehalfOf();
                result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
                return result;
            }
        }

        public static class Transfer
        extends StripeObject {
            @SerializedName(value="destination")
            String destination;

            @Generated
            public String getDestination() {
                return this.destination;
            }

            @Generated
            public void setDestination(String destination) {
                this.destination = destination;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Transfer)) {
                    return false;
                }
                Transfer other = (Transfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$destination = this.getDestination();
                String other$destination = other.getDestination();
                return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Transfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $destination = this.getDestination();
                result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
                return result;
            }
        }
    }

    public static class Rate
    extends StripeObject {
        @SerializedName(value="exchange_rate")
        BigDecimal exchangeRate;
        @SerializedName(value="rate_details")
        RateDetails rateDetails;

        @Generated
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Generated
        public RateDetails getRateDetails() {
            return this.rateDetails;
        }

        @Generated
        public void setExchangeRate(BigDecimal exchangeRate) {
            this.exchangeRate = exchangeRate;
        }

        @Generated
        public void setRateDetails(RateDetails rateDetails) {
            this.rateDetails = rateDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rate)) {
                return false;
            }
            Rate other = (Rate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$exchangeRate = this.getExchangeRate();
            BigDecimal other$exchangeRate = other.getExchangeRate();
            if (this$exchangeRate == null ? other$exchangeRate != null : !((Object)this$exchangeRate).equals(other$exchangeRate)) {
                return false;
            }
            RateDetails this$rateDetails = this.getRateDetails();
            RateDetails other$rateDetails = other.getRateDetails();
            return !(this$rateDetails == null ? other$rateDetails != null : !((Object)this$rateDetails).equals(other$rateDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Rate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $exchangeRate = this.getExchangeRate();
            result = result * 59 + ($exchangeRate == null ? 43 : ((Object)$exchangeRate).hashCode());
            RateDetails $rateDetails = this.getRateDetails();
            result = result * 59 + ($rateDetails == null ? 43 : ((Object)$rateDetails).hashCode());
            return result;
        }

        public static class RateDetails
        extends StripeObject {
            @SerializedName(value="base_rate")
            BigDecimal baseRate;
            @SerializedName(value="duration_premium")
            BigDecimal durationPremium;
            @SerializedName(value="fx_fee_rate")
            BigDecimal fxFeeRate;
            @SerializedName(value="reference_rate")
            BigDecimal referenceRate;
            @SerializedName(value="reference_rate_provider")
            String referenceRateProvider;

            @Generated
            public BigDecimal getBaseRate() {
                return this.baseRate;
            }

            @Generated
            public BigDecimal getDurationPremium() {
                return this.durationPremium;
            }

            @Generated
            public BigDecimal getFxFeeRate() {
                return this.fxFeeRate;
            }

            @Generated
            public BigDecimal getReferenceRate() {
                return this.referenceRate;
            }

            @Generated
            public String getReferenceRateProvider() {
                return this.referenceRateProvider;
            }

            @Generated
            public void setBaseRate(BigDecimal baseRate) {
                this.baseRate = baseRate;
            }

            @Generated
            public void setDurationPremium(BigDecimal durationPremium) {
                this.durationPremium = durationPremium;
            }

            @Generated
            public void setFxFeeRate(BigDecimal fxFeeRate) {
                this.fxFeeRate = fxFeeRate;
            }

            @Generated
            public void setReferenceRate(BigDecimal referenceRate) {
                this.referenceRate = referenceRate;
            }

            @Generated
            public void setReferenceRateProvider(String referenceRateProvider) {
                this.referenceRateProvider = referenceRateProvider;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RateDetails)) {
                    return false;
                }
                RateDetails other = (RateDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BigDecimal this$baseRate = this.getBaseRate();
                BigDecimal other$baseRate = other.getBaseRate();
                if (this$baseRate == null ? other$baseRate != null : !((Object)this$baseRate).equals(other$baseRate)) {
                    return false;
                }
                BigDecimal this$durationPremium = this.getDurationPremium();
                BigDecimal other$durationPremium = other.getDurationPremium();
                if (this$durationPremium == null ? other$durationPremium != null : !((Object)this$durationPremium).equals(other$durationPremium)) {
                    return false;
                }
                BigDecimal this$fxFeeRate = this.getFxFeeRate();
                BigDecimal other$fxFeeRate = other.getFxFeeRate();
                if (this$fxFeeRate == null ? other$fxFeeRate != null : !((Object)this$fxFeeRate).equals(other$fxFeeRate)) {
                    return false;
                }
                BigDecimal this$referenceRate = this.getReferenceRate();
                BigDecimal other$referenceRate = other.getReferenceRate();
                if (this$referenceRate == null ? other$referenceRate != null : !((Object)this$referenceRate).equals(other$referenceRate)) {
                    return false;
                }
                String this$referenceRateProvider = this.getReferenceRateProvider();
                String other$referenceRateProvider = other.getReferenceRateProvider();
                return !(this$referenceRateProvider == null ? other$referenceRateProvider != null : !this$referenceRateProvider.equals(other$referenceRateProvider));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RateDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BigDecimal $baseRate = this.getBaseRate();
                result = result * 59 + ($baseRate == null ? 43 : ((Object)$baseRate).hashCode());
                BigDecimal $durationPremium = this.getDurationPremium();
                result = result * 59 + ($durationPremium == null ? 43 : ((Object)$durationPremium).hashCode());
                BigDecimal $fxFeeRate = this.getFxFeeRate();
                result = result * 59 + ($fxFeeRate == null ? 43 : ((Object)$fxFeeRate).hashCode());
                BigDecimal $referenceRate = this.getReferenceRate();
                result = result * 59 + ($referenceRate == null ? 43 : ((Object)$referenceRate).hashCode());
                String $referenceRateProvider = this.getReferenceRateProvider();
                result = result * 59 + ($referenceRateProvider == null ? 43 : $referenceRateProvider.hashCode());
                return result;
            }
        }
    }
}

