/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MarginCollection;
import com.stripe.model.MetadataStore;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.MarginCreateParams;
import com.stripe.param.MarginListParams;
import com.stripe.param.MarginRetrieveParams;
import com.stripe.param.MarginUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class Margin
extends ApiResource
implements HasId,
MetadataStore<Margin> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="percent_off")
    BigDecimal percentOff;
    @SerializedName(value="updated")
    Long updated;

    public static Margin create(Map<String, Object> params) throws StripeException {
        return Margin.create(params, (RequestOptions)null);
    }

    public static Margin create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/margins";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Margin)Margin.getGlobalResponseGetter().request(request, (Type)((Object)Margin.class));
    }

    public static Margin create(MarginCreateParams params) throws StripeException {
        return Margin.create(params, (RequestOptions)null);
    }

    public static Margin create(MarginCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/margins";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Margin)Margin.getGlobalResponseGetter().request(request, (Type)((Object)Margin.class));
    }

    public static MarginCollection list(Map<String, Object> params) throws StripeException {
        return Margin.list(params, (RequestOptions)null);
    }

    public static MarginCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/margins";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (MarginCollection)Margin.getGlobalResponseGetter().request(request, (Type)((Object)MarginCollection.class));
    }

    public static MarginCollection list(MarginListParams params) throws StripeException {
        return Margin.list(params, (RequestOptions)null);
    }

    public static MarginCollection list(MarginListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/margins";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (MarginCollection)Margin.getGlobalResponseGetter().request(request, (Type)((Object)MarginCollection.class));
    }

    public static Margin retrieve(String margin) throws StripeException {
        return Margin.retrieve(margin, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Margin retrieve(String margin, RequestOptions options) throws StripeException {
        return Margin.retrieve(margin, (Map<String, Object>)null, options);
    }

    public static Margin retrieve(String margin, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/margins/%s", ApiResource.urlEncodeId(margin));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Margin)Margin.getGlobalResponseGetter().request(request, (Type)((Object)Margin.class));
    }

    public static Margin retrieve(String margin, MarginRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/margins/%s", ApiResource.urlEncodeId(margin));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Margin)Margin.getGlobalResponseGetter().request(request, (Type)((Object)Margin.class));
    }

    public Margin update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Margin update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/margins/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Margin)this.getResponseGetter().request(request, (Type)((Object)Margin.class));
    }

    public Margin update(MarginUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Margin update(MarginUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/margins/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Margin)this.getResponseGetter().request(request, (Type)((Object)Margin.class));
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public BigDecimal getPercentOff() {
        return this.percentOff;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPercentOff(BigDecimal percentOff) {
        this.percentOff = percentOff;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Margin)) {
            return false;
        }
        Margin other = (Margin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        BigDecimal this$percentOff = this.getPercentOff();
        BigDecimal other$percentOff = other.getPercentOff();
        return !(this$percentOff == null ? other$percentOff != null : !((Object)this$percentOff).equals(other$percentOff));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Margin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        BigDecimal $percentOff = this.getPercentOff();
        result = result * 59 + ($percentOff == null ? 43 : ((Object)$percentOff).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

