/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.CreditBalanceSummaryRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CreditBalanceSummary
extends ApiResource {
    @SerializedName(value="balances")
    List<Balance> balances;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_account")
    String customerAccount;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public static CreditBalanceSummary retrieve() throws StripeException {
        return CreditBalanceSummary.retrieve((Map<String, Object>)null, (RequestOptions)null);
    }

    public static CreditBalanceSummary retrieve(RequestOptions options) throws StripeException {
        return CreditBalanceSummary.retrieve((Map<String, Object>)null, options);
    }

    public static CreditBalanceSummary retrieve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_balance_summary";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (CreditBalanceSummary)CreditBalanceSummary.getGlobalResponseGetter().request(request, (Type)((Object)CreditBalanceSummary.class));
    }

    public static CreditBalanceSummary retrieve(CreditBalanceSummaryRetrieveParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_balance_summary";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditBalanceSummary)CreditBalanceSummary.getGlobalResponseGetter().request(request, (Type)((Object)CreditBalanceSummary.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
    }

    @Generated
    public List<Balance> getBalances() {
        return this.balances;
    }

    @Generated
    public String getCustomerAccount() {
        return this.customerAccount;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setBalances(List<Balance> balances) {
        this.balances = balances;
    }

    @Generated
    public void setCustomerAccount(String customerAccount) {
        this.customerAccount = customerAccount;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditBalanceSummary)) {
            return false;
        }
        CreditBalanceSummary other = (CreditBalanceSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        List<Balance> this$balances = this.getBalances();
        List<Balance> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerAccount = this.getCustomerAccount();
        String other$customerAccount = other.getCustomerAccount();
        if (this$customerAccount == null ? other$customerAccount != null : !this$customerAccount.equals(other$customerAccount)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreditBalanceSummary;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        List<Balance> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerAccount = this.getCustomerAccount();
        result = result * 59 + ($customerAccount == null ? 43 : $customerAccount.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public static class Balance
    extends StripeObject {
        @SerializedName(value="available_balance")
        AvailableBalance availableBalance;
        @SerializedName(value="ledger_balance")
        LedgerBalance ledgerBalance;

        @Generated
        public AvailableBalance getAvailableBalance() {
            return this.availableBalance;
        }

        @Generated
        public LedgerBalance getLedgerBalance() {
            return this.ledgerBalance;
        }

        @Generated
        public void setAvailableBalance(AvailableBalance availableBalance) {
            this.availableBalance = availableBalance;
        }

        @Generated
        public void setLedgerBalance(LedgerBalance ledgerBalance) {
            this.ledgerBalance = ledgerBalance;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance other = (Balance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AvailableBalance this$availableBalance = this.getAvailableBalance();
            AvailableBalance other$availableBalance = other.getAvailableBalance();
            if (this$availableBalance == null ? other$availableBalance != null : !((Object)this$availableBalance).equals(other$availableBalance)) {
                return false;
            }
            LedgerBalance this$ledgerBalance = this.getLedgerBalance();
            LedgerBalance other$ledgerBalance = other.getLedgerBalance();
            return !(this$ledgerBalance == null ? other$ledgerBalance != null : !((Object)this$ledgerBalance).equals(other$ledgerBalance));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Balance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AvailableBalance $availableBalance = this.getAvailableBalance();
            result = result * 59 + ($availableBalance == null ? 43 : ((Object)$availableBalance).hashCode());
            LedgerBalance $ledgerBalance = this.getLedgerBalance();
            result = result * 59 + ($ledgerBalance == null ? 43 : ((Object)$ledgerBalance).hashCode());
            return result;
        }

        public static class AvailableBalance
        extends StripeObject {
            @SerializedName(value="monetary")
            Monetary monetary;
            @SerializedName(value="type")
            String type;

            @Generated
            public Monetary getMonetary() {
                return this.monetary;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setMonetary(Monetary monetary) {
                this.monetary = monetary;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AvailableBalance)) {
                    return false;
                }
                AvailableBalance other = (AvailableBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Monetary this$monetary = this.getMonetary();
                Monetary other$monetary = other.getMonetary();
                if (this$monetary == null ? other$monetary != null : !((Object)this$monetary).equals(other$monetary)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AvailableBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Monetary $monetary = this.getMonetary();
                result = result * 59 + ($monetary == null ? 43 : ((Object)$monetary).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Monetary
            extends StripeObject {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="value")
                Long value;

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Long getValue() {
                    return this.value;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setValue(Long value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Monetary)) {
                        return false;
                    }
                    Monetary other = (Monetary)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$value = this.getValue();
                    Long other$value = other.getValue();
                    if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Monetary;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    return result;
                }
            }
        }

        public static class LedgerBalance
        extends StripeObject {
            @SerializedName(value="monetary")
            Monetary monetary;
            @SerializedName(value="type")
            String type;

            @Generated
            public Monetary getMonetary() {
                return this.monetary;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setMonetary(Monetary monetary) {
                this.monetary = monetary;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LedgerBalance)) {
                    return false;
                }
                LedgerBalance other = (LedgerBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Monetary this$monetary = this.getMonetary();
                Monetary other$monetary = other.getMonetary();
                if (this$monetary == null ? other$monetary != null : !((Object)this$monetary).equals(other$monetary)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof LedgerBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Monetary $monetary = this.getMonetary();
                result = result * 59 + ($monetary == null ? 43 : ((Object)$monetary).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Monetary
            extends StripeObject {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="value")
                Long value;

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Long getValue() {
                    return this.value;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setValue(Long value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Monetary)) {
                        return false;
                    }
                    Monetary other = (Monetary)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$value = this.getValue();
                    Long other$value = other.getValue();
                    if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Monetary;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    return result;
                }
            }
        }
    }
}

