/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.core;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.RateLimitException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.core.Account;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.core.AccountCloseParams;
import com.stripe.param.v2.core.AccountCreateParams;
import com.stripe.param.v2.core.AccountListParams;
import com.stripe.param.v2.core.AccountRetrieveParams;
import com.stripe.param.v2.core.AccountUpdateParams;
import com.stripe.service.v2.core.accounts.PersonService;
import com.stripe.service.v2.core.accounts.PersonTokenService;
import java.lang.reflect.Type;

public final class AccountService
extends ApiService {
    public AccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Account> list(AccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Account> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Account> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Account> list(AccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/core/accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Account>>(){}.getType());
    }

    public Account create(AccountCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Account create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Account create() throws StripeException {
        return this.create(null, null);
    }

    public Account create(AccountCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/core/accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public Account retrieve(String id, AccountRetrieveParams params) throws StripeException, RateLimitException {
        return this.retrieve(id, params, null);
    }

    public Account retrieve(String id, RequestOptions options) throws StripeException, RateLimitException {
        return this.retrieve(id, null, options);
    }

    public Account retrieve(String id) throws StripeException, RateLimitException {
        return this.retrieve(id, null, null);
    }

    public Account retrieve(String id, AccountRetrieveParams params, RequestOptions options) throws StripeException, RateLimitException {
        String path = String.format("/v2/core/accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public Account update(String id, AccountUpdateParams params) throws StripeException, RateLimitException {
        return this.update(id, params, null);
    }

    public Account update(String id, RequestOptions options) throws StripeException, RateLimitException {
        return this.update(id, null, options);
    }

    public Account update(String id) throws StripeException, RateLimitException {
        return this.update(id, null, null);
    }

    public Account update(String id, AccountUpdateParams params, RequestOptions options) throws StripeException, RateLimitException {
        String path = String.format("/v2/core/accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public Account close(String id, AccountCloseParams params) throws StripeException {
        return this.close(id, params, null);
    }

    public Account close(String id, RequestOptions options) throws StripeException {
        return this.close(id, null, options);
    }

    public Account close(String id) throws StripeException {
        return this.close(id, null, null);
    }

    public Account close(String id, AccountCloseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/close", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Account)this.request(request, (Type)((Object)Account.class));
    }

    public PersonTokenService personTokens() {
        return new PersonTokenService(this.getResponseGetter());
    }

    public PersonService persons() {
        return new PersonService(this.getResponseGetter());
    }
}

