/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.core.vault;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.core.vault.GbBankAccount;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.core.vault.GbBankAccountCreateParams;
import com.stripe.param.v2.core.vault.GbBankAccountInitiateConfirmationOfPayeeParams;
import com.stripe.param.v2.core.vault.GbBankAccountListParams;
import java.lang.reflect.Type;

public final class GbBankAccountService
extends ApiService {
    public GbBankAccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<GbBankAccount> list(GbBankAccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<GbBankAccount> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<GbBankAccount> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<GbBankAccount> list(GbBankAccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/core/vault/gb_bank_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<GbBankAccount>>(){}.getType());
    }

    public GbBankAccount create(GbBankAccountCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public GbBankAccount create(GbBankAccountCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/core/vault/gb_bank_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (GbBankAccount)this.request(request, (Type)((Object)GbBankAccount.class));
    }

    public GbBankAccount retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public GbBankAccount retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/gb_bank_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (GbBankAccount)this.request(request, (Type)((Object)GbBankAccount.class));
    }

    public GbBankAccount acknowledgeConfirmationOfPayee(String id) throws StripeException {
        return this.acknowledgeConfirmationOfPayee(id, null);
    }

    public GbBankAccount acknowledgeConfirmationOfPayee(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/gb_bank_accounts/%s/acknowledge_confirmation_of_payee", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (GbBankAccount)this.request(request, (Type)((Object)GbBankAccount.class));
    }

    public GbBankAccount archive(String id) throws StripeException {
        return this.archive(id, null);
    }

    public GbBankAccount archive(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/gb_bank_accounts/%s/archive", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (GbBankAccount)this.request(request, (Type)((Object)GbBankAccount.class));
    }

    public GbBankAccount initiateConfirmationOfPayee(String id, GbBankAccountInitiateConfirmationOfPayeeParams params) throws StripeException {
        return this.initiateConfirmationOfPayee(id, params, null);
    }

    public GbBankAccount initiateConfirmationOfPayee(String id, RequestOptions options) throws StripeException {
        return this.initiateConfirmationOfPayee(id, null, options);
    }

    public GbBankAccount initiateConfirmationOfPayee(String id) throws StripeException {
        return this.initiateConfirmationOfPayee(id, null, null);
    }

    public GbBankAccount initiateConfirmationOfPayee(String id, GbBankAccountInitiateConfirmationOfPayeeParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/gb_bank_accounts/%s/initiate_confirmation_of_payee", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (GbBankAccount)this.request(request, (Type)((Object)GbBankAccount.class));
    }
}

