/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BankAccount;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Summary;
import com.stripe.model.TransferCollection;
import com.stripe.model.TransferReversalCollection;
import com.stripe.model.TransferTransactionCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Transfer
extends APIResource
implements MetadataStore<Transfer>,
HasId {
    String id;
    String object;
    Long amount;
    Long amountReversed;
    String applicationFee;
    String balanceTransaction;
    BankAccount bankAccount;
    Long created;
    String currency;
    Long date;
    String description;
    String destination;
    String destinationPayment;
    String failureCode;
    String failureMessage;
    Boolean livemode;
    Map<String, String> metadata;
    TransferReversalCollection reversals;
    Boolean reversed;
    String sourceTransaction;
    String sourceType;
    String statementDescriptor;
    String status;
    String transferGroup;
    String type;
    @Deprecated
    BankAccount account;
    @Deprecated
    List<String> otherTransfers;
    @Deprecated
    String recipient;
    @Deprecated
    String statementDescription;
    @Deprecated
    Summary summary;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getAmountReversed() {
        return this.amountReversed;
    }

    public void setAmountReversed(Long amountReversed) {
        this.amountReversed = amountReversed;
    }

    public String getApplicationFee() {
        return this.applicationFee;
    }

    public void setApplicationFee(String applicationFee) {
        this.applicationFee = applicationFee;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationPayment() {
        return this.destinationPayment;
    }

    public void setDestinationPayment(String destinationPayment) {
        this.destinationPayment = destinationPayment;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public TransferReversalCollection getReversals() {
        if (this.reversals.getURL() == null) {
            this.reversals.setURL(String.format("/v1/transfers/%s/reversals", this.getId()));
        }
        return this.reversals;
    }

    public Boolean getReversed() {
        return this.reversed;
    }

    public void setReversed(Boolean reversed) {
        this.reversed = reversed;
    }

    public String getSourceTransaction() {
        return this.sourceTransaction;
    }

    public void setSourceTransaction(String sourceTransaction) {
        this.sourceTransaction = sourceTransaction;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTransferGroup() {
        return this.transferGroup;
    }

    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    public BankAccount getAccount() {
        return this.account;
    }

    @Deprecated
    public void setAccount(BankAccount account) {
        this.account = account;
    }

    @Deprecated
    public List<String> getOtherTransfers() {
        return this.otherTransfers;
    }

    @Deprecated
    public void setOtherTransfers(List<String> otherTransfers) {
        this.otherTransfers = otherTransfers;
    }

    @Deprecated
    public String getRecipient() {
        return this.recipient;
    }

    @Deprecated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Deprecated
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Deprecated
    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    @Deprecated
    public Summary getSummary() {
        return this.summary;
    }

    @Deprecated
    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public static Transfer create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.create(params, (RequestOptions)null);
    }

    public static Transfer retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public Transfer cancel() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel((RequestOptions)null);
    }

    public Transfer update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public TransferTransactionCollection transactions(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.transactions(params, (RequestOptions)null);
    }

    @Deprecated
    public static Transfer create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Transfer create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.POST, Transfer.classURL(Transfer.class), params, Transfer.class, options);
    }

    @Deprecated
    public Transfer update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Transfer update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.POST, Transfer.instanceURL(Transfer.class, this.id), params, Transfer.class, options);
    }

    @Deprecated
    public Transfer cancel(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Transfer cancel(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.POST, Transfer.instanceURL(Transfer.class, this.id) + "/cancel", null, Transfer.class, options);
    }

    @Deprecated
    public static Transfer retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Transfer retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.GET, Transfer.instanceURL(Transfer.class, id), null, Transfer.class, options);
    }

    public static TransferCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, null);
    }

    public static TransferCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.requestCollection(Transfer.classURL(Transfer.class), params, TransferCollection.class, options);
    }

    @Deprecated
    public static TransferCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, null);
    }

    @Deprecated
    public static TransferCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static TransferCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, options);
    }

    @Deprecated
    public TransferTransactionCollection transactions(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.transactions(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public TransferTransactionCollection transactions(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Transfer.instanceURL(Transfer.class, this.getId()), "/transactions");
        return Transfer.requestCollection(url, params, TransferTransactionCollection.class, options);
    }
}

