package com.stripe.model;

import com.stripe.net.RequestOptions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Provides a representation of a collection of data from the Stripe API.
 *
 * This implementation is specifically for collections that are unpaged and
 * cannot be iterated.
 */
public abstract class UnpagedStripeCollection<T extends HasId> extends StripeObject implements StripeCollectionInterface<T> {
	List<T> data;
	String url;

	public List<T> getData() {
		return data;
	}
	public void setData(List<T> data) {
		this.data = data;
	}
	public Boolean getHasMore() {
		return false;
	}
	public String getURL() {
		return url;
	}
	public void setURL(String url) {
		this.url = url;
	}
	public RequestOptions getRequestOptions() {
		throw new UnsupportedOperationException("Unpaged collection cannot be paged");
	}
	public Map<String, Object> getRequestParams() {
		throw new UnsupportedOperationException("Unpaged collection cannot be paged");
	}
	public void setRequestOptions(RequestOptions requestOptions) {
	}
	public void setRequestParams(Map<String, Object> requestParams) {
	}
}
