/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.SubscriptionCollection;
import com.stripe.model.SubscriptionItemCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Subscription
extends APIResource
implements MetadataStore<Subscription>,
HasId {
    String id;
    String object;
    Double applicationFeePercent;
    String billing;
    Long billingCycleAnchor;
    Boolean cancelAtPeriodEnd;
    Long canceledAt;
    Long created;
    Long currentPeriodEnd;
    Long currentPeriodStart;
    ExpandableField<Customer> customer;
    Integer daysUntilDue;
    Discount discount;
    Long endedAt;
    SubscriptionItemCollection items;
    Map<String, String> metadata;
    Plan plan;
    Integer quantity;
    Long start;
    String status;
    Double taxPercent;
    Long trialEnd;
    Long trialStart;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Double getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    public void setApplicationFeePercent(Double applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    public String getBilling() {
        return this.billing;
    }

    public void setBilling(String billing) {
        this.billing = billing;
    }

    public Long getBillingCycleAnchor() {
        return this.billingCycleAnchor;
    }

    public void setBillingCycleAnchor(Long billingCycleAnchor) {
        this.billingCycleAnchor = billingCycleAnchor;
    }

    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    }

    public Long getCanceledAt() {
        return this.canceledAt;
    }

    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    public void setCurrentPeriodEnd(Long currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    public void setCurrentPeriodStart(Long currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    public String getCustomer() {
        if (this.customer == null) {
            return null;
        }
        return this.customer.getId();
    }

    public void setCustomer(String customerID) {
        this.customer = Subscription.setExpandableFieldID(customerID, this.customer);
    }

    public Customer getCustomerObject() {
        if (this.customer == null) {
            return null;
        }
        return this.customer.getExpanded();
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public Integer getDaysUntilDue() {
        return this.daysUntilDue;
    }

    public void setDaysUntilDue(Integer daysUntilDue) {
        this.daysUntilDue = daysUntilDue;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public Long getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Double getTaxPercent() {
        return this.taxPercent;
    }

    public void setTaxPercent(Double taxPercent) {
        this.taxPercent = taxPercent;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    public Long getTrialStart() {
        return this.trialStart;
    }

    public void setTrialStart(Long trialStart) {
        this.trialStart = trialStart;
    }

    public SubscriptionItemCollection getSubscriptionItems() {
        return this.items;
    }

    public void setSubscriptionItems(SubscriptionItemCollection items) {
        this.items = items;
    }

    @Deprecated
    public static SubscriptionCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.list(params, null);
    }

    @Deprecated
    public static SubscriptionCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.list(params, options);
    }

    public static Subscription create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.create(params, null);
    }

    public static Subscription create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.POST, Subscription.classURL(Subscription.class), params, Subscription.class, options);
    }

    public static SubscriptionCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.list(params, null);
    }

    public static SubscriptionCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.requestCollection(Subscription.classURL(Subscription.class), params, SubscriptionCollection.class, options);
    }

    public static Subscription retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.retrieve(id, null);
    }

    public static Subscription retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.GET, Subscription.instanceURL(Subscription.class, id), null, Subscription.class, options);
    }

    public static Subscription retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.GET, Subscription.instanceURL(Subscription.class, id), params, Subscription.class, options);
    }

    public Subscription update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.POST, Subscription.instanceURL(Subscription.class, this.id), params, Subscription.class, options);
    }

    public Subscription cancel(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription cancel(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription cancel(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.DELETE, Subscription.instanceURL(Subscription.class, this.id), params, Subscription.class, options);
    }

    public void deleteDiscount() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount((RequestOptions)null);
    }

    @Deprecated
    public void deleteDiscount(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        RequestOptions result = null;
        if (apiKey != null) {
            result = RequestOptions.builder().setApiKey(apiKey).build();
        }
        this.deleteDiscount(result);
    }

    public void deleteDiscount(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Subscription.request(APIResource.RequestMethod.DELETE, String.format("%s/discount", Subscription.instanceURL(Subscription.class, this.id)), null, Discount.class, options);
    }
}

