/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BalanceTransactionCollection;
import com.stripe.model.ExpandableField;
import com.stripe.model.Fee;
import com.stripe.model.HasId;
import com.stripe.model.TransferCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class BalanceTransaction
extends APIResource
implements HasId {
    String id;
    String object;
    Long amount;
    Long availableOn;
    Long created;
    String currency;
    String description;
    Long fee;
    List<Fee> feeDetails;
    Integer net;
    ExpandableField<HasId> source;
    String status;
    String type;
    @Deprecated
    TransferCollection sourcedTransfers;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getAvailableOn() {
        return this.availableOn;
    }

    public void setAvailableOn(Long availableOn) {
        this.availableOn = availableOn;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public List<Fee> getFeeDetails() {
        return this.feeDetails;
    }

    public void setFeeDetails(List<Fee> feeDetails) {
        this.feeDetails = feeDetails;
    }

    public Integer getNet() {
        return this.net;
    }

    public void setNet(Integer net) {
        this.net = net;
    }

    @Deprecated
    public TransferCollection getSourcedTransfers() {
        if (this.sourcedTransfers != null && this.sourcedTransfers.getURL() == null && this.getSource() != null) {
            this.sourcedTransfers.setURL(String.format("/v1/transfers?source_transaction=%s", this.getSource()));
        }
        return this.sourcedTransfers;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getId();
    }

    public void setSource(String sourceID) {
        this.source = BalanceTransaction.setExpandableFieldID(sourceID, this.source);
    }

    public HasId getSourceObject() {
        if (this.source == null) {
            return null;
        }
        return this.source.getExpanded();
    }

    public void setSourceObject(HasId o) {
        this.source = new ExpandableField<HasId>(o.getId(), o);
    }

    public <O extends HasId> O getSourceObjectAs() {
        if (this.source == null) {
            return null;
        }
        return (O)this.source.getExpanded();
    }

    public static BalanceTransaction retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static BalanceTransaction retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static BalanceTransaction retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s/%s", Stripe.getApiBase(), "v1/balance/history", id);
        return BalanceTransaction.request(APIResource.RequestMethod.GET, url, null, BalanceTransaction.class, options);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, null);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s", Stripe.getApiBase(), "v1/balance/history");
        return BalanceTransaction.requestCollection(url, params, BalanceTransactionCollection.class, options);
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, null);
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, options);
    }
}

