package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;

import java.util.Map;


public class Subscription extends APIResource implements MetadataStore<Subscription>, HasId {
  String id;
  String object;
  Double applicationFeePercent;
  String billing;
  Long billingCycleAnchor;
  Boolean cancelAtPeriodEnd;
  Long canceledAt;
  Long created;
  Long currentPeriodEnd;
  Long currentPeriodStart;
  ExpandableField<Customer> customer;
  Integer daysUntilDue;
  Discount discount;
  Long endedAt;
  SubscriptionItemCollection items;
  Map<String, String> metadata;
  Plan plan;
  Integer quantity;
  Long start;
  String status;
  Double taxPercent;
  Long trialEnd;
  Long trialStart;

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getObject() {
    return object;
  }

  public void setObject(String object) {
    this.object = object;
  }

  public Double getApplicationFeePercent() {
    return applicationFeePercent;
  }

  public void setApplicationFeePercent(Double applicationFeePercent) {
    this.applicationFeePercent = applicationFeePercent;
  }

  public String getBilling() {
    return billing;
  }

  public void setBilling(String billing) {
    this.billing = billing;
  }

  public Long getBillingCycleAnchor() {
    return billingCycleAnchor;
  }

  public void setBillingCycleAnchor(Long billingCycleAnchor) {
    this.billingCycleAnchor = billingCycleAnchor;
  }

  public Boolean getCancelAtPeriodEnd() {
    return cancelAtPeriodEnd;
  }

  public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
    this.cancelAtPeriodEnd = cancelAtPeriodEnd;
  }

  public Long getCanceledAt() {
    return canceledAt;
  }

  public void setCanceledAt(Long canceledAt) {
    this.canceledAt = canceledAt;
  }

  public Long getCreated() {
    return created;
  }

  public void setCreated(Long created) {
    this.created = created;
  }

  public Long getCurrentPeriodEnd() {
    return currentPeriodEnd;
  }

  public void setCurrentPeriodEnd(Long currentPeriodEnd) {
    this.currentPeriodEnd = currentPeriodEnd;
  }

  public Long getCurrentPeriodStart() {
    return currentPeriodStart;
  }

  public void setCurrentPeriodStart(Long currentPeriodStart) {
    this.currentPeriodStart = currentPeriodStart;
  }

  public String getCustomer() {
    return (this.customer != null) ? this.customer.getId() : null;
  }

  public void setCustomer(String customerID) {
    this.customer = setExpandableFieldID(customerID, this.customer);
  }

  public Customer getCustomerObject() {
    return (this.customer != null) ? this.customer.getExpanded() : null;
  }

  public void setCustomerObject(Customer c) {
    this.customer = new ExpandableField<Customer>(c.getId(), c);
  }

  public Integer getDaysUntilDue() {
    return daysUntilDue;
  }

  public void setDaysUntilDue(Integer daysUntilDue) {
    this.daysUntilDue = daysUntilDue;
  }

  public Discount getDiscount() {
    return discount;
  }

  public void setDiscount(Discount discount) {
    this.discount = discount;
  }

  public Long getEndedAt() {
    return endedAt;
  }

  public void setEndedAt(Long endedAt) {
    this.endedAt = endedAt;
  }

  public Map<String, String> getMetadata() {
    return metadata;
  }

  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }

  public Plan getPlan() {
    return plan;
  }

  public void setPlan(Plan plan) {
    this.plan = plan;
  }

  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  public Long getStart() {
    return start;
  }

  public void setStart(Long start) {
    this.start = start;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Double getTaxPercent() {
    return taxPercent;
  }

  public void setTaxPercent(Double taxPercent) {
    this.taxPercent = taxPercent;
  }

  public Long getTrialEnd() {
    return trialEnd;
  }

  public void setTrialEnd(Long trialEnd) {
    this.trialEnd = trialEnd;
  }

  public Long getTrialStart() {
    return trialStart;
  }

  public void setTrialStart(Long trialStart) {
    this.trialStart = trialStart;
  }

  public SubscriptionItemCollection getSubscriptionItems() {
    return items;
  }

  public void setSubscriptionItems(SubscriptionItemCollection items) {
    this.items = items;
  }

  @Deprecated
  public static SubscriptionCollection all(Map<String, Object> params)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return list(params, null);
  }

  @Deprecated
  public static SubscriptionCollection all(Map<String, Object> params,
                       RequestOptions options) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return list(params, options);
  }

  public static Subscription create(Map<String, Object> params)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return create(params, null);
  }

  public static Subscription create(Map<String, Object> params, RequestOptions options)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return request(RequestMethod.POST, classURL(Subscription.class), params, Subscription.class,
        options);
  }

  public static SubscriptionCollection list(Map<String, Object> params)
      throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return list(params, null);
  }

  public static SubscriptionCollection list(Map<String, Object> params,
                        RequestOptions options) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return requestCollection(classURL(Subscription.class), params, SubscriptionCollection.class,
        options);
  }

  public static Subscription retrieve(String id) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return retrieve(id, null);
  }

  public static Subscription retrieve(String id, RequestOptions options)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return request(RequestMethod.GET, instanceURL(Subscription.class, id), null, Subscription.class,
        options);
  }

  public static Subscription retrieve(String id, Map<String, Object> params, RequestOptions options)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return request(RequestMethod.GET, instanceURL(Subscription.class, id), params,
        Subscription.class, options);
  }

  public Subscription update(Map<String, Object> params)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return update(params, (RequestOptions) null);
  }

  @Deprecated
  public Subscription update(Map<String, Object> params, String apiKey)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return update(params, RequestOptions.builder().setApiKey(apiKey).build());
  }

  public Subscription update(Map<String, Object> params, RequestOptions options)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return request(RequestMethod.POST, instanceURL(Subscription.class, id), params,
        Subscription.class, options);
  }

  public Subscription cancel(Map<String, Object> params) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return cancel(params, (RequestOptions) null);
  }

  @Deprecated
  public Subscription cancel(Map<String, Object> params, String apiKey)
      throws AuthenticationException, InvalidRequestException, APIConnectionException,
      CardException, APIException {
    return cancel(params, RequestOptions.builder().setApiKey(apiKey).build());
  }

  public Subscription cancel(Map<String, Object> params, RequestOptions options)
      throws AuthenticationException, InvalidRequestException, APIConnectionException,
      CardException, APIException {
    return request(RequestMethod.DELETE, instanceURL(Subscription.class, id), params,
        Subscription.class, options);
  }

  public void deleteDiscount() throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    deleteDiscount((RequestOptions) null);
  }

  /**
   * Deletes the subscription's discount.
   *
   * @deprecated Use {@link #deleteDiscount(RequestOptions)} instead.
   */
  @Deprecated
  public void deleteDiscount(String apiKey) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    RequestOptions result = null;
    if (apiKey != null) {
      result = RequestOptions.builder().setApiKey(apiKey).build();
    }
    deleteDiscount(result);
  }

  public void deleteDiscount(RequestOptions options) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    request(RequestMethod.DELETE, String.format("%s/discount", instanceURL(Subscription.class, id)),
        null, Discount.class, options);
  }
}
