/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.DeletedInvoiceItem;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItemCollection;
import com.stripe.model.InvoiceLineItemPeriod;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class InvoiceItem
extends APIResource
implements MetadataStore<InvoiceItem>,
HasId {
    String id;
    String object;
    Long amount;
    String currency;
    ExpandableField<Customer> customer;
    Long date;
    String description;
    Boolean discountable;
    ExpandableField<Invoice> invoice;
    Boolean livemode;
    Map<String, String> metadata;
    InvoiceLineItemPeriod period;
    Plan plan;
    Boolean proration;
    Integer quantity;
    ExpandableField<Subscription> subscription;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerID) {
        this.customer = InvoiceItem.setExpandableFieldID(customerID, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getDiscountable() {
        return this.discountable;
    }

    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable;
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String invoiceID) {
        this.invoice = InvoiceItem.setExpandableFieldID(invoiceID, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice invoice) {
        this.invoice = new ExpandableField<Invoice>(invoice.getId(), invoice);
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public InvoiceLineItemPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(InvoiceLineItemPeriod period) {
        this.period = period;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public Boolean getProration() {
        return this.proration;
    }

    public void setProration(Boolean proration) {
        this.proration = proration;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String subscriptionID) {
        this.subscription = InvoiceItem.setExpandableFieldID(subscriptionID, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription subscription) {
        this.subscription = new ExpandableField<Subscription>(subscription.getId(), subscription);
    }

    public static InvoiceItem create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.create(params, (RequestOptions)null);
    }

    @Deprecated
    public static InvoiceItem create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static InvoiceItem create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.POST, InvoiceItem.classURL(InvoiceItem.class), params, InvoiceItem.class, options);
    }

    public static InvoiceItem retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static InvoiceItem retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static InvoiceItem retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.GET, InvoiceItem.instanceURL(InvoiceItem.class, id), null, InvoiceItem.class, options);
    }

    public static InvoiceItem retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.GET, InvoiceItem.instanceURL(InvoiceItem.class, id), params, InvoiceItem.class, options);
    }

    public InvoiceItem update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public InvoiceItem update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public InvoiceItem update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.POST, InvoiceItem.instanceURL(InvoiceItem.class, this.id), params, InvoiceItem.class, options);
    }

    public DeletedInvoiceItem delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    @Deprecated
    public DeletedInvoiceItem delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public DeletedInvoiceItem delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.DELETE, InvoiceItem.instanceURL(InvoiceItem.class, this.id), null, DeletedInvoiceItem.class, options);
    }

    public static InvoiceItemCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, null);
    }

    public static InvoiceItemCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.requestCollection(InvoiceItem.classURL(InvoiceItem.class), params, InvoiceItemCollection.class, options);
    }

    @Deprecated
    public static InvoiceItemCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, null);
    }

    @Deprecated
    public static InvoiceItemCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static InvoiceItemCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, options);
    }
}

