/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BitcoinReceiverCollection;
import com.stripe.model.BitcoinTransactionCollection;
import com.stripe.model.DeletedBitcoinReceiver;
import com.stripe.model.ExternalAccount;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class BitcoinReceiver
extends ExternalAccount {
    Boolean active;
    Long amount;
    Long amountReceived;
    Long bitcoinAmount;
    Long bitcoinAmountReceived;
    String bitcoinUri;
    Long created;
    String currency;
    String description;
    String email;
    Boolean filled;
    String inboundAddress;
    Boolean livemode;
    String payment;
    String refundAddress;
    Boolean rejectTransactions;
    String status;
    BitcoinTransactionCollection transactions;
    Boolean uncapturedFunds;
    Boolean usedForPayment;

    public static BitcoinReceiver create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.create(params, null);
    }

    public static BitcoinReceiver create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.POST, String.format("%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers"), params, BitcoinReceiver.class, options);
    }

    public static BitcoinReceiver retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.retrieve(id, null);
    }

    public static BitcoinReceiver retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.GET, String.format("%s/%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers", id), null, BitcoinReceiver.class, options);
    }

    public static BitcoinReceiverCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.list(params, null);
    }

    public static BitcoinReceiverCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers");
        return BitcoinReceiver.requestCollection(url, params, BitcoinReceiverCollection.class, options);
    }

    @Deprecated
    public static BitcoinReceiverCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.list(params, null);
    }

    @Deprecated
    public static BitcoinReceiverCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.list(params, options);
    }

    @Override
    public BitcoinReceiver update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public BitcoinReceiver update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, BitcoinReceiver.class, options);
    }

    @Override
    public DeletedBitcoinReceiver delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    @Override
    public DeletedBitcoinReceiver delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), null, DeletedBitcoinReceiver.class, options);
    }

    @Override
    protected String getInstanceURL() {
        String result = super.getInstanceURL();
        if (result == null) {
            return String.format("%s/%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers", this.getId());
        }
        return result;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Long getAmountReceived() {
        return this.amountReceived;
    }

    public Long getBitcoinAmount() {
        return this.bitcoinAmount;
    }

    public Long getBitcoinAmountReceived() {
        return this.bitcoinAmountReceived;
    }

    public String getBitcoinUri() {
        return this.bitcoinUri;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getFilled() {
        return this.filled;
    }

    public String getInboundAddress() {
        return this.inboundAddress;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public String getPayment() {
        return this.payment;
    }

    public String getRefundAddress() {
        return this.refundAddress;
    }

    public Boolean getRejectTransactions() {
        return this.rejectTransactions;
    }

    public String getStatus() {
        return this.status;
    }

    public BitcoinTransactionCollection getTransactions() {
        return this.transactions;
    }

    public Boolean getUncapturedFunds() {
        return this.uncapturedFunds;
    }

    public Boolean getUsedForPayment() {
        return this.usedForPayment;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public void setAmountReceived(Long amountReceived) {
        this.amountReceived = amountReceived;
    }

    public void setBitcoinAmount(Long bitcoinAmount) {
        this.bitcoinAmount = bitcoinAmount;
    }

    public void setBitcoinAmountReceived(Long bitcoinAmountReceived) {
        this.bitcoinAmountReceived = bitcoinAmountReceived;
    }

    public void setBitcoinUri(String bitcoinUri) {
        this.bitcoinUri = bitcoinUri;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFilled(Boolean filled) {
        this.filled = filled;
    }

    public void setInboundAddress(String inboundAddress) {
        this.inboundAddress = inboundAddress;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public void setPayment(String payment) {
        this.payment = payment;
    }

    public void setRefundAddress(String refundAddress) {
        this.refundAddress = refundAddress;
    }

    public void setRejectTransactions(Boolean rejectTransactions) {
        this.rejectTransactions = rejectTransactions;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTransactions(BitcoinTransactionCollection transactions) {
        this.transactions = transactions;
    }

    public void setUncapturedFunds(Boolean uncapturedFunds) {
        this.uncapturedFunds = uncapturedFunds;
    }

    public void setUsedForPayment(Boolean usedForPayment) {
        this.usedForPayment = usedForPayment;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitcoinReceiver)) {
            return false;
        }
        BitcoinReceiver other = (BitcoinReceiver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountReceived = this.getAmountReceived();
        Long other$amountReceived = other.getAmountReceived();
        if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
            return false;
        }
        Long this$bitcoinAmount = this.getBitcoinAmount();
        Long other$bitcoinAmount = other.getBitcoinAmount();
        if (this$bitcoinAmount == null ? other$bitcoinAmount != null : !((Object)this$bitcoinAmount).equals(other$bitcoinAmount)) {
            return false;
        }
        Long this$bitcoinAmountReceived = this.getBitcoinAmountReceived();
        Long other$bitcoinAmountReceived = other.getBitcoinAmountReceived();
        if (this$bitcoinAmountReceived == null ? other$bitcoinAmountReceived != null : !((Object)this$bitcoinAmountReceived).equals(other$bitcoinAmountReceived)) {
            return false;
        }
        String this$bitcoinUri = this.getBitcoinUri();
        String other$bitcoinUri = other.getBitcoinUri();
        if (this$bitcoinUri == null ? other$bitcoinUri != null : !this$bitcoinUri.equals(other$bitcoinUri)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Boolean this$filled = this.getFilled();
        Boolean other$filled = other.getFilled();
        if (this$filled == null ? other$filled != null : !((Object)this$filled).equals(other$filled)) {
            return false;
        }
        String this$inboundAddress = this.getInboundAddress();
        String other$inboundAddress = other.getInboundAddress();
        if (this$inboundAddress == null ? other$inboundAddress != null : !this$inboundAddress.equals(other$inboundAddress)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$payment = this.getPayment();
        String other$payment = other.getPayment();
        if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) {
            return false;
        }
        String this$refundAddress = this.getRefundAddress();
        String other$refundAddress = other.getRefundAddress();
        if (this$refundAddress == null ? other$refundAddress != null : !this$refundAddress.equals(other$refundAddress)) {
            return false;
        }
        Boolean this$rejectTransactions = this.getRejectTransactions();
        Boolean other$rejectTransactions = other.getRejectTransactions();
        if (this$rejectTransactions == null ? other$rejectTransactions != null : !((Object)this$rejectTransactions).equals(other$rejectTransactions)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        BitcoinTransactionCollection this$transactions = this.getTransactions();
        BitcoinTransactionCollection other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions)) {
            return false;
        }
        Boolean this$uncapturedFunds = this.getUncapturedFunds();
        Boolean other$uncapturedFunds = other.getUncapturedFunds();
        if (this$uncapturedFunds == null ? other$uncapturedFunds != null : !((Object)this$uncapturedFunds).equals(other$uncapturedFunds)) {
            return false;
        }
        Boolean this$usedForPayment = this.getUsedForPayment();
        Boolean other$usedForPayment = other.getUsedForPayment();
        return !(this$usedForPayment == null ? other$usedForPayment != null : !((Object)this$usedForPayment).equals(other$usedForPayment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BitcoinReceiver;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountReceived = this.getAmountReceived();
        result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
        Long $bitcoinAmount = this.getBitcoinAmount();
        result = result * 59 + ($bitcoinAmount == null ? 43 : ((Object)$bitcoinAmount).hashCode());
        Long $bitcoinAmountReceived = this.getBitcoinAmountReceived();
        result = result * 59 + ($bitcoinAmountReceived == null ? 43 : ((Object)$bitcoinAmountReceived).hashCode());
        String $bitcoinUri = this.getBitcoinUri();
        result = result * 59 + ($bitcoinUri == null ? 43 : $bitcoinUri.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Boolean $filled = this.getFilled();
        result = result * 59 + ($filled == null ? 43 : ((Object)$filled).hashCode());
        String $inboundAddress = this.getInboundAddress();
        result = result * 59 + ($inboundAddress == null ? 43 : $inboundAddress.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : $payment.hashCode());
        String $refundAddress = this.getRefundAddress();
        result = result * 59 + ($refundAddress == null ? 43 : $refundAddress.hashCode());
        Boolean $rejectTransactions = this.getRejectTransactions();
        result = result * 59 + ($rejectTransactions == null ? 43 : ((Object)$rejectTransactions).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        BitcoinTransactionCollection $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : $transactions.hashCode());
        Boolean $uncapturedFunds = this.getUncapturedFunds();
        result = result * 59 + ($uncapturedFunds == null ? 43 : ((Object)$uncapturedFunds).hashCode());
        Boolean $usedForPayment = this.getUsedForPayment();
        result = result * 59 + ($usedForPayment == null ? 43 : ((Object)$usedForPayment).hashCode());
        return result;
    }
}

