/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.CountrySpecCollection;
import com.stripe.model.HasId;
import com.stripe.model.VerificationFields;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class CountrySpec
extends APIResource
implements HasId {
    String id;
    String object;
    String defaultCurrency;
    Map<String, List<String>> supportedBankAccountCurrencies;
    List<String> supportedPaymentCurrencies;
    List<String> supportedPaymentMethods;
    VerificationFields verificationFields;

    public static CountrySpec retrieve(String country) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return CountrySpec.retrieve(country, null);
    }

    public static CountrySpec retrieve(String country, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return CountrySpec.request(APIResource.RequestMethod.GET, CountrySpec.instanceURL(CountrySpec.class, country), null, CountrySpec.class, options);
    }

    public static CountrySpecCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return CountrySpec.list(params, null);
    }

    public static CountrySpecCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return CountrySpec.requestCollection(CountrySpec.classURL(CountrySpec.class), params, CountrySpecCollection.class, options);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public Map<String, List<String>> getSupportedBankAccountCurrencies() {
        return this.supportedBankAccountCurrencies;
    }

    public List<String> getSupportedPaymentCurrencies() {
        return this.supportedPaymentCurrencies;
    }

    public List<String> getSupportedPaymentMethods() {
        return this.supportedPaymentMethods;
    }

    public VerificationFields getVerificationFields() {
        return this.verificationFields;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public void setSupportedBankAccountCurrencies(Map<String, List<String>> supportedBankAccountCurrencies) {
        this.supportedBankAccountCurrencies = supportedBankAccountCurrencies;
    }

    public void setSupportedPaymentCurrencies(List<String> supportedPaymentCurrencies) {
        this.supportedPaymentCurrencies = supportedPaymentCurrencies;
    }

    public void setSupportedPaymentMethods(List<String> supportedPaymentMethods) {
        this.supportedPaymentMethods = supportedPaymentMethods;
    }

    public void setVerificationFields(VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountrySpec)) {
            return false;
        }
        CountrySpec other = (CountrySpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        Map<String, List<String>> this$supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
        Map<String, List<String>> other$supportedBankAccountCurrencies = other.getSupportedBankAccountCurrencies();
        if (this$supportedBankAccountCurrencies == null ? other$supportedBankAccountCurrencies != null : !((Object)this$supportedBankAccountCurrencies).equals(other$supportedBankAccountCurrencies)) {
            return false;
        }
        List<String> this$supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
        List<String> other$supportedPaymentCurrencies = other.getSupportedPaymentCurrencies();
        if (this$supportedPaymentCurrencies == null ? other$supportedPaymentCurrencies != null : !((Object)this$supportedPaymentCurrencies).equals(other$supportedPaymentCurrencies)) {
            return false;
        }
        List<String> this$supportedPaymentMethods = this.getSupportedPaymentMethods();
        List<String> other$supportedPaymentMethods = other.getSupportedPaymentMethods();
        if (this$supportedPaymentMethods == null ? other$supportedPaymentMethods != null : !((Object)this$supportedPaymentMethods).equals(other$supportedPaymentMethods)) {
            return false;
        }
        VerificationFields this$verificationFields = this.getVerificationFields();
        VerificationFields other$verificationFields = other.getVerificationFields();
        return !(this$verificationFields == null ? other$verificationFields != null : !((Object)this$verificationFields).equals(other$verificationFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CountrySpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        Map<String, List<String>> $supportedBankAccountCurrencies = this.getSupportedBankAccountCurrencies();
        result = result * 59 + ($supportedBankAccountCurrencies == null ? 43 : ((Object)$supportedBankAccountCurrencies).hashCode());
        List<String> $supportedPaymentCurrencies = this.getSupportedPaymentCurrencies();
        result = result * 59 + ($supportedPaymentCurrencies == null ? 43 : ((Object)$supportedPaymentCurrencies).hashCode());
        List<String> $supportedPaymentMethods = this.getSupportedPaymentMethods();
        result = result * 59 + ($supportedPaymentMethods == null ? 43 : ((Object)$supportedPaymentMethods).hashCode());
        VerificationFields $verificationFields = this.getVerificationFields();
        result = result * 59 + ($verificationFields == null ? 43 : ((Object)$verificationFields).hashCode());
        return result;
    }
}

