/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Charge;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Invoice
extends APIResource
implements MetadataStore<Invoice>,
HasId {
    String id;
    String object;
    Long amountDue;
    Long applicationFee;
    Integer attemptCount;
    Boolean attempted;
    String billing;
    ExpandableField<Charge> charge;
    Boolean closed;
    Long created;
    String currency;
    String customer;
    Long date;
    String description;
    Discount discount;
    Long dueDate;
    Long endingBalance;
    Boolean forgiven;
    InvoiceLineItemCollection lines;
    Boolean livemode;
    Map<String, String> metadata;
    Long nextPaymentAttempt;
    String number;
    Boolean paid;
    Long periodEnd;
    Long periodStart;
    String receiptNumber;
    Long startingBalance;
    String statementDescriptor;
    ExpandableField<Subscription> subscription;
    Long subscriptionProrationDate;
    Long subtotal;
    Long tax;
    Double taxPercent;
    Long total;
    Long webhooksDeliveredAt;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String chargeID) {
        this.charge = Invoice.setExpandableFieldID(chargeID, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge charge) {
        this.charge = new ExpandableField<Charge>(charge.getId(), charge);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String subscriptionID) {
        this.subscription = Invoice.setExpandableFieldID(subscriptionID, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription subscription) {
        this.subscription = new ExpandableField<Subscription>(subscription.getId(), subscription);
    }

    public static Invoice retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static Invoice retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), null, Invoice.class, options);
    }

    public static Invoice retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), params, Invoice.class, options);
    }

    public static Invoice create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, (RequestOptions)null);
    }

    @Deprecated
    public static Invoice create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.classURL(Invoice.class), params, Invoice.class, options);
    }

    public static Invoice upcoming(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, (RequestOptions)null);
    }

    @Deprecated
    public static Invoice upcoming(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice upcoming(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, String.format("%s/upcoming", Invoice.classURL(Invoice.class)), params, Invoice.class, options);
    }

    public Invoice pay() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay((RequestOptions)null);
    }

    public Invoice pay(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(params, null);
    }

    @Deprecated
    public Invoice pay(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Invoice pay(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(null, options);
    }

    public Invoice pay(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, String.format("%s/pay", Invoice.instanceURL(Invoice.class, this.getId())), params, Invoice.class, options);
    }

    public Invoice update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Invoice update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Invoice update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.instanceURL(Invoice.class, this.id), params, Invoice.class, options);
    }

    public static InvoiceCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, null);
    }

    public static InvoiceCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.requestCollection(Invoice.classURL(Invoice.class), params, InvoiceCollection.class, options);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, null);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, options);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Long getAmountDue() {
        return this.amountDue;
    }

    public Long getApplicationFee() {
        return this.applicationFee;
    }

    public Integer getAttemptCount() {
        return this.attemptCount;
    }

    public Boolean getAttempted() {
        return this.attempted;
    }

    public String getBilling() {
        return this.billing;
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCustomer() {
        return this.customer;
    }

    public Long getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public Long getDueDate() {
        return this.dueDate;
    }

    public Long getEndingBalance() {
        return this.endingBalance;
    }

    public Boolean getForgiven() {
        return this.forgiven;
    }

    public InvoiceLineItemCollection getLines() {
        return this.lines;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Long getNextPaymentAttempt() {
        return this.nextPaymentAttempt;
    }

    public String getNumber() {
        return this.number;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public Long getPeriodEnd() {
        return this.periodEnd;
    }

    public Long getPeriodStart() {
        return this.periodStart;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public Long getStartingBalance() {
        return this.startingBalance;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public Long getSubscriptionProrationDate() {
        return this.subscriptionProrationDate;
    }

    public Long getSubtotal() {
        return this.subtotal;
    }

    public Long getTax() {
        return this.tax;
    }

    public Double getTaxPercent() {
        return this.taxPercent;
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getWebhooksDeliveredAt() {
        return this.webhooksDeliveredAt;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setAmountDue(Long amountDue) {
        this.amountDue = amountDue;
    }

    public void setApplicationFee(Long applicationFee) {
        this.applicationFee = applicationFee;
    }

    public void setAttemptCount(Integer attemptCount) {
        this.attemptCount = attemptCount;
    }

    public void setAttempted(Boolean attempted) {
        this.attempted = attempted;
    }

    public void setBilling(String billing) {
        this.billing = billing;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public void setDueDate(Long dueDate) {
        this.dueDate = dueDate;
    }

    public void setEndingBalance(Long endingBalance) {
        this.endingBalance = endingBalance;
    }

    public void setForgiven(Boolean forgiven) {
        this.forgiven = forgiven;
    }

    public void setLines(InvoiceLineItemCollection lines) {
        this.lines = lines;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setNextPaymentAttempt(Long nextPaymentAttempt) {
        this.nextPaymentAttempt = nextPaymentAttempt;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public void setStartingBalance(Long startingBalance) {
        this.startingBalance = startingBalance;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public void setSubscriptionProrationDate(Long subscriptionProrationDate) {
        this.subscriptionProrationDate = subscriptionProrationDate;
    }

    public void setSubtotal(Long subtotal) {
        this.subtotal = subtotal;
    }

    public void setTax(Long tax) {
        this.tax = tax;
    }

    public void setTaxPercent(Double taxPercent) {
        this.taxPercent = taxPercent;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setWebhooksDeliveredAt(Long webhooksDeliveredAt) {
        this.webhooksDeliveredAt = webhooksDeliveredAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amountDue = this.getAmountDue();
        Long other$amountDue = other.getAmountDue();
        if (this$amountDue == null ? other$amountDue != null : !((Object)this$amountDue).equals(other$amountDue)) {
            return false;
        }
        Long this$applicationFee = this.getApplicationFee();
        Long other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !((Object)this$applicationFee).equals(other$applicationFee)) {
            return false;
        }
        Integer this$attemptCount = this.getAttemptCount();
        Integer other$attemptCount = other.getAttemptCount();
        if (this$attemptCount == null ? other$attemptCount != null : !((Object)this$attemptCount).equals(other$attemptCount)) {
            return false;
        }
        Boolean this$attempted = this.getAttempted();
        Boolean other$attempted = other.getAttempted();
        if (this$attempted == null ? other$attempted != null : !((Object)this$attempted).equals(other$attempted)) {
            return false;
        }
        String this$billing = this.getBilling();
        String other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        Boolean this$closed = this.getClosed();
        Boolean other$closed = other.getClosed();
        if (this$closed == null ? other$closed != null : !((Object)this$closed).equals(other$closed)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Long this$dueDate = this.getDueDate();
        Long other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Long this$endingBalance = this.getEndingBalance();
        Long other$endingBalance = other.getEndingBalance();
        if (this$endingBalance == null ? other$endingBalance != null : !((Object)this$endingBalance).equals(other$endingBalance)) {
            return false;
        }
        Boolean this$forgiven = this.getForgiven();
        Boolean other$forgiven = other.getForgiven();
        if (this$forgiven == null ? other$forgiven != null : !((Object)this$forgiven).equals(other$forgiven)) {
            return false;
        }
        InvoiceLineItemCollection this$lines = this.getLines();
        InvoiceLineItemCollection other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !this$lines.equals(other$lines)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Long this$nextPaymentAttempt = this.getNextPaymentAttempt();
        Long other$nextPaymentAttempt = other.getNextPaymentAttempt();
        if (this$nextPaymentAttempt == null ? other$nextPaymentAttempt != null : !((Object)this$nextPaymentAttempt).equals(other$nextPaymentAttempt)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        Boolean this$paid = this.getPaid();
        Boolean other$paid = other.getPaid();
        if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
            return false;
        }
        Long this$periodEnd = this.getPeriodEnd();
        Long other$periodEnd = other.getPeriodEnd();
        if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
            return false;
        }
        Long this$periodStart = this.getPeriodStart();
        Long other$periodStart = other.getPeriodStart();
        if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        Long this$startingBalance = this.getStartingBalance();
        Long other$startingBalance = other.getStartingBalance();
        if (this$startingBalance == null ? other$startingBalance != null : !((Object)this$startingBalance).equals(other$startingBalance)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        Long this$subscriptionProrationDate = this.getSubscriptionProrationDate();
        Long other$subscriptionProrationDate = other.getSubscriptionProrationDate();
        if (this$subscriptionProrationDate == null ? other$subscriptionProrationDate != null : !((Object)this$subscriptionProrationDate).equals(other$subscriptionProrationDate)) {
            return false;
        }
        Long this$subtotal = this.getSubtotal();
        Long other$subtotal = other.getSubtotal();
        if (this$subtotal == null ? other$subtotal != null : !((Object)this$subtotal).equals(other$subtotal)) {
            return false;
        }
        Long this$tax = this.getTax();
        Long other$tax = other.getTax();
        if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
            return false;
        }
        Double this$taxPercent = this.getTaxPercent();
        Double other$taxPercent = other.getTaxPercent();
        if (this$taxPercent == null ? other$taxPercent != null : !((Object)this$taxPercent).equals(other$taxPercent)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Long this$webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        Long other$webhooksDeliveredAt = other.getWebhooksDeliveredAt();
        return !(this$webhooksDeliveredAt == null ? other$webhooksDeliveredAt != null : !((Object)this$webhooksDeliveredAt).equals(other$webhooksDeliveredAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amountDue = this.getAmountDue();
        result = result * 59 + ($amountDue == null ? 43 : ((Object)$amountDue).hashCode());
        Long $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : ((Object)$applicationFee).hashCode());
        Integer $attemptCount = this.getAttemptCount();
        result = result * 59 + ($attemptCount == null ? 43 : ((Object)$attemptCount).hashCode());
        Boolean $attempted = this.getAttempted();
        result = result * 59 + ($attempted == null ? 43 : ((Object)$attempted).hashCode());
        String $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : $billing.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        Boolean $closed = this.getClosed();
        result = result * 59 + ($closed == null ? 43 : ((Object)$closed).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Long $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Long $endingBalance = this.getEndingBalance();
        result = result * 59 + ($endingBalance == null ? 43 : ((Object)$endingBalance).hashCode());
        Boolean $forgiven = this.getForgiven();
        result = result * 59 + ($forgiven == null ? 43 : ((Object)$forgiven).hashCode());
        InvoiceLineItemCollection $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : $lines.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Long $nextPaymentAttempt = this.getNextPaymentAttempt();
        result = result * 59 + ($nextPaymentAttempt == null ? 43 : ((Object)$nextPaymentAttempt).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        Boolean $paid = this.getPaid();
        result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
        Long $periodEnd = this.getPeriodEnd();
        result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
        Long $periodStart = this.getPeriodStart();
        result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        Long $startingBalance = this.getStartingBalance();
        result = result * 59 + ($startingBalance == null ? 43 : ((Object)$startingBalance).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        Long $subscriptionProrationDate = this.getSubscriptionProrationDate();
        result = result * 59 + ($subscriptionProrationDate == null ? 43 : ((Object)$subscriptionProrationDate).hashCode());
        Long $subtotal = this.getSubtotal();
        result = result * 59 + ($subtotal == null ? 43 : ((Object)$subtotal).hashCode());
        Long $tax = this.getTax();
        result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
        Double $taxPercent = this.getTaxPercent();
        result = result * 59 + ($taxPercent == null ? 43 : ((Object)$taxPercent).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Long $webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        result = result * 59 + ($webhooksDeliveredAt == null ? 43 : ((Object)$webhooksDeliveredAt).hashCode());
        return result;
    }
}

