/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.AccountCollection;
import com.stripe.model.AccountDeclineChargeOn;
import com.stripe.model.AccountPayoutSchedule;
import com.stripe.model.AccountTosAcceptance;
import com.stripe.model.AccountTransferSchedule;
import com.stripe.model.DeletedAccount;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.HasId;
import com.stripe.model.LegalEntity;
import com.stripe.model.LoginLinkCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Account
extends APIResource
implements HasId,
MetadataStore<Account> {
    String id;
    String object;
    String businessLogo;
    String businessName;
    String businessPrimaryColor;
    @SerializedName(value="business_url")
    String businessURL;
    Boolean chargesEnabled;
    String country;
    Boolean debitNegativeBalances;
    AccountDeclineChargeOn declineChargeOn;
    String defaultCurrency;
    Boolean detailsSubmitted;
    String displayName;
    LoginLinkCollection loginLinks;
    String email;
    ExternalAccountCollection externalAccounts;
    Keys keys;
    LegalEntity legalEntity;
    Map<String, String> metadata;
    Boolean payoutsEnabled;
    AccountPayoutSchedule payoutSchedule;
    String productDescription;
    String statementDescriptor;
    String supportEmail;
    String supportPhone;
    @SerializedName(value="support_url")
    String supportURL;
    String timezone;
    AccountTosAcceptance tosAcceptance;
    AccountTransferSchedule transferSchedule;
    Boolean transfersEnabled;
    String type;
    Verification verification;
    @Deprecated
    Boolean managed;
    @Deprecated
    List<String> currenciesSupported;

    public static Account create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.create(params, null);
    }

    public static Account create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.classURL(Account.class), params, Account.class, options);
    }

    public static AccountCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, null);
    }

    public static AccountCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.requestCollection(Account.classURL(Account.class), params, AccountCollection.class, options);
    }

    @Deprecated
    public static AccountCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, null);
    }

    @Deprecated
    public static AccountCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.list(params, options);
    }

    public static Account retrieve() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.retrieve((RequestOptions)null);
    }

    @Deprecated
    public static Account retrieve(String apiKeyOrAccountId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (null == apiKeyOrAccountId || apiKeyOrAccountId.startsWith("sk_")) {
            return Account.retrieve(RequestOptions.builder().setApiKey(apiKeyOrAccountId).build());
        }
        return Account.retrieve(apiKeyOrAccountId, null);
    }

    public static Account retrieve(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.singleClassURL(Account.class), null, Account.class, options);
    }

    public static Account retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.instanceURL(Account.class, id), null, Account.class, options);
    }

    public static Account retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.GET, Account.instanceURL(Account.class, id), params, Account.class, options);
    }

    public Account update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Account update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, Account.instanceURL(Account.class, this.id), params, Account.class, options);
    }

    public DeletedAccount delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null, null);
    }

    public DeletedAccount delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null, options);
    }

    public DeletedAccount delete(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(params, null);
    }

    public DeletedAccount delete(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.DELETE, Account.instanceURL(Account.class, this.id), params, DeletedAccount.class, options);
    }

    public Account reject(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.reject(params, null);
    }

    public Account reject(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Account.request(APIResource.RequestMethod.POST, String.format("%s/reject", Account.instanceURL(Account.class, this.getId())), params, Account.class, options);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public String getBusinessLogo() {
        return this.businessLogo;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getBusinessPrimaryColor() {
        return this.businessPrimaryColor;
    }

    public String getBusinessURL() {
        return this.businessURL;
    }

    public Boolean getChargesEnabled() {
        return this.chargesEnabled;
    }

    public String getCountry() {
        return this.country;
    }

    public Boolean getDebitNegativeBalances() {
        return this.debitNegativeBalances;
    }

    public AccountDeclineChargeOn getDeclineChargeOn() {
        return this.declineChargeOn;
    }

    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public Boolean getDetailsSubmitted() {
        return this.detailsSubmitted;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LoginLinkCollection getLoginLinks() {
        return this.loginLinks;
    }

    public String getEmail() {
        return this.email;
    }

    public ExternalAccountCollection getExternalAccounts() {
        return this.externalAccounts;
    }

    public Keys getKeys() {
        return this.keys;
    }

    public LegalEntity getLegalEntity() {
        return this.legalEntity;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Boolean getPayoutsEnabled() {
        return this.payoutsEnabled;
    }

    public AccountPayoutSchedule getPayoutSchedule() {
        return this.payoutSchedule;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public String getSupportEmail() {
        return this.supportEmail;
    }

    public String getSupportPhone() {
        return this.supportPhone;
    }

    public String getSupportURL() {
        return this.supportURL;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public AccountTosAcceptance getTosAcceptance() {
        return this.tosAcceptance;
    }

    public AccountTransferSchedule getTransferSchedule() {
        return this.transferSchedule;
    }

    public Boolean getTransfersEnabled() {
        return this.transfersEnabled;
    }

    public String getType() {
        return this.type;
    }

    public Verification getVerification() {
        return this.verification;
    }

    @Deprecated
    public Boolean getManaged() {
        return this.managed;
    }

    @Deprecated
    public List<String> getCurrenciesSupported() {
        return this.currenciesSupported;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setBusinessLogo(String businessLogo) {
        this.businessLogo = businessLogo;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public void setBusinessPrimaryColor(String businessPrimaryColor) {
        this.businessPrimaryColor = businessPrimaryColor;
    }

    public void setBusinessURL(String businessURL) {
        this.businessURL = businessURL;
    }

    public void setChargesEnabled(Boolean chargesEnabled) {
        this.chargesEnabled = chargesEnabled;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setDebitNegativeBalances(Boolean debitNegativeBalances) {
        this.debitNegativeBalances = debitNegativeBalances;
    }

    public void setDeclineChargeOn(AccountDeclineChargeOn declineChargeOn) {
        this.declineChargeOn = declineChargeOn;
    }

    public void setDefaultCurrency(String defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    public void setDetailsSubmitted(Boolean detailsSubmitted) {
        this.detailsSubmitted = detailsSubmitted;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setLoginLinks(LoginLinkCollection loginLinks) {
        this.loginLinks = loginLinks;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setExternalAccounts(ExternalAccountCollection externalAccounts) {
        this.externalAccounts = externalAccounts;
    }

    public void setKeys(Keys keys) {
        this.keys = keys;
    }

    public void setLegalEntity(LegalEntity legalEntity) {
        this.legalEntity = legalEntity;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setPayoutsEnabled(Boolean payoutsEnabled) {
        this.payoutsEnabled = payoutsEnabled;
    }

    public void setPayoutSchedule(AccountPayoutSchedule payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public void setSupportEmail(String supportEmail) {
        this.supportEmail = supportEmail;
    }

    public void setSupportPhone(String supportPhone) {
        this.supportPhone = supportPhone;
    }

    public void setSupportURL(String supportURL) {
        this.supportURL = supportURL;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setTosAcceptance(AccountTosAcceptance tosAcceptance) {
        this.tosAcceptance = tosAcceptance;
    }

    public void setTransferSchedule(AccountTransferSchedule transferSchedule) {
        this.transferSchedule = transferSchedule;
    }

    public void setTransfersEnabled(Boolean transfersEnabled) {
        this.transfersEnabled = transfersEnabled;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVerification(Verification verification) {
        this.verification = verification;
    }

    @Deprecated
    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    @Deprecated
    public void setCurrenciesSupported(List<String> currenciesSupported) {
        this.currenciesSupported = currenciesSupported;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$businessLogo = this.getBusinessLogo();
        String other$businessLogo = other.getBusinessLogo();
        if (this$businessLogo == null ? other$businessLogo != null : !this$businessLogo.equals(other$businessLogo)) {
            return false;
        }
        String this$businessName = this.getBusinessName();
        String other$businessName = other.getBusinessName();
        if (this$businessName == null ? other$businessName != null : !this$businessName.equals(other$businessName)) {
            return false;
        }
        String this$businessPrimaryColor = this.getBusinessPrimaryColor();
        String other$businessPrimaryColor = other.getBusinessPrimaryColor();
        if (this$businessPrimaryColor == null ? other$businessPrimaryColor != null : !this$businessPrimaryColor.equals(other$businessPrimaryColor)) {
            return false;
        }
        String this$businessURL = this.getBusinessURL();
        String other$businessURL = other.getBusinessURL();
        if (this$businessURL == null ? other$businessURL != null : !this$businessURL.equals(other$businessURL)) {
            return false;
        }
        Boolean this$chargesEnabled = this.getChargesEnabled();
        Boolean other$chargesEnabled = other.getChargesEnabled();
        if (this$chargesEnabled == null ? other$chargesEnabled != null : !((Object)this$chargesEnabled).equals(other$chargesEnabled)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        Boolean this$debitNegativeBalances = this.getDebitNegativeBalances();
        Boolean other$debitNegativeBalances = other.getDebitNegativeBalances();
        if (this$debitNegativeBalances == null ? other$debitNegativeBalances != null : !((Object)this$debitNegativeBalances).equals(other$debitNegativeBalances)) {
            return false;
        }
        AccountDeclineChargeOn this$declineChargeOn = this.getDeclineChargeOn();
        AccountDeclineChargeOn other$declineChargeOn = other.getDeclineChargeOn();
        if (this$declineChargeOn == null ? other$declineChargeOn != null : !((Object)this$declineChargeOn).equals(other$declineChargeOn)) {
            return false;
        }
        String this$defaultCurrency = this.getDefaultCurrency();
        String other$defaultCurrency = other.getDefaultCurrency();
        if (this$defaultCurrency == null ? other$defaultCurrency != null : !this$defaultCurrency.equals(other$defaultCurrency)) {
            return false;
        }
        Boolean this$detailsSubmitted = this.getDetailsSubmitted();
        Boolean other$detailsSubmitted = other.getDetailsSubmitted();
        if (this$detailsSubmitted == null ? other$detailsSubmitted != null : !((Object)this$detailsSubmitted).equals(other$detailsSubmitted)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        LoginLinkCollection this$loginLinks = this.getLoginLinks();
        LoginLinkCollection other$loginLinks = other.getLoginLinks();
        if (this$loginLinks == null ? other$loginLinks != null : !this$loginLinks.equals(other$loginLinks)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        ExternalAccountCollection this$externalAccounts = this.getExternalAccounts();
        ExternalAccountCollection other$externalAccounts = other.getExternalAccounts();
        if (this$externalAccounts == null ? other$externalAccounts != null : !this$externalAccounts.equals(other$externalAccounts)) {
            return false;
        }
        Keys this$keys = this.getKeys();
        Keys other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        LegalEntity this$legalEntity = this.getLegalEntity();
        LegalEntity other$legalEntity = other.getLegalEntity();
        if (this$legalEntity == null ? other$legalEntity != null : !((Object)this$legalEntity).equals(other$legalEntity)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Boolean this$payoutsEnabled = this.getPayoutsEnabled();
        Boolean other$payoutsEnabled = other.getPayoutsEnabled();
        if (this$payoutsEnabled == null ? other$payoutsEnabled != null : !((Object)this$payoutsEnabled).equals(other$payoutsEnabled)) {
            return false;
        }
        AccountPayoutSchedule this$payoutSchedule = this.getPayoutSchedule();
        AccountPayoutSchedule other$payoutSchedule = other.getPayoutSchedule();
        if (this$payoutSchedule == null ? other$payoutSchedule != null : !((Object)this$payoutSchedule).equals(other$payoutSchedule)) {
            return false;
        }
        String this$productDescription = this.getProductDescription();
        String other$productDescription = other.getProductDescription();
        if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$supportEmail = this.getSupportEmail();
        String other$supportEmail = other.getSupportEmail();
        if (this$supportEmail == null ? other$supportEmail != null : !this$supportEmail.equals(other$supportEmail)) {
            return false;
        }
        String this$supportPhone = this.getSupportPhone();
        String other$supportPhone = other.getSupportPhone();
        if (this$supportPhone == null ? other$supportPhone != null : !this$supportPhone.equals(other$supportPhone)) {
            return false;
        }
        String this$supportURL = this.getSupportURL();
        String other$supportURL = other.getSupportURL();
        if (this$supportURL == null ? other$supportURL != null : !this$supportURL.equals(other$supportURL)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        AccountTosAcceptance this$tosAcceptance = this.getTosAcceptance();
        AccountTosAcceptance other$tosAcceptance = other.getTosAcceptance();
        if (this$tosAcceptance == null ? other$tosAcceptance != null : !((Object)this$tosAcceptance).equals(other$tosAcceptance)) {
            return false;
        }
        AccountTransferSchedule this$transferSchedule = this.getTransferSchedule();
        AccountTransferSchedule other$transferSchedule = other.getTransferSchedule();
        if (this$transferSchedule == null ? other$transferSchedule != null : !((Object)this$transferSchedule).equals(other$transferSchedule)) {
            return false;
        }
        Boolean this$transfersEnabled = this.getTransfersEnabled();
        Boolean other$transfersEnabled = other.getTransfersEnabled();
        if (this$transfersEnabled == null ? other$transfersEnabled != null : !((Object)this$transfersEnabled).equals(other$transfersEnabled)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Verification this$verification = this.getVerification();
        Verification other$verification = other.getVerification();
        if (this$verification == null ? other$verification != null : !((Object)this$verification).equals(other$verification)) {
            return false;
        }
        Boolean this$managed = this.getManaged();
        Boolean other$managed = other.getManaged();
        if (this$managed == null ? other$managed != null : !((Object)this$managed).equals(other$managed)) {
            return false;
        }
        List<String> this$currenciesSupported = this.getCurrenciesSupported();
        List<String> other$currenciesSupported = other.getCurrenciesSupported();
        return !(this$currenciesSupported == null ? other$currenciesSupported != null : !((Object)this$currenciesSupported).equals(other$currenciesSupported));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $businessLogo = this.getBusinessLogo();
        result = result * 59 + ($businessLogo == null ? 43 : $businessLogo.hashCode());
        String $businessName = this.getBusinessName();
        result = result * 59 + ($businessName == null ? 43 : $businessName.hashCode());
        String $businessPrimaryColor = this.getBusinessPrimaryColor();
        result = result * 59 + ($businessPrimaryColor == null ? 43 : $businessPrimaryColor.hashCode());
        String $businessURL = this.getBusinessURL();
        result = result * 59 + ($businessURL == null ? 43 : $businessURL.hashCode());
        Boolean $chargesEnabled = this.getChargesEnabled();
        result = result * 59 + ($chargesEnabled == null ? 43 : ((Object)$chargesEnabled).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        Boolean $debitNegativeBalances = this.getDebitNegativeBalances();
        result = result * 59 + ($debitNegativeBalances == null ? 43 : ((Object)$debitNegativeBalances).hashCode());
        AccountDeclineChargeOn $declineChargeOn = this.getDeclineChargeOn();
        result = result * 59 + ($declineChargeOn == null ? 43 : ((Object)$declineChargeOn).hashCode());
        String $defaultCurrency = this.getDefaultCurrency();
        result = result * 59 + ($defaultCurrency == null ? 43 : $defaultCurrency.hashCode());
        Boolean $detailsSubmitted = this.getDetailsSubmitted();
        result = result * 59 + ($detailsSubmitted == null ? 43 : ((Object)$detailsSubmitted).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        LoginLinkCollection $loginLinks = this.getLoginLinks();
        result = result * 59 + ($loginLinks == null ? 43 : $loginLinks.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        ExternalAccountCollection $externalAccounts = this.getExternalAccounts();
        result = result * 59 + ($externalAccounts == null ? 43 : $externalAccounts.hashCode());
        Keys $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        LegalEntity $legalEntity = this.getLegalEntity();
        result = result * 59 + ($legalEntity == null ? 43 : ((Object)$legalEntity).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Boolean $payoutsEnabled = this.getPayoutsEnabled();
        result = result * 59 + ($payoutsEnabled == null ? 43 : ((Object)$payoutsEnabled).hashCode());
        AccountPayoutSchedule $payoutSchedule = this.getPayoutSchedule();
        result = result * 59 + ($payoutSchedule == null ? 43 : ((Object)$payoutSchedule).hashCode());
        String $productDescription = this.getProductDescription();
        result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $supportEmail = this.getSupportEmail();
        result = result * 59 + ($supportEmail == null ? 43 : $supportEmail.hashCode());
        String $supportPhone = this.getSupportPhone();
        result = result * 59 + ($supportPhone == null ? 43 : $supportPhone.hashCode());
        String $supportURL = this.getSupportURL();
        result = result * 59 + ($supportURL == null ? 43 : $supportURL.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        AccountTosAcceptance $tosAcceptance = this.getTosAcceptance();
        result = result * 59 + ($tosAcceptance == null ? 43 : ((Object)$tosAcceptance).hashCode());
        AccountTransferSchedule $transferSchedule = this.getTransferSchedule();
        result = result * 59 + ($transferSchedule == null ? 43 : ((Object)$transferSchedule).hashCode());
        Boolean $transfersEnabled = this.getTransfersEnabled();
        result = result * 59 + ($transfersEnabled == null ? 43 : ((Object)$transfersEnabled).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Verification $verification = this.getVerification();
        result = result * 59 + ($verification == null ? 43 : ((Object)$verification).hashCode());
        Boolean $managed = this.getManaged();
        result = result * 59 + ($managed == null ? 43 : ((Object)$managed).hashCode());
        List<String> $currenciesSupported = this.getCurrenciesSupported();
        result = result * 59 + ($currenciesSupported == null ? 43 : ((Object)$currenciesSupported).hashCode());
        return result;
    }

    public static class Keys
    extends StripeObject {
        String publishable;
        String secret;

        public String getPublishable() {
            return this.publishable;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setPublishable(String publishable) {
            this.publishable = publishable;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Keys)) {
                return false;
            }
            Keys other = (Keys)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$publishable = this.getPublishable();
            String other$publishable = other.getPublishable();
            if (this$publishable == null ? other$publishable != null : !this$publishable.equals(other$publishable)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Keys;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $publishable = this.getPublishable();
            result = result * 59 + ($publishable == null ? 43 : $publishable.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            return result;
        }
    }

    public static class Verification
    extends StripeObject {
        Boolean contacted;
        String disabledReason;
        Long dueBy;
        List<String> fieldsNeeded;

        public Boolean getContacted() {
            return this.contacted;
        }

        public String getDisabledReason() {
            return this.disabledReason;
        }

        public Long getDueBy() {
            return this.dueBy;
        }

        public List<String> getFieldsNeeded() {
            return this.fieldsNeeded;
        }

        public void setContacted(Boolean contacted) {
            this.contacted = contacted;
        }

        public void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        public void setDueBy(Long dueBy) {
            this.dueBy = dueBy;
        }

        public void setFieldsNeeded(List<String> fieldsNeeded) {
            this.fieldsNeeded = fieldsNeeded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verification)) {
                return false;
            }
            Verification other = (Verification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$contacted = this.getContacted();
            Boolean other$contacted = other.getContacted();
            if (this$contacted == null ? other$contacted != null : !((Object)this$contacted).equals(other$contacted)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            Long this$dueBy = this.getDueBy();
            Long other$dueBy = other.getDueBy();
            if (this$dueBy == null ? other$dueBy != null : !((Object)this$dueBy).equals(other$dueBy)) {
                return false;
            }
            List<String> this$fieldsNeeded = this.getFieldsNeeded();
            List<String> other$fieldsNeeded = other.getFieldsNeeded();
            return !(this$fieldsNeeded == null ? other$fieldsNeeded != null : !((Object)this$fieldsNeeded).equals(other$fieldsNeeded));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Verification;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $contacted = this.getContacted();
            result = result * 59 + ($contacted == null ? 43 : ((Object)$contacted).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            Long $dueBy = this.getDueBy();
            result = result * 59 + ($dueBy == null ? 43 : ((Object)$dueBy).hashCode());
            List<String> $fieldsNeeded = this.getFieldsNeeded();
            result = result * 59 + ($fieldsNeeded == null ? 43 : ((Object)$fieldsNeeded).hashCode());
            return result;
        }
    }
}

