/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.DeletedCard;
import com.stripe.model.ExternalAccount;
import com.stripe.model.Recipient;
import com.stripe.model.ThreeDSecure;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class Card
extends ExternalAccount {
    String addressCity;
    String addressCountry;
    String addressLine1;
    String addressLine1Check;
    String addressLine2;
    String addressState;
    String addressZip;
    String addressZipCheck;
    List<String> availablePayoutMethods;
    String brand;
    String country;
    String currency;
    String cvcCheck;
    Boolean defaultForCurrency;
    String dynamicLast4;
    Integer expMonth;
    Integer expYear;
    String fingerprint;
    String funding;
    String last4;
    String name;
    String recipient;
    String status;
    ThreeDSecure threeDSecure;
    String tokenizationMethod;
    String description;
    String iin;
    String issuer;
    @Deprecated
    String type;

    @Override
    public Card update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Card update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Override
    public Card update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, Card.class, options);
    }

    @Override
    public DeletedCard delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    @Deprecated
    public DeletedCard delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Override
    public DeletedCard delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), null, DeletedCard.class, options);
    }

    @Override
    protected String getInstanceURL() {
        String result = super.getInstanceURL();
        if (result != null) {
            return result;
        }
        if (this.getRecipient() != null) {
            return String.format("%s/%s/cards/%s", Card.classURL(Recipient.class), this.getRecipient(), this.getId());
        }
        return null;
    }

    public String getAddressCity() {
        return this.addressCity;
    }

    public String getAddressCountry() {
        return this.addressCountry;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public String getAddressLine1Check() {
        return this.addressLine1Check;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public String getAddressState() {
        return this.addressState;
    }

    public String getAddressZip() {
        return this.addressZip;
    }

    public String getAddressZipCheck() {
        return this.addressZipCheck;
    }

    public List<String> getAvailablePayoutMethods() {
        return this.availablePayoutMethods;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCvcCheck() {
        return this.cvcCheck;
    }

    public Boolean getDefaultForCurrency() {
        return this.defaultForCurrency;
    }

    public String getDynamicLast4() {
        return this.dynamicLast4;
    }

    public Integer getExpMonth() {
        return this.expMonth;
    }

    public Integer getExpYear() {
        return this.expYear;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getFunding() {
        return this.funding;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getName() {
        return this.name;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getStatus() {
        return this.status;
    }

    public ThreeDSecure getThreeDSecure() {
        return this.threeDSecure;
    }

    public String getTokenizationMethod() {
        return this.tokenizationMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIin() {
        return this.iin;
    }

    public String getIssuer() {
        return this.issuer;
    }

    @Deprecated
    public String getType() {
        return this.type;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public void setAddressLine1Check(String addressLine1Check) {
        this.addressLine1Check = addressLine1Check;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public void setAddressState(String addressState) {
        this.addressState = addressState;
    }

    public void setAddressZip(String addressZip) {
        this.addressZip = addressZip;
    }

    public void setAddressZipCheck(String addressZipCheck) {
        this.addressZipCheck = addressZipCheck;
    }

    public void setAvailablePayoutMethods(List<String> availablePayoutMethods) {
        this.availablePayoutMethods = availablePayoutMethods;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setCvcCheck(String cvcCheck) {
        this.cvcCheck = cvcCheck;
    }

    public void setDefaultForCurrency(Boolean defaultForCurrency) {
        this.defaultForCurrency = defaultForCurrency;
    }

    public void setDynamicLast4(String dynamicLast4) {
        this.dynamicLast4 = dynamicLast4;
    }

    public void setExpMonth(Integer expMonth) {
        this.expMonth = expMonth;
    }

    public void setExpYear(Integer expYear) {
        this.expYear = expYear;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public void setFunding(String funding) {
        this.funding = funding;
    }

    public void setLast4(String last4) {
        this.last4 = last4;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setThreeDSecure(ThreeDSecure threeDSecure) {
        this.threeDSecure = threeDSecure;
    }

    public void setTokenizationMethod(String tokenizationMethod) {
        this.tokenizationMethod = tokenizationMethod;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIin(String iin) {
        this.iin = iin;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Deprecated
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Card)) {
            return false;
        }
        Card other = (Card)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$addressCity = this.getAddressCity();
        String other$addressCity = other.getAddressCity();
        if (this$addressCity == null ? other$addressCity != null : !this$addressCity.equals(other$addressCity)) {
            return false;
        }
        String this$addressCountry = this.getAddressCountry();
        String other$addressCountry = other.getAddressCountry();
        if (this$addressCountry == null ? other$addressCountry != null : !this$addressCountry.equals(other$addressCountry)) {
            return false;
        }
        String this$addressLine1 = this.getAddressLine1();
        String other$addressLine1 = other.getAddressLine1();
        if (this$addressLine1 == null ? other$addressLine1 != null : !this$addressLine1.equals(other$addressLine1)) {
            return false;
        }
        String this$addressLine1Check = this.getAddressLine1Check();
        String other$addressLine1Check = other.getAddressLine1Check();
        if (this$addressLine1Check == null ? other$addressLine1Check != null : !this$addressLine1Check.equals(other$addressLine1Check)) {
            return false;
        }
        String this$addressLine2 = this.getAddressLine2();
        String other$addressLine2 = other.getAddressLine2();
        if (this$addressLine2 == null ? other$addressLine2 != null : !this$addressLine2.equals(other$addressLine2)) {
            return false;
        }
        String this$addressState = this.getAddressState();
        String other$addressState = other.getAddressState();
        if (this$addressState == null ? other$addressState != null : !this$addressState.equals(other$addressState)) {
            return false;
        }
        String this$addressZip = this.getAddressZip();
        String other$addressZip = other.getAddressZip();
        if (this$addressZip == null ? other$addressZip != null : !this$addressZip.equals(other$addressZip)) {
            return false;
        }
        String this$addressZipCheck = this.getAddressZipCheck();
        String other$addressZipCheck = other.getAddressZipCheck();
        if (this$addressZipCheck == null ? other$addressZipCheck != null : !this$addressZipCheck.equals(other$addressZipCheck)) {
            return false;
        }
        List<String> this$availablePayoutMethods = this.getAvailablePayoutMethods();
        List<String> other$availablePayoutMethods = other.getAvailablePayoutMethods();
        if (this$availablePayoutMethods == null ? other$availablePayoutMethods != null : !((Object)this$availablePayoutMethods).equals(other$availablePayoutMethods)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$cvcCheck = this.getCvcCheck();
        String other$cvcCheck = other.getCvcCheck();
        if (this$cvcCheck == null ? other$cvcCheck != null : !this$cvcCheck.equals(other$cvcCheck)) {
            return false;
        }
        Boolean this$defaultForCurrency = this.getDefaultForCurrency();
        Boolean other$defaultForCurrency = other.getDefaultForCurrency();
        if (this$defaultForCurrency == null ? other$defaultForCurrency != null : !((Object)this$defaultForCurrency).equals(other$defaultForCurrency)) {
            return false;
        }
        String this$dynamicLast4 = this.getDynamicLast4();
        String other$dynamicLast4 = other.getDynamicLast4();
        if (this$dynamicLast4 == null ? other$dynamicLast4 != null : !this$dynamicLast4.equals(other$dynamicLast4)) {
            return false;
        }
        Integer this$expMonth = this.getExpMonth();
        Integer other$expMonth = other.getExpMonth();
        if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
            return false;
        }
        Integer this$expYear = this.getExpYear();
        Integer other$expYear = other.getExpYear();
        if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
            return false;
        }
        String this$funding = this.getFunding();
        String other$funding = other.getFunding();
        if (this$funding == null ? other$funding != null : !this$funding.equals(other$funding)) {
            return false;
        }
        String this$last4 = this.getLast4();
        String other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ThreeDSecure this$threeDSecure = this.getThreeDSecure();
        ThreeDSecure other$threeDSecure = other.getThreeDSecure();
        if (this$threeDSecure == null ? other$threeDSecure != null : !((Object)this$threeDSecure).equals(other$threeDSecure)) {
            return false;
        }
        String this$tokenizationMethod = this.getTokenizationMethod();
        String other$tokenizationMethod = other.getTokenizationMethod();
        if (this$tokenizationMethod == null ? other$tokenizationMethod != null : !this$tokenizationMethod.equals(other$tokenizationMethod)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$iin = this.getIin();
        String other$iin = other.getIin();
        if (this$iin == null ? other$iin != null : !this$iin.equals(other$iin)) {
            return false;
        }
        String this$issuer = this.getIssuer();
        String other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Card;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $addressCity = this.getAddressCity();
        result = result * 59 + ($addressCity == null ? 43 : $addressCity.hashCode());
        String $addressCountry = this.getAddressCountry();
        result = result * 59 + ($addressCountry == null ? 43 : $addressCountry.hashCode());
        String $addressLine1 = this.getAddressLine1();
        result = result * 59 + ($addressLine1 == null ? 43 : $addressLine1.hashCode());
        String $addressLine1Check = this.getAddressLine1Check();
        result = result * 59 + ($addressLine1Check == null ? 43 : $addressLine1Check.hashCode());
        String $addressLine2 = this.getAddressLine2();
        result = result * 59 + ($addressLine2 == null ? 43 : $addressLine2.hashCode());
        String $addressState = this.getAddressState();
        result = result * 59 + ($addressState == null ? 43 : $addressState.hashCode());
        String $addressZip = this.getAddressZip();
        result = result * 59 + ($addressZip == null ? 43 : $addressZip.hashCode());
        String $addressZipCheck = this.getAddressZipCheck();
        result = result * 59 + ($addressZipCheck == null ? 43 : $addressZipCheck.hashCode());
        List<String> $availablePayoutMethods = this.getAvailablePayoutMethods();
        result = result * 59 + ($availablePayoutMethods == null ? 43 : ((Object)$availablePayoutMethods).hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $cvcCheck = this.getCvcCheck();
        result = result * 59 + ($cvcCheck == null ? 43 : $cvcCheck.hashCode());
        Boolean $defaultForCurrency = this.getDefaultForCurrency();
        result = result * 59 + ($defaultForCurrency == null ? 43 : ((Object)$defaultForCurrency).hashCode());
        String $dynamicLast4 = this.getDynamicLast4();
        result = result * 59 + ($dynamicLast4 == null ? 43 : $dynamicLast4.hashCode());
        Integer $expMonth = this.getExpMonth();
        result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
        Integer $expYear = this.getExpYear();
        result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        String $funding = this.getFunding();
        result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
        String $last4 = this.getLast4();
        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ThreeDSecure $threeDSecure = this.getThreeDSecure();
        result = result * 59 + ($threeDSecure == null ? 43 : ((Object)$threeDSecure).hashCode());
        String $tokenizationMethod = this.getTokenizationMethod();
        result = result * 59 + ($tokenizationMethod == null ? 43 : $tokenizationMethod.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $iin = this.getIin();
        result = result * 59 + ($iin == null ? 43 : $iin.hashCode());
        String $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

