/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.CouponCollection;
import com.stripe.model.DeletedCoupon;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Coupon
extends APIResource
implements MetadataStore<Coupon>,
HasId {
    String id;
    String object;
    Long amountOff;
    Long created;
    String currency;
    String duration;
    Integer durationInMonths;
    Boolean livemode;
    Long maxRedemptions;
    Map<String, String> metadata;
    Integer percentOff;
    Long redeemBy;
    Integer timesRedeemed;
    Boolean valid;

    public static Coupon create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.create(params, (RequestOptions)null);
    }

    @Deprecated
    public static Coupon create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Coupon create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.request(APIResource.RequestMethod.POST, Coupon.classURL(Coupon.class), params, Coupon.class, options);
    }

    public static Coupon retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static Coupon retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Coupon retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.request(APIResource.RequestMethod.GET, Coupon.instanceURL(Coupon.class, id), null, Coupon.class, options);
    }

    public Coupon update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Coupon update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Coupon update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.request(APIResource.RequestMethod.POST, Coupon.instanceURL(Coupon.class, this.id), params, Coupon.class, options);
    }

    public static CouponCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.list(params, null);
    }

    public static CouponCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.requestCollection(Coupon.classURL(Coupon.class), params, CouponCollection.class, options);
    }

    @Deprecated
    public static CouponCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.list(params, null);
    }

    @Deprecated
    public static CouponCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static CouponCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.list(params, options);
    }

    public DeletedCoupon delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    @Deprecated
    public DeletedCoupon delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public DeletedCoupon delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.request(APIResource.RequestMethod.DELETE, Coupon.instanceURL(Coupon.class, this.id), null, DeletedCoupon.class, options);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Long getAmountOff() {
        return this.amountOff;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDuration() {
        return this.duration;
    }

    public Integer getDurationInMonths() {
        return this.durationInMonths;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public Long getMaxRedemptions() {
        return this.maxRedemptions;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Integer getPercentOff() {
        return this.percentOff;
    }

    public Long getRedeemBy() {
        return this.redeemBy;
    }

    public Integer getTimesRedeemed() {
        return this.timesRedeemed;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setAmountOff(Long amountOff) {
        this.amountOff = amountOff;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setDurationInMonths(Integer durationInMonths) {
        this.durationInMonths = durationInMonths;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public void setMaxRedemptions(Long maxRedemptions) {
        this.maxRedemptions = maxRedemptions;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setPercentOff(Integer percentOff) {
        this.percentOff = percentOff;
    }

    public void setRedeemBy(Long redeemBy) {
        this.redeemBy = redeemBy;
    }

    public void setTimesRedeemed(Integer timesRedeemed) {
        this.timesRedeemed = timesRedeemed;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Coupon)) {
            return false;
        }
        Coupon other = (Coupon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amountOff = this.getAmountOff();
        Long other$amountOff = other.getAmountOff();
        if (this$amountOff == null ? other$amountOff != null : !((Object)this$amountOff).equals(other$amountOff)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        Integer this$durationInMonths = this.getDurationInMonths();
        Integer other$durationInMonths = other.getDurationInMonths();
        if (this$durationInMonths == null ? other$durationInMonths != null : !((Object)this$durationInMonths).equals(other$durationInMonths)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$maxRedemptions = this.getMaxRedemptions();
        Long other$maxRedemptions = other.getMaxRedemptions();
        if (this$maxRedemptions == null ? other$maxRedemptions != null : !((Object)this$maxRedemptions).equals(other$maxRedemptions)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Integer this$percentOff = this.getPercentOff();
        Integer other$percentOff = other.getPercentOff();
        if (this$percentOff == null ? other$percentOff != null : !((Object)this$percentOff).equals(other$percentOff)) {
            return false;
        }
        Long this$redeemBy = this.getRedeemBy();
        Long other$redeemBy = other.getRedeemBy();
        if (this$redeemBy == null ? other$redeemBy != null : !((Object)this$redeemBy).equals(other$redeemBy)) {
            return false;
        }
        Integer this$timesRedeemed = this.getTimesRedeemed();
        Integer other$timesRedeemed = other.getTimesRedeemed();
        if (this$timesRedeemed == null ? other$timesRedeemed != null : !((Object)this$timesRedeemed).equals(other$timesRedeemed)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        return !(this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Coupon;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amountOff = this.getAmountOff();
        result = result * 59 + ($amountOff == null ? 43 : ((Object)$amountOff).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        Integer $durationInMonths = this.getDurationInMonths();
        result = result * 59 + ($durationInMonths == null ? 43 : ((Object)$durationInMonths).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $maxRedemptions = this.getMaxRedemptions();
        result = result * 59 + ($maxRedemptions == null ? 43 : ((Object)$maxRedemptions).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Integer $percentOff = this.getPercentOff();
        result = result * 59 + ($percentOff == null ? 43 : ((Object)$percentOff).hashCode());
        Long $redeemBy = this.getRedeemBy();
        result = result * 59 + ($redeemBy == null ? 43 : ((Object)$redeemBy).hashCode());
        Integer $timesRedeemed = this.getTimesRedeemed();
        result = result * 59 + ($timesRedeemed == null ? 43 : ((Object)$timesRedeemed).hashCode());
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        return result;
    }
}

