/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BankAccount;
import com.stripe.model.Card;
import com.stripe.model.CustomerCardCollection;
import com.stripe.model.CustomerCollection;
import com.stripe.model.CustomerSubscriptionCollection;
import com.stripe.model.DeletedCustomer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.NextRecurringCharge;
import com.stripe.model.ShippingDetails;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.HashMap;
import java.util.Map;

public class Customer
extends APIResource
implements MetadataStore<Customer>,
HasId {
    String id;
    String object;
    Long accountBalance;
    String businessVatId;
    Long created;
    String currency;
    ExpandableField<ExternalAccount> defaultSource;
    Boolean deleted;
    Boolean delinquent;
    String description;
    Discount discount;
    String email;
    Boolean livemode;
    Map<String, String> metadata;
    ShippingDetails shipping;
    ExternalAccountCollection sources;
    CustomerSubscriptionCollection subscriptions;
    @Deprecated
    CustomerCardCollection cards;
    @Deprecated
    String defaultCard;
    @Deprecated
    NextRecurringCharge nextRecurringCharge;
    @Deprecated
    Subscription subscription;
    @Deprecated
    Long trialEnd;

    public String getDefaultSource() {
        return this.defaultSource != null ? this.defaultSource.getId() : null;
    }

    public void setDefaultSource(String defaultSourceID) {
        this.defaultSource = Customer.setExpandableFieldID(defaultSourceID, this.defaultSource);
    }

    public ExternalAccount getDefaultSourceObject() {
        return this.defaultSource != null ? this.defaultSource.getExpanded() : null;
    }

    public void setDefaultSourceObject(ExternalAccount c) {
        this.defaultSource = new ExpandableField<ExternalAccount>(c.getId(), c);
    }

    public static Customer create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.create(params, (RequestOptions)null);
    }

    @Deprecated
    public static Customer create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Customer create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.classURL(Customer.class), params, Customer.class, options);
    }

    public static Customer retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static Customer retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Customer retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.GET, Customer.instanceURL(Customer.class, id), null, Customer.class, options);
    }

    public static Customer retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.GET, Customer.instanceURL(Customer.class, id), params, Customer.class, options);
    }

    public Customer update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Customer update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Customer update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.instanceURL(Customer.class, this.id), params, Customer.class, options);
    }

    public DeletedCustomer delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    @Deprecated
    public DeletedCustomer delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public DeletedCustomer delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.DELETE, Customer.instanceURL(Customer.class, this.id), null, DeletedCustomer.class, options);
    }

    @Deprecated
    public Card createCard(String token, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(token, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Card createCard(String token) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(token, (RequestOptions)null);
    }

    public Card createCard(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(params, (RequestOptions)null);
    }

    @Deprecated
    public Card createCard(String token, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("card", token);
        return this.createCard(postParams, options);
    }

    @Deprecated
    public Card createCard(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Card createCard(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/cards", Customer.instanceURL(Customer.class, this.id)), params, Card.class, options);
    }

    @Deprecated
    public BankAccount createBankAccount(String token) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccount(token, null);
    }

    @Deprecated
    public BankAccount createBankAccount(String token, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("bank_account", token);
        return this.createBankAccount(postParams, options);
    }

    @Deprecated
    public BankAccount createBankAccount(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccount(params, null);
    }

    @Deprecated
    public BankAccount createBankAccount(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/bank_accounts", Customer.instanceURL(Customer.class, this.id)), params, BankAccount.class, options);
    }

    public Subscription createSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createSubscription(params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription createSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createSubscription(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription createSubscription(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/subscriptions", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, options);
    }

    public Subscription updateSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateSubscription(params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription updateSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateSubscription(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription updateSubscription(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, options);
    }

    public Subscription cancelSubscription() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(null, (RequestOptions)null);
    }

    public Subscription cancelSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription cancelSubscription(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription cancelSubscription(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(null, options);
    }

    @Deprecated
    public Subscription cancelSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription cancelSubscription(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.DELETE, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, options);
    }

    public void deleteDiscount() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount((RequestOptions)null);
    }

    @Deprecated
    public void deleteDiscount(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public void deleteDiscount(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Customer.request(APIResource.RequestMethod.DELETE, String.format("%s/discount", Customer.instanceURL(Customer.class, this.id)), null, Discount.class, options);
    }

    public static CustomerCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, null);
    }

    public static CustomerCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.requestCollection(Customer.classURL(Customer.class), params, CustomerCollection.class, options);
    }

    @Deprecated
    public static CustomerCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, null);
    }

    @Deprecated
    public static CustomerCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static CustomerCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, options);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Long getAccountBalance() {
        return this.accountBalance;
    }

    public String getBusinessVatId() {
        return this.businessVatId;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Boolean getDelinquent() {
        return this.delinquent;
    }

    public String getDescription() {
        return this.description;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShippingDetails getShipping() {
        return this.shipping;
    }

    public ExternalAccountCollection getSources() {
        return this.sources;
    }

    public CustomerSubscriptionCollection getSubscriptions() {
        return this.subscriptions;
    }

    @Deprecated
    public CustomerCardCollection getCards() {
        return this.cards;
    }

    @Deprecated
    public String getDefaultCard() {
        return this.defaultCard;
    }

    @Deprecated
    public NextRecurringCharge getNextRecurringCharge() {
        return this.nextRecurringCharge;
    }

    @Deprecated
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Deprecated
    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setAccountBalance(Long accountBalance) {
        this.accountBalance = accountBalance;
    }

    public void setBusinessVatId(String businessVatId) {
        this.businessVatId = businessVatId;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setDelinquent(Boolean delinquent) {
        this.delinquent = delinquent;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    public void setSources(ExternalAccountCollection sources) {
        this.sources = sources;
    }

    public void setSubscriptions(CustomerSubscriptionCollection subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Deprecated
    public void setCards(CustomerCardCollection cards) {
        this.cards = cards;
    }

    @Deprecated
    public void setDefaultCard(String defaultCard) {
        this.defaultCard = defaultCard;
    }

    @Deprecated
    public void setNextRecurringCharge(NextRecurringCharge nextRecurringCharge) {
        this.nextRecurringCharge = nextRecurringCharge;
    }

    @Deprecated
    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    @Deprecated
    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$accountBalance = this.getAccountBalance();
        Long other$accountBalance = other.getAccountBalance();
        if (this$accountBalance == null ? other$accountBalance != null : !((Object)this$accountBalance).equals(other$accountBalance)) {
            return false;
        }
        String this$businessVatId = this.getBusinessVatId();
        String other$businessVatId = other.getBusinessVatId();
        if (this$businessVatId == null ? other$businessVatId != null : !this$businessVatId.equals(other$businessVatId)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$defaultSource = this.getDefaultSource();
        String other$defaultSource = other.getDefaultSource();
        if (this$defaultSource == null ? other$defaultSource != null : !this$defaultSource.equals(other$defaultSource)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$delinquent = this.getDelinquent();
        Boolean other$delinquent = other.getDelinquent();
        if (this$delinquent == null ? other$delinquent != null : !((Object)this$delinquent).equals(other$delinquent)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        ExternalAccountCollection this$sources = this.getSources();
        ExternalAccountCollection other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !this$sources.equals(other$sources)) {
            return false;
        }
        CustomerSubscriptionCollection this$subscriptions = this.getSubscriptions();
        CustomerSubscriptionCollection other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !this$subscriptions.equals(other$subscriptions)) {
            return false;
        }
        CustomerCardCollection this$cards = this.getCards();
        CustomerCardCollection other$cards = other.getCards();
        if (this$cards == null ? other$cards != null : !this$cards.equals(other$cards)) {
            return false;
        }
        String this$defaultCard = this.getDefaultCard();
        String other$defaultCard = other.getDefaultCard();
        if (this$defaultCard == null ? other$defaultCard != null : !this$defaultCard.equals(other$defaultCard)) {
            return false;
        }
        NextRecurringCharge this$nextRecurringCharge = this.getNextRecurringCharge();
        NextRecurringCharge other$nextRecurringCharge = other.getNextRecurringCharge();
        if (this$nextRecurringCharge == null ? other$nextRecurringCharge != null : !((Object)this$nextRecurringCharge).equals(other$nextRecurringCharge)) {
            return false;
        }
        Subscription this$subscription = this.getSubscription();
        Subscription other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !((Object)this$subscription).equals(other$subscription)) {
            return false;
        }
        Long this$trialEnd = this.getTrialEnd();
        Long other$trialEnd = other.getTrialEnd();
        return !(this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Customer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $accountBalance = this.getAccountBalance();
        result = result * 59 + ($accountBalance == null ? 43 : ((Object)$accountBalance).hashCode());
        String $businessVatId = this.getBusinessVatId();
        result = result * 59 + ($businessVatId == null ? 43 : $businessVatId.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $defaultSource = this.getDefaultSource();
        result = result * 59 + ($defaultSource == null ? 43 : $defaultSource.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $delinquent = this.getDelinquent();
        result = result * 59 + ($delinquent == null ? 43 : ((Object)$delinquent).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        ExternalAccountCollection $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : $sources.hashCode());
        CustomerSubscriptionCollection $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : $subscriptions.hashCode());
        CustomerCardCollection $cards = this.getCards();
        result = result * 59 + ($cards == null ? 43 : $cards.hashCode());
        String $defaultCard = this.getDefaultCard();
        result = result * 59 + ($defaultCard == null ? 43 : $defaultCard.hashCode());
        NextRecurringCharge $nextRecurringCharge = this.getNextRecurringCharge();
        result = result * 59 + ($nextRecurringCharge == null ? 43 : ((Object)$nextRecurringCharge).hashCode());
        Subscription $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : ((Object)$subscription).hashCode());
        Long $trialEnd = this.getTrialEnd();
        result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
        return result;
    }
}

