/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.DeletedExternalAccount;
import com.stripe.model.ExternalAccount;
import com.stripe.model.HasSourceTypeData;
import com.stripe.model.SourceCodeVerificationFlow;
import com.stripe.model.SourceOwner;
import com.stripe.model.SourceReceiverFlow;
import com.stripe.model.SourceRedirectFlow;
import com.stripe.model.SourceTransactionCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Source
extends ExternalAccount
implements HasSourceTypeData {
    Long amount;
    String clientSecret;
    SourceCodeVerificationFlow codeVerification;
    Long created;
    String currency;
    String flow;
    Boolean livemode;
    SourceOwner owner;
    SourceReceiverFlow receiver;
    SourceRedirectFlow redirect;
    String statementDescriptor;
    String status;
    String type;
    String usage;
    Map<String, String> typeData;

    public String getSourceInstanceURL() throws InvalidRequestException {
        return Source.instanceURL(Source.class, this.getId());
    }

    public static Source create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.create(params, null);
    }

    public static Source create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.request(APIResource.RequestMethod.POST, Source.classURL(Source.class), params, Source.class, options);
    }

    public static Source retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.retrieve(id, null);
    }

    public static Source retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.request(APIResource.RequestMethod.GET, Source.instanceURL(Source.class, id), null, Source.class, options);
    }

    @Override
    public Source verify(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.verify((Map)params, (RequestOptions)null);
    }

    @Override
    public Source verify(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.request(APIResource.RequestMethod.POST, String.format("%s/verify", this.getSourceInstanceURL()), params, Source.class, options);
    }

    @Override
    public Source update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public Source update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.request(APIResource.RequestMethod.POST, this.getSourceInstanceURL(), params, Source.class, options);
    }

    @Override
    public DeletedExternalAccount delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        throw new InvalidRequestException("Source objects cannot be deleted. If you want to detach the source from a customer object, use detach().", null, null, null, 0, null);
    }

    public Source detach() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.detach(null, null);
    }

    public Source detach(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.detach(params, null);
    }

    public Source detach(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (this.getCustomer() != null) {
            String url = String.format("%s/%s/sources/%s", Source.classURL(Customer.class), this.getCustomer(), this.getId());
            return Source.request(APIResource.RequestMethod.DELETE, url, params, Source.class, options);
        }
        throw new InvalidRequestException("This source object does not appear to be currently attached to a customer object.", null, null, null, 0, null);
    }

    public SourceTransactionCollection sourceTransactions(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.sourceTransactions(params, null);
    }

    public SourceTransactionCollection sourceTransactions(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = Source.instanceURL(Source.class, this.getId()) + "/source_transactions";
        return Source.requestCollection(url, params, SourceTransactionCollection.class, options);
    }

    public Long getAmount() {
        return this.amount;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public SourceCodeVerificationFlow getCodeVerification() {
        return this.codeVerification;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getFlow() {
        return this.flow;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public SourceOwner getOwner() {
        return this.owner;
    }

    public SourceReceiverFlow getReceiver() {
        return this.receiver;
    }

    public SourceRedirectFlow getRedirect() {
        return this.redirect;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getUsage() {
        return this.usage;
    }

    @Override
    public Map<String, String> getTypeData() {
        return this.typeData;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setCodeVerification(SourceCodeVerificationFlow codeVerification) {
        this.codeVerification = codeVerification;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public void setOwner(SourceOwner owner) {
        this.owner = owner;
    }

    public void setReceiver(SourceReceiverFlow receiver) {
        this.receiver = receiver;
    }

    public void setRedirect(SourceRedirectFlow redirect) {
        this.redirect = redirect;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Override
    public void setTypeData(Map<String, String> typeData) {
        this.typeData = typeData;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source other = (Source)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        SourceCodeVerificationFlow this$codeVerification = this.getCodeVerification();
        SourceCodeVerificationFlow other$codeVerification = other.getCodeVerification();
        if (this$codeVerification == null ? other$codeVerification != null : !((Object)this$codeVerification).equals(other$codeVerification)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        SourceOwner this$owner = this.getOwner();
        SourceOwner other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        SourceReceiverFlow this$receiver = this.getReceiver();
        SourceReceiverFlow other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !((Object)this$receiver).equals(other$receiver)) {
            return false;
        }
        SourceRedirectFlow this$redirect = this.getRedirect();
        SourceRedirectFlow other$redirect = other.getRedirect();
        if (this$redirect == null ? other$redirect != null : !((Object)this$redirect).equals(other$redirect)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        Map<String, String> this$typeData = this.getTypeData();
        Map<String, String> other$typeData = other.getTypeData();
        return !(this$typeData == null ? other$typeData != null : !((Object)this$typeData).equals(other$typeData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Source;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        SourceCodeVerificationFlow $codeVerification = this.getCodeVerification();
        result = result * 59 + ($codeVerification == null ? 43 : ((Object)$codeVerification).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        SourceOwner $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        SourceReceiverFlow $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : ((Object)$receiver).hashCode());
        SourceRedirectFlow $redirect = this.getRedirect();
        result = result * 59 + ($redirect == null ? 43 : ((Object)$redirect).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        Map<String, String> $typeData = this.getTypeData();
        result = result * 59 + ($typeData == null ? 43 : ((Object)$typeData).hashCode());
        return result;
    }
}

