package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;

import java.util.Map;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class ApplePayDomain extends APIResource implements HasId {
  String id;
  String object;
  Long created;
  String domainName;
  Boolean livemode;

  public static ApplePayDomain create(Map<String, Object> params)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return create(params, null);
  }

  public static ApplePayDomain create(Map<String, Object> params, RequestOptions options)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return request(RequestMethod.POST, getClassURL(), params, ApplePayDomain.class, options);
  }

  public static ApplePayDomain retrieve(String id) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return retrieve(id, null);
  }

  public static ApplePayDomain retrieve(String id, RequestOptions options)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return request(RequestMethod.GET, getInstanceURL(id), null, ApplePayDomain.class, options);
  }

  public DeletedApplePayDomain delete() throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return delete(null);
  }

  public DeletedApplePayDomain delete(RequestOptions options) throws AuthenticationException,
      InvalidRequestException, APIConnectionException, CardException,
      APIException {
    return request(RequestMethod.DELETE, getInstanceURL(id), null, DeletedApplePayDomain.class,
        options);
  }

  public static ApplePayDomainCollection list(Map<String, Object> params)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return list(params, null);
  }

  public static ApplePayDomainCollection list(Map<String, Object> params, RequestOptions options)
      throws AuthenticationException, InvalidRequestException,
      APIConnectionException, CardException, APIException {
    return requestCollection(getClassURL(), params, ApplePayDomainCollection.class, options);
  }

  private static String getClassURL() {
    return String.format("%s/v1/%s", Stripe.getApiBase(), "apple_pay/domains");
  }

  private static String getInstanceURL(String id) {
    if (id != null && !id.isEmpty()) {
      return String.format("%s/%s", getClassURL(), id);
    }
    return null;
  }
}
