/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PayoutCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Payout
extends APIResource
implements MetadataStore<Payout>,
HasId {
    String id;
    String object;
    Long amount;
    Long arrivalDate;
    Boolean automatic;
    ExpandableField<BalanceTransaction> balanceTransaction;
    Long created;
    String currency;
    ExpandableField<ExternalAccount> destination;
    ExpandableField<BalanceTransaction> failureBalanceTransaction;
    String failureCode;
    String failureMessage;
    Boolean livemode;
    Map<String, String> metadata;
    String method;
    String sourceType;
    String statementDescriptor;
    String status;
    String type;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String balanceTransactionID) {
        this.balanceTransaction = Payout.setExpandableFieldID(balanceTransactionID, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction c) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String destinationID) {
        this.destination = APIResource.setExpandableFieldID(destinationID, this.destination);
    }

    public ExternalAccount getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(ExternalAccount c) {
        this.destination = new ExpandableField<ExternalAccount>(c.getId(), c);
    }

    public String getFailureBalanceTransaction() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getId() : null;
    }

    public void setFailureBalanceTransaction(String failureBalanceTransactionID) {
        this.failureBalanceTransaction = Payout.setExpandableFieldID(failureBalanceTransactionID, this.failureBalanceTransaction);
    }

    public BalanceTransaction getFailureBalanceTransactionObject() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getExpanded() : null;
    }

    public void setFailureBalanceTransactionObject(BalanceTransaction c) {
        this.failureBalanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
    }

    public Payout cancel() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(null);
    }

    public Payout cancel(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.request(APIResource.RequestMethod.POST, Payout.instanceURL(Payout.class, this.id) + "/cancel", null, Payout.class, options);
    }

    public static Payout create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.create(params, null);
    }

    public static Payout create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.request(APIResource.RequestMethod.POST, Payout.classURL(Payout.class), params, Payout.class, options);
    }

    public static PayoutCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.list(params, null);
    }

    public static PayoutCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.requestCollection(Payout.classURL(Payout.class), params, PayoutCollection.class, options);
    }

    public static Payout retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.retrieve(id, null);
    }

    public static Payout retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.request(APIResource.RequestMethod.GET, Payout.instanceURL(Payout.class, id), null, Payout.class, options);
    }

    public static Payout retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.request(APIResource.RequestMethod.GET, Payout.instanceURL(Payout.class, id), params, Payout.class, options);
    }

    public Payout update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Payout update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Payout.request(APIResource.RequestMethod.POST, Payout.instanceURL(Payout.class, this.id), params, Payout.class, options);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Long getArrivalDate() {
        return this.arrivalDate;
    }

    public Boolean getAutomatic() {
        return this.automatic;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getMethod() {
        return this.method;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public void setArrivalDate(Long arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    public void setAutomatic(Boolean automatic) {
        this.automatic = automatic;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payout)) {
            return false;
        }
        Payout other = (Payout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$arrivalDate = this.getArrivalDate();
        Long other$arrivalDate = other.getArrivalDate();
        if (this$arrivalDate == null ? other$arrivalDate != null : !((Object)this$arrivalDate).equals(other$arrivalDate)) {
            return false;
        }
        Boolean this$automatic = this.getAutomatic();
        Boolean other$automatic = other.getAutomatic();
        if (this$automatic == null ? other$automatic != null : !((Object)this$automatic).equals(other$automatic)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$failureBalanceTransaction = this.getFailureBalanceTransaction();
        String other$failureBalanceTransaction = other.getFailureBalanceTransaction();
        if (this$failureBalanceTransaction == null ? other$failureBalanceTransaction != null : !this$failureBalanceTransaction.equals(other$failureBalanceTransaction)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Payout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $arrivalDate = this.getArrivalDate();
        result = result * 59 + ($arrivalDate == null ? 43 : ((Object)$arrivalDate).hashCode());
        Boolean $automatic = this.getAutomatic();
        result = result * 59 + ($automatic == null ? 43 : ((Object)$automatic).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $failureBalanceTransaction = this.getFailureBalanceTransaction();
        result = result * 59 + ($failureBalanceTransaction == null ? 43 : $failureBalanceTransaction.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

