/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.DeletedSKU;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Inventory;
import com.stripe.model.MetadataStore;
import com.stripe.model.PackageDimensions;
import com.stripe.model.Product;
import com.stripe.model.SKUCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class SKU
extends APIResource
implements HasId,
MetadataStore<SKU> {
    String id;
    String object;
    Boolean active;
    Map<String, String> attributes;
    Long created;
    String currency;
    String image;
    Inventory inventory;
    Boolean livemode;
    Map<String, String> metadata;
    PackageDimensions packageDimensions;
    Integer price;
    ExpandableField<Product> product;
    Long updated;

    public String getProduct() {
        return this.product != null ? this.product.getId() : null;
    }

    public void setProduct(String productID) {
        this.product = SKU.setExpandableFieldID(productID, this.product);
    }

    public Product getProductObject() {
        return this.product != null ? this.product.getExpanded() : null;
    }

    public void setProductObject(Product product) {
        this.product = new ExpandableField<Product>(product.getId(), product);
    }

    public static SKU create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.create(params, null);
    }

    public static SKU create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.POST, SKU.classURL(SKU.class), params, SKU.class, options);
    }

    public static SKU retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.retrieve(id, null);
    }

    public static SKU retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.GET, SKU.instanceURL(SKU.class, id), null, SKU.class, options);
    }

    public static SKU retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.GET, SKU.instanceURL(SKU.class, id), params, SKU.class, options);
    }

    public SKU update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SKU update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.POST, SKU.instanceURL(SKU.class, this.id), params, SKU.class, options);
    }

    public DeletedSKU delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    public DeletedSKU delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.request(APIResource.RequestMethod.DELETE, SKU.instanceURL(SKU.class, this.id), null, DeletedSKU.class, options);
    }

    public static SKUCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.list(params, null);
    }

    public static SKUCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.requestCollection(SKU.classURL(SKU.class), params, SKUCollection.class, options);
    }

    @Deprecated
    public static SKUCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.list(params, null);
    }

    @Deprecated
    public static SKUCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return SKU.list(params, options);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getImage() {
        return this.image;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    public Integer getPrice() {
        return this.price;
    }

    public Long getUpdated() {
        return this.updated;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SKU)) {
            return false;
        }
        SKU other = (SKU)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Inventory this$inventory = this.getInventory();
        Inventory other$inventory = other.getInventory();
        if (this$inventory == null ? other$inventory != null : !((Object)this$inventory).equals(other$inventory)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        PackageDimensions this$packageDimensions = this.getPackageDimensions();
        PackageDimensions other$packageDimensions = other.getPackageDimensions();
        if (this$packageDimensions == null ? other$packageDimensions != null : !((Object)this$packageDimensions).equals(other$packageDimensions)) {
            return false;
        }
        Integer this$price = this.getPrice();
        Integer other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SKU;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Inventory $inventory = this.getInventory();
        result = result * 59 + ($inventory == null ? 43 : ((Object)$inventory).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        PackageDimensions $packageDimensions = this.getPackageDimensions();
        result = result * 59 + ($packageDimensions == null ? 43 : ((Object)$packageDimensions).hashCode());
        Integer $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        return result;
    }
}

