/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.Charge;
import com.stripe.model.DisputeCollection;
import com.stripe.model.EvidenceDetails;
import com.stripe.model.EvidenceSubObject;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Dispute
extends APIResource
implements HasId {
    String id;
    String object;
    Long amount;
    List<BalanceTransaction> balanceTransactions;
    ExpandableField<Charge> charge;
    Long created;
    String currency;
    EvidenceSubObject evidenceSubObject;
    EvidenceDetails evidenceDetails;
    Boolean isChargeRefundable;
    Boolean livemode;
    Map<String, String> metadata;
    String reason;
    String status;
    String networkReasonCode;
    @Deprecated
    String balanceTransaction;
    @Deprecated
    String evidence;
    @Deprecated
    Long evidenceDueBy;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String chargeID) {
        this.charge = Dispute.setExpandableFieldID(chargeID, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge charge) {
        this.charge = new ExpandableField<Charge>(charge.getId(), charge);
    }

    public boolean getIsChargeRefundable() {
        return this.isChargeRefundable;
    }

    public static Dispute retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.retrieve(id, null, null);
    }

    public static Dispute retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.retrieve(id, null, options);
    }

    public static Dispute retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.request(APIResource.RequestMethod.GET, Dispute.instanceURL(Dispute.class, id), params, Dispute.class, options);
    }

    public static DisputeCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.list(params, null);
    }

    public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.requestCollection(Dispute.classURL(Dispute.class), params, DisputeCollection.class, options);
    }

    @Deprecated
    public static DisputeCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.list(params, null);
    }

    @Deprecated
    public static DisputeCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.list(params, options);
    }

    public Dispute update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update(params, null);
    }

    public Dispute update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.request(APIResource.RequestMethod.POST, Dispute.instanceURL(Dispute.class, this.getId()), params, Dispute.class, options);
    }

    public Dispute close() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.close(null);
    }

    public Dispute close(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Dispute.request(APIResource.RequestMethod.POST, String.format("%s/close", Dispute.instanceURL(Dispute.class, this.getId())), null, Dispute.class, options);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public List<BalanceTransaction> getBalanceTransactions() {
        return this.balanceTransactions;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public EvidenceSubObject getEvidenceSubObject() {
        return this.evidenceSubObject;
    }

    @Generated
    public EvidenceDetails getEvidenceDetails() {
        return this.evidenceDetails;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getNetworkReasonCode() {
        return this.networkReasonCode;
    }

    @Deprecated
    @Generated
    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    @Deprecated
    @Generated
    public String getEvidence() {
        return this.evidence;
    }

    @Deprecated
    @Generated
    public Long getEvidenceDueBy() {
        return this.evidenceDueBy;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setBalanceTransactions(List<BalanceTransaction> balanceTransactions) {
        this.balanceTransactions = balanceTransactions;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setEvidenceSubObject(EvidenceSubObject evidenceSubObject) {
        this.evidenceSubObject = evidenceSubObject;
    }

    @Generated
    public void setEvidenceDetails(EvidenceDetails evidenceDetails) {
        this.evidenceDetails = evidenceDetails;
    }

    @Generated
    public void setIsChargeRefundable(Boolean isChargeRefundable) {
        this.isChargeRefundable = isChargeRefundable;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setNetworkReasonCode(String networkReasonCode) {
        this.networkReasonCode = networkReasonCode;
    }

    @Deprecated
    @Generated
    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    @Deprecated
    @Generated
    public void setEvidence(String evidence) {
        this.evidence = evidence;
    }

    @Deprecated
    @Generated
    public void setEvidenceDueBy(Long evidenceDueBy) {
        this.evidenceDueBy = evidenceDueBy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        List<BalanceTransaction> this$balanceTransactions = this.getBalanceTransactions();
        List<BalanceTransaction> other$balanceTransactions = other.getBalanceTransactions();
        if (this$balanceTransactions == null ? other$balanceTransactions != null : !((Object)this$balanceTransactions).equals(other$balanceTransactions)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        EvidenceSubObject this$evidenceSubObject = this.getEvidenceSubObject();
        EvidenceSubObject other$evidenceSubObject = other.getEvidenceSubObject();
        if (this$evidenceSubObject == null ? other$evidenceSubObject != null : !((Object)this$evidenceSubObject).equals(other$evidenceSubObject)) {
            return false;
        }
        EvidenceDetails this$evidenceDetails = this.getEvidenceDetails();
        EvidenceDetails other$evidenceDetails = other.getEvidenceDetails();
        if (this$evidenceDetails == null ? other$evidenceDetails != null : !((Object)this$evidenceDetails).equals(other$evidenceDetails)) {
            return false;
        }
        if (this.getIsChargeRefundable() != other.getIsChargeRefundable()) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$networkReasonCode = this.getNetworkReasonCode();
        String other$networkReasonCode = other.getNetworkReasonCode();
        if (this$networkReasonCode == null ? other$networkReasonCode != null : !this$networkReasonCode.equals(other$networkReasonCode)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$evidence = this.getEvidence();
        String other$evidence = other.getEvidence();
        if (this$evidence == null ? other$evidence != null : !this$evidence.equals(other$evidence)) {
            return false;
        }
        Long this$evidenceDueBy = this.getEvidenceDueBy();
        Long other$evidenceDueBy = other.getEvidenceDueBy();
        return !(this$evidenceDueBy == null ? other$evidenceDueBy != null : !((Object)this$evidenceDueBy).equals(other$evidenceDueBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dispute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        List<BalanceTransaction> $balanceTransactions = this.getBalanceTransactions();
        result = result * 59 + ($balanceTransactions == null ? 43 : ((Object)$balanceTransactions).hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        EvidenceSubObject $evidenceSubObject = this.getEvidenceSubObject();
        result = result * 59 + ($evidenceSubObject == null ? 43 : ((Object)$evidenceSubObject).hashCode());
        EvidenceDetails $evidenceDetails = this.getEvidenceDetails();
        result = result * 59 + ($evidenceDetails == null ? 43 : ((Object)$evidenceDetails).hashCode());
        result = result * 59 + (this.getIsChargeRefundable() ? 79 : 97);
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $networkReasonCode = this.getNetworkReasonCode();
        result = result * 59 + ($networkReasonCode == null ? 43 : $networkReasonCode.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $evidence = this.getEvidence();
        result = result * 59 + ($evidence == null ? 43 : $evidence.hashCode());
        Long $evidenceDueBy = this.getEvidenceDueBy();
        result = result * 59 + ($evidenceDueBy == null ? 43 : ((Object)$evidenceDueBy).hashCode());
        return result;
    }
}

