/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.DeletedInvoiceItem;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItemCollection;
import com.stripe.model.InvoiceLineItemPeriod;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class InvoiceItem
extends APIResource
implements MetadataStore<InvoiceItem>,
HasId {
    String id;
    String object;
    Long amount;
    String currency;
    ExpandableField<Customer> customer;
    Long date;
    String description;
    Boolean discountable;
    ExpandableField<Invoice> invoice;
    Boolean livemode;
    Map<String, String> metadata;
    InvoiceLineItemPeriod period;
    Plan plan;
    Boolean proration;
    Integer quantity;
    ExpandableField<Subscription> subscription;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerID) {
        this.customer = InvoiceItem.setExpandableFieldID(customerID, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String invoiceID) {
        this.invoice = InvoiceItem.setExpandableFieldID(invoiceID, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice invoice) {
        this.invoice = new ExpandableField<Invoice>(invoice.getId(), invoice);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String subscriptionID) {
        this.subscription = InvoiceItem.setExpandableFieldID(subscriptionID, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription subscription) {
        this.subscription = new ExpandableField<Subscription>(subscription.getId(), subscription);
    }

    public static InvoiceItem create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.create(params, (RequestOptions)null);
    }

    @Deprecated
    public static InvoiceItem create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static InvoiceItem create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.POST, InvoiceItem.classURL(InvoiceItem.class), params, InvoiceItem.class, options);
    }

    public static InvoiceItem retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static InvoiceItem retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static InvoiceItem retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.GET, InvoiceItem.instanceURL(InvoiceItem.class, id), null, InvoiceItem.class, options);
    }

    public static InvoiceItem retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.GET, InvoiceItem.instanceURL(InvoiceItem.class, id), params, InvoiceItem.class, options);
    }

    public InvoiceItem update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public InvoiceItem update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public InvoiceItem update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.POST, InvoiceItem.instanceURL(InvoiceItem.class, this.id), params, InvoiceItem.class, options);
    }

    public DeletedInvoiceItem delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    @Deprecated
    public DeletedInvoiceItem delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public DeletedInvoiceItem delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.request(APIResource.RequestMethod.DELETE, InvoiceItem.instanceURL(InvoiceItem.class, this.id), null, DeletedInvoiceItem.class, options);
    }

    public static InvoiceItemCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, null);
    }

    public static InvoiceItemCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.requestCollection(InvoiceItem.classURL(InvoiceItem.class), params, InvoiceItemCollection.class, options);
    }

    @Deprecated
    public static InvoiceItemCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, null);
    }

    @Deprecated
    public static InvoiceItemCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static InvoiceItemCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InvoiceItem.list(params, options);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getDate() {
        return this.date;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getDiscountable() {
        return this.discountable;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public InvoiceLineItemPeriod getPeriod() {
        return this.period;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public Boolean getProration() {
        return this.proration;
    }

    @Generated
    public Integer getQuantity() {
        return this.quantity;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDate(Long date) {
        this.date = date;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setPeriod(InvoiceLineItemPeriod period) {
        this.period = period;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setProration(Boolean proration) {
        this.proration = proration;
    }

    @Generated
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceItem)) {
            return false;
        }
        InvoiceItem other = (InvoiceItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Boolean this$discountable = this.getDiscountable();
        Boolean other$discountable = other.getDiscountable();
        if (this$discountable == null ? other$discountable != null : !((Object)this$discountable).equals(other$discountable)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        InvoiceLineItemPeriod this$period = this.getPeriod();
        InvoiceLineItemPeriod other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        Boolean this$proration = this.getProration();
        Boolean other$proration = other.getProration();
        if (this$proration == null ? other$proration != null : !((Object)this$proration).equals(other$proration)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        return !(this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvoiceItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Boolean $discountable = this.getDiscountable();
        result = result * 59 + ($discountable == null ? 43 : ((Object)$discountable).hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        InvoiceLineItemPeriod $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        Boolean $proration = this.getProration();
        result = result * 59 + ($proration == null ? 43 : ((Object)$proration).hashCode());
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        return result;
    }
}

