/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.DeletedProduct;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.PackageDimensions;
import com.stripe.model.ProductCollection;
import com.stripe.model.SKUCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Product
extends APIResource
implements HasId,
MetadataStore<Product> {
    String id;
    String object;
    Boolean active;
    List<String> attributes;
    String caption;
    Long created;
    List<String> deactivateOn;
    String description;
    List<String> images;
    Boolean livemode;
    Map<String, String> metadata;
    String name;
    PackageDimensions packageDimensions;
    Boolean shippable;
    SKUCollection skus;
    String statementDescriptor;
    String type;
    Long updated;
    String url;

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public static Product create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.create(params, null);
    }

    public static Product create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.POST, Product.classURL(Product.class), params, Product.class, options);
    }

    public static Product retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.retrieve(id, null);
    }

    public static Product retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.GET, Product.instanceURL(Product.class, id), null, Product.class, options);
    }

    public Product update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Product update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.POST, Product.instanceURL(Product.class, this.id), params, Product.class, options);
    }

    public DeletedProduct delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    public DeletedProduct delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.request(APIResource.RequestMethod.DELETE, Product.instanceURL(Product.class, this.id), null, DeletedProduct.class, options);
    }

    public static ProductCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.list(params, null);
    }

    public static ProductCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.requestCollection(Product.classURL(Product.class), params, ProductCollection.class, options);
    }

    @Deprecated
    public static ProductCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.list(params, null);
    }

    @Deprecated
    public static ProductCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Product.list(params, options);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public List<String> getDeactivateOn() {
        return this.deactivateOn;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getImages() {
        return this.images;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    @Generated
    public Boolean getShippable() {
        return this.shippable;
    }

    @Generated
    public SKUCollection getSkus() {
        return this.skus;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeactivateOn(List<String> deactivateOn) {
        this.deactivateOn = deactivateOn;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setImages(List<String> images) {
        this.images = images;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    @Generated
    public void setShippable(Boolean shippable) {
        this.shippable = shippable;
    }

    @Generated
    public void setSkus(SKUCollection skus) {
        this.skus = skus;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        List<String> this$attributes = this.getAttributes();
        List<String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        List<String> this$deactivateOn = this.getDeactivateOn();
        List<String> other$deactivateOn = other.getDeactivateOn();
        if (this$deactivateOn == null ? other$deactivateOn != null : !((Object)this$deactivateOn).equals(other$deactivateOn)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$images = this.getImages();
        List<String> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PackageDimensions this$packageDimensions = this.getPackageDimensions();
        PackageDimensions other$packageDimensions = other.getPackageDimensions();
        if (this$packageDimensions == null ? other$packageDimensions != null : !((Object)this$packageDimensions).equals(other$packageDimensions)) {
            return false;
        }
        Boolean this$shippable = this.getShippable();
        Boolean other$shippable = other.getShippable();
        if (this$shippable == null ? other$shippable != null : !((Object)this$shippable).equals(other$shippable)) {
            return false;
        }
        SKUCollection this$skus = this.getSkus();
        SKUCollection other$skus = other.getSkus();
        if (this$skus == null ? other$skus != null : !this$skus.equals(other$skus)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        String this$url = this.getURL();
        String other$url = other.getURL();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        List<String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        List<String> $deactivateOn = this.getDeactivateOn();
        result = result * 59 + ($deactivateOn == null ? 43 : ((Object)$deactivateOn).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PackageDimensions $packageDimensions = this.getPackageDimensions();
        result = result * 59 + ($packageDimensions == null ? 43 : ((Object)$packageDimensions).hashCode());
        Boolean $shippable = this.getShippable();
        result = result * 59 + ($shippable == null ? 43 : ((Object)$shippable).hashCode());
        SKUCollection $skus = this.getSkus();
        result = result * 59 + ($skus == null ? 43 : $skus.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        String $url = this.getURL();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

