/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Plan;
import com.stripe.model.SubscriptionCollection;
import com.stripe.model.SubscriptionItemCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class Subscription
extends APIResource
implements MetadataStore<Subscription>,
HasId {
    String id;
    String object;
    Double applicationFeePercent;
    String billing;
    Long billingCycleAnchor;
    Boolean cancelAtPeriodEnd;
    Long canceledAt;
    Long created;
    Long currentPeriodEnd;
    Long currentPeriodStart;
    ExpandableField<Customer> customer;
    Integer daysUntilDue;
    Discount discount;
    Long endedAt;
    SubscriptionItemCollection items;
    Map<String, String> metadata;
    Plan plan;
    Integer quantity;
    Long start;
    String status;
    Double taxPercent;
    Long trialEnd;
    Long trialStart;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerID) {
        this.customer = Subscription.setExpandableFieldID(customerID, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public SubscriptionItemCollection getSubscriptionItems() {
        return this.items;
    }

    public void setSubscriptionItems(SubscriptionItemCollection items) {
        this.items = items;
    }

    @Deprecated
    public static SubscriptionCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.list(params, null);
    }

    @Deprecated
    public static SubscriptionCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.list(params, options);
    }

    public static Subscription create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.create(params, null);
    }

    public static Subscription create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.POST, Subscription.classURL(Subscription.class), params, Subscription.class, options);
    }

    public static SubscriptionCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.list(params, null);
    }

    public static SubscriptionCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.requestCollection(Subscription.classURL(Subscription.class), params, SubscriptionCollection.class, options);
    }

    public static Subscription retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.retrieve(id, null);
    }

    public static Subscription retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.GET, Subscription.instanceURL(Subscription.class, id), null, Subscription.class, options);
    }

    public static Subscription retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.GET, Subscription.instanceURL(Subscription.class, id), params, Subscription.class, options);
    }

    public Subscription update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.POST, Subscription.instanceURL(Subscription.class, this.id), params, Subscription.class, options);
    }

    public Subscription cancel(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(params, (RequestOptions)null);
    }

    @Deprecated
    public Subscription cancel(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription cancel(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Subscription.request(APIResource.RequestMethod.DELETE, Subscription.instanceURL(Subscription.class, this.id), params, Subscription.class, options);
    }

    public void deleteDiscount() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount((RequestOptions)null);
    }

    @Deprecated
    public void deleteDiscount(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        RequestOptions result = null;
        if (apiKey != null) {
            result = RequestOptions.builder().setApiKey(apiKey).build();
        }
        this.deleteDiscount(result);
    }

    public void deleteDiscount(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Subscription.request(APIResource.RequestMethod.DELETE, String.format("%s/discount", Subscription.instanceURL(Subscription.class, this.id)), null, Discount.class, options);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Double getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public String getBilling() {
        return this.billing;
    }

    @Generated
    public Long getBillingCycleAnchor() {
        return this.billingCycleAnchor;
    }

    @Generated
    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    @Generated
    public Long getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    @Generated
    public Integer getDaysUntilDue() {
        return this.daysUntilDue;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public Long getEndedAt() {
        return this.endedAt;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public Integer getQuantity() {
        return this.quantity;
    }

    @Generated
    public Long getStart() {
        return this.start;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Double getTaxPercent() {
        return this.taxPercent;
    }

    @Generated
    public Long getTrialEnd() {
        return this.trialEnd;
    }

    @Generated
    public Long getTrialStart() {
        return this.trialStart;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setApplicationFeePercent(Double applicationFeePercent) {
        this.applicationFeePercent = applicationFeePercent;
    }

    @Generated
    public void setBilling(String billing) {
        this.billing = billing;
    }

    @Generated
    public void setBillingCycleAnchor(Long billingCycleAnchor) {
        this.billingCycleAnchor = billingCycleAnchor;
    }

    @Generated
    public void setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrentPeriodEnd(Long currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    @Generated
    public void setCurrentPeriodStart(Long currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    @Generated
    public void setDaysUntilDue(Integer daysUntilDue) {
        this.daysUntilDue = daysUntilDue;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setStart(Long start) {
        this.start = start;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTaxPercent(Double taxPercent) {
        this.taxPercent = taxPercent;
    }

    @Generated
    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    @Generated
    public void setTrialStart(Long trialStart) {
        this.trialStart = trialStart;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Double this$applicationFeePercent = this.getApplicationFeePercent();
        Double other$applicationFeePercent = other.getApplicationFeePercent();
        if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
            return false;
        }
        String this$billing = this.getBilling();
        String other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) {
            return false;
        }
        Long this$billingCycleAnchor = this.getBillingCycleAnchor();
        Long other$billingCycleAnchor = other.getBillingCycleAnchor();
        if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !((Object)this$billingCycleAnchor).equals(other$billingCycleAnchor)) {
            return false;
        }
        Boolean this$cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        Boolean other$cancelAtPeriodEnd = other.getCancelAtPeriodEnd();
        if (this$cancelAtPeriodEnd == null ? other$cancelAtPeriodEnd != null : !((Object)this$cancelAtPeriodEnd).equals(other$cancelAtPeriodEnd)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$currentPeriodEnd = this.getCurrentPeriodEnd();
        Long other$currentPeriodEnd = other.getCurrentPeriodEnd();
        if (this$currentPeriodEnd == null ? other$currentPeriodEnd != null : !((Object)this$currentPeriodEnd).equals(other$currentPeriodEnd)) {
            return false;
        }
        Long this$currentPeriodStart = this.getCurrentPeriodStart();
        Long other$currentPeriodStart = other.getCurrentPeriodStart();
        if (this$currentPeriodStart == null ? other$currentPeriodStart != null : !((Object)this$currentPeriodStart).equals(other$currentPeriodStart)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Integer this$daysUntilDue = this.getDaysUntilDue();
        Integer other$daysUntilDue = other.getDaysUntilDue();
        if (this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Long this$endedAt = this.getEndedAt();
        Long other$endedAt = other.getEndedAt();
        if (this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt)) {
            return false;
        }
        SubscriptionItemCollection this$items = this.items;
        SubscriptionItemCollection other$items = other.items;
        if (this$items == null ? other$items != null : !this$items.equals(other$items)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Long this$start = this.getStart();
        Long other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Double this$taxPercent = this.getTaxPercent();
        Double other$taxPercent = other.getTaxPercent();
        if (this$taxPercent == null ? other$taxPercent != null : !((Object)this$taxPercent).equals(other$taxPercent)) {
            return false;
        }
        Long this$trialEnd = this.getTrialEnd();
        Long other$trialEnd = other.getTrialEnd();
        if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
            return false;
        }
        Long this$trialStart = this.getTrialStart();
        Long other$trialStart = other.getTrialStart();
        return !(this$trialStart == null ? other$trialStart != null : !((Object)this$trialStart).equals(other$trialStart));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Double $applicationFeePercent = this.getApplicationFeePercent();
        result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
        String $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : $billing.hashCode());
        Long $billingCycleAnchor = this.getBillingCycleAnchor();
        result = result * 59 + ($billingCycleAnchor == null ? 43 : ((Object)$billingCycleAnchor).hashCode());
        Boolean $cancelAtPeriodEnd = this.getCancelAtPeriodEnd();
        result = result * 59 + ($cancelAtPeriodEnd == null ? 43 : ((Object)$cancelAtPeriodEnd).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $currentPeriodEnd = this.getCurrentPeriodEnd();
        result = result * 59 + ($currentPeriodEnd == null ? 43 : ((Object)$currentPeriodEnd).hashCode());
        Long $currentPeriodStart = this.getCurrentPeriodStart();
        result = result * 59 + ($currentPeriodStart == null ? 43 : ((Object)$currentPeriodStart).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Integer $daysUntilDue = this.getDaysUntilDue();
        result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Long $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        SubscriptionItemCollection $items = this.items;
        result = result * 59 + ($items == null ? 43 : $items.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Long $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Double $taxPercent = this.getTaxPercent();
        result = result * 59 + ($taxPercent == null ? 43 : ((Object)$taxPercent).hashCode());
        Long $trialEnd = this.getTrialEnd();
        result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
        Long $trialStart = this.getTrialStart();
        result = result * 59 + ($trialStart == null ? 43 : ((Object)$trialStart).hashCode());
        return result;
    }
}

