/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BankAccount;
import com.stripe.model.Card;
import com.stripe.model.HasId;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class Token
extends APIResource
implements HasId {
    String id;
    String object;
    Long amount;
    BankAccount bankAccount;
    Card card;
    String clientIp;
    Long created;
    String currency;
    String email;
    Boolean livemode;
    String type;
    Boolean used;

    public static Token create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Token.create(params, (RequestOptions)null);
    }

    @Deprecated
    public static Token create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Token.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Token create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Token.request(APIResource.RequestMethod.POST, Token.classURL(Token.class), params, Token.class, options);
    }

    public static Token retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Token.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static Token retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Token.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Token retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Token.request(APIResource.RequestMethod.GET, Token.instanceURL(Token.class, id), null, Token.class, options);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public String getClientIp() {
        return this.clientIp;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getUsed() {
        return this.used;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUsed(Boolean used) {
        this.used = used;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BankAccount this$bankAccount = this.getBankAccount();
        BankAccount other$bankAccount = other.getBankAccount();
        if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Boolean this$used = this.getUsed();
        Boolean other$used = other.getUsed();
        return !(this$used == null ? other$used != null : !((Object)this$used).equals(other$used));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BankAccount $bankAccount = this.getBankAccount();
        result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Boolean $used = this.getUsed();
        result = result * 59 + ($used == null ? 43 : ((Object)$used).hashCode());
        return result;
    }
}

