/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BalanceTransactionCollection;
import com.stripe.model.ExpandableField;
import com.stripe.model.Fee;
import com.stripe.model.HasId;
import com.stripe.model.TransferCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class BalanceTransaction
extends APIResource
implements HasId {
    String id;
    String object;
    Long amount;
    Long availableOn;
    Long created;
    String currency;
    String description;
    Long fee;
    List<Fee> feeDetails;
    Integer net;
    ExpandableField<HasId> source;
    String status;
    String type;
    @Deprecated
    TransferCollection sourcedTransfers;

    public String getSource() {
        return this.source != null ? this.source.getId() : null;
    }

    public void setSource(String sourceID) {
        this.source = BalanceTransaction.setExpandableFieldID(sourceID, this.source);
    }

    public HasId getSourceObject() {
        return this.source != null ? this.source.getExpanded() : null;
    }

    public void setSourceObject(HasId o) {
        this.source = new ExpandableField<HasId>(o.getId(), o);
    }

    public <O extends HasId> O getSourceObjectAs() {
        return (O)(this.source != null ? this.source.getExpanded() : null);
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, null);
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static BalanceTransactionCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, options);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.list(params, null);
    }

    public static BalanceTransactionCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s", Stripe.getApiBase(), "v1/balance/history");
        return BalanceTransaction.requestCollection(url, params, BalanceTransactionCollection.class, options);
    }

    public static BalanceTransaction retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.retrieve(id, (RequestOptions)null);
    }

    public static BalanceTransaction retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s/%s/%s", Stripe.getApiBase(), "v1/balance/history", id);
        return BalanceTransaction.request(APIResource.RequestMethod.GET, url, null, BalanceTransaction.class, options);
    }

    @Deprecated
    public static BalanceTransaction retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BalanceTransaction.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAvailableOn() {
        return this.availableOn;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Long getFee() {
        return this.fee;
    }

    @Generated
    public List<Fee> getFeeDetails() {
        return this.feeDetails;
    }

    @Generated
    public Integer getNet() {
        return this.net;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Deprecated
    @Generated
    public TransferCollection getSourcedTransfers() {
        return this.sourcedTransfers;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAvailableOn(Long availableOn) {
        this.availableOn = availableOn;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFee(Long fee) {
        this.fee = fee;
    }

    @Generated
    public void setFeeDetails(List<Fee> feeDetails) {
        this.feeDetails = feeDetails;
    }

    @Generated
    public void setNet(Integer net) {
        this.net = net;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    @Generated
    public void setSourcedTransfers(TransferCollection sourcedTransfers) {
        this.sourcedTransfers = sourcedTransfers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BalanceTransaction)) {
            return false;
        }
        BalanceTransaction other = (BalanceTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$availableOn = this.getAvailableOn();
        Long other$availableOn = other.getAvailableOn();
        if (this$availableOn == null ? other$availableOn != null : !((Object)this$availableOn).equals(other$availableOn)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Long this$fee = this.getFee();
        Long other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        List<Fee> this$feeDetails = this.getFeeDetails();
        List<Fee> other$feeDetails = other.getFeeDetails();
        if (this$feeDetails == null ? other$feeDetails != null : !((Object)this$feeDetails).equals(other$feeDetails)) {
            return false;
        }
        Integer this$net = this.getNet();
        Integer other$net = other.getNet();
        if (this$net == null ? other$net != null : !((Object)this$net).equals(other$net)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TransferCollection this$sourcedTransfers = this.getSourcedTransfers();
        TransferCollection other$sourcedTransfers = other.getSourcedTransfers();
        return !(this$sourcedTransfers == null ? other$sourcedTransfers != null : !this$sourcedTransfers.equals(other$sourcedTransfers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BalanceTransaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $availableOn = this.getAvailableOn();
        result = result * 59 + ($availableOn == null ? 43 : ((Object)$availableOn).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Long $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        List<Fee> $feeDetails = this.getFeeDetails();
        result = result * 59 + ($feeDetails == null ? 43 : ((Object)$feeDetails).hashCode());
        Integer $net = this.getNet();
        result = result * 59 + ($net == null ? 43 : ((Object)$net).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TransferCollection $sourcedTransfers = this.getSourcedTransfers();
        result = result * 59 + ($sourcedTransfers == null ? 43 : $sourcedTransfers.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

