/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Charge;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class Invoice
extends APIResource
implements MetadataStore<Invoice>,
HasId {
    String id;
    String object;
    Long amountDue;
    Long amountPaid;
    Long amountRemaining;
    Long applicationFee;
    Integer attemptCount;
    Boolean attempted;
    String billing;
    String billingReason;
    ExpandableField<Charge> charge;
    Boolean closed;
    Long created;
    String currency;
    String customer;
    Long date;
    String description;
    Discount discount;
    Long dueDate;
    Long endingBalance;
    Boolean forgiven;
    @SerializedName(value="hosted_invoice_url")
    String hostedInvoiceURL;
    @SerializedName(value="invoice_pdf")
    String invoicePDF;
    InvoiceLineItemCollection lines;
    Boolean livemode;
    Map<String, String> metadata;
    Long nextPaymentAttempt;
    String number;
    Boolean paid;
    Long periodEnd;
    Long periodStart;
    String receiptNumber;
    Long startingBalance;
    String statementDescriptor;
    ExpandableField<Subscription> subscription;
    Long subscriptionProrationDate;
    Long subtotal;
    Long tax;
    Double taxPercent;
    Long total;
    Long webhooksDeliveredAt;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String chargeID) {
        this.charge = Invoice.setExpandableFieldID(chargeID, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge charge) {
        this.charge = new ExpandableField<Charge>(charge.getId(), charge);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String subscriptionID) {
        this.subscription = Invoice.setExpandableFieldID(subscriptionID, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription subscription) {
        this.subscription = new ExpandableField<Subscription>(subscription.getId(), subscription);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, null);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, options);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, (RequestOptions)null);
    }

    public static Invoice create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.classURL(Invoice.class), params, Invoice.class, options);
    }

    @Deprecated
    public static Invoice create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static InvoiceCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, null);
    }

    public static InvoiceCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.requestCollection(Invoice.classURL(Invoice.class), params, InvoiceCollection.class, options);
    }

    public Invoice pay() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay((RequestOptions)null);
    }

    @Deprecated
    public Invoice pay(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(null, options);
    }

    @Deprecated
    public Invoice pay(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Invoice pay(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(params, null);
    }

    public Invoice pay(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, String.format("%s/pay", Invoice.instanceURL(Invoice.class, this.getId())), params, Invoice.class, options);
    }

    public static Invoice retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, (RequestOptions)null);
    }

    public static Invoice retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), null, Invoice.class, options);
    }

    @Deprecated
    public static Invoice retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), params, Invoice.class, options);
    }

    public static Invoice upcoming(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, (RequestOptions)null);
    }

    public static Invoice upcoming(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, String.format("%s/upcoming", Invoice.classURL(Invoice.class)), params, Invoice.class, options);
    }

    @Deprecated
    public static Invoice upcoming(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Invoice update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Invoice update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.instanceURL(Invoice.class, this.id), params, Invoice.class, options);
    }

    @Deprecated
    public Invoice update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmountDue() {
        return this.amountDue;
    }

    @Generated
    public Long getAmountPaid() {
        return this.amountPaid;
    }

    @Generated
    public Long getAmountRemaining() {
        return this.amountRemaining;
    }

    @Generated
    public Long getApplicationFee() {
        return this.applicationFee;
    }

    @Generated
    public Integer getAttemptCount() {
        return this.attemptCount;
    }

    @Generated
    public Boolean getAttempted() {
        return this.attempted;
    }

    @Generated
    public String getBilling() {
        return this.billing;
    }

    @Generated
    public String getBillingReason() {
        return this.billingReason;
    }

    @Generated
    public Boolean getClosed() {
        return this.closed;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public Long getDate() {
        return this.date;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Discount getDiscount() {
        return this.discount;
    }

    @Generated
    public Long getDueDate() {
        return this.dueDate;
    }

    @Generated
    public Long getEndingBalance() {
        return this.endingBalance;
    }

    @Generated
    public Boolean getForgiven() {
        return this.forgiven;
    }

    @Generated
    public String getHostedInvoiceURL() {
        return this.hostedInvoiceURL;
    }

    @Generated
    public String getInvoicePDF() {
        return this.invoicePDF;
    }

    @Generated
    public InvoiceLineItemCollection getLines() {
        return this.lines;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getNextPaymentAttempt() {
        return this.nextPaymentAttempt;
    }

    @Generated
    public String getNumber() {
        return this.number;
    }

    @Generated
    public Boolean getPaid() {
        return this.paid;
    }

    @Generated
    public Long getPeriodEnd() {
        return this.periodEnd;
    }

    @Generated
    public Long getPeriodStart() {
        return this.periodStart;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public Long getStartingBalance() {
        return this.startingBalance;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public Long getSubscriptionProrationDate() {
        return this.subscriptionProrationDate;
    }

    @Generated
    public Long getSubtotal() {
        return this.subtotal;
    }

    @Generated
    public Long getTax() {
        return this.tax;
    }

    @Generated
    public Double getTaxPercent() {
        return this.taxPercent;
    }

    @Generated
    public Long getTotal() {
        return this.total;
    }

    @Generated
    public Long getWebhooksDeliveredAt() {
        return this.webhooksDeliveredAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmountDue(Long amountDue) {
        this.amountDue = amountDue;
    }

    @Generated
    public void setAmountPaid(Long amountPaid) {
        this.amountPaid = amountPaid;
    }

    @Generated
    public void setAmountRemaining(Long amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    @Generated
    public void setApplicationFee(Long applicationFee) {
        this.applicationFee = applicationFee;
    }

    @Generated
    public void setAttemptCount(Integer attemptCount) {
        this.attemptCount = attemptCount;
    }

    @Generated
    public void setAttempted(Boolean attempted) {
        this.attempted = attempted;
    }

    @Generated
    public void setBilling(String billing) {
        this.billing = billing;
    }

    @Generated
    public void setBillingReason(String billingReason) {
        this.billingReason = billingReason;
    }

    @Generated
    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setDate(Long date) {
        this.date = date;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    @Generated
    public void setDueDate(Long dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setEndingBalance(Long endingBalance) {
        this.endingBalance = endingBalance;
    }

    @Generated
    public void setForgiven(Boolean forgiven) {
        this.forgiven = forgiven;
    }

    @Generated
    public void setHostedInvoiceURL(String hostedInvoiceURL) {
        this.hostedInvoiceURL = hostedInvoiceURL;
    }

    @Generated
    public void setInvoicePDF(String invoicePDF) {
        this.invoicePDF = invoicePDF;
    }

    @Generated
    public void setLines(InvoiceLineItemCollection lines) {
        this.lines = lines;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextPaymentAttempt(Long nextPaymentAttempt) {
        this.nextPaymentAttempt = nextPaymentAttempt;
    }

    @Generated
    public void setNumber(String number) {
        this.number = number;
    }

    @Generated
    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    @Generated
    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    @Generated
    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setStartingBalance(Long startingBalance) {
        this.startingBalance = startingBalance;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setSubscriptionProrationDate(Long subscriptionProrationDate) {
        this.subscriptionProrationDate = subscriptionProrationDate;
    }

    @Generated
    public void setSubtotal(Long subtotal) {
        this.subtotal = subtotal;
    }

    @Generated
    public void setTax(Long tax) {
        this.tax = tax;
    }

    @Generated
    public void setTaxPercent(Double taxPercent) {
        this.taxPercent = taxPercent;
    }

    @Generated
    public void setTotal(Long total) {
        this.total = total;
    }

    @Generated
    public void setWebhooksDeliveredAt(Long webhooksDeliveredAt) {
        this.webhooksDeliveredAt = webhooksDeliveredAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amountDue = this.getAmountDue();
        Long other$amountDue = other.getAmountDue();
        if (this$amountDue == null ? other$amountDue != null : !((Object)this$amountDue).equals(other$amountDue)) {
            return false;
        }
        Long this$amountPaid = this.getAmountPaid();
        Long other$amountPaid = other.getAmountPaid();
        if (this$amountPaid == null ? other$amountPaid != null : !((Object)this$amountPaid).equals(other$amountPaid)) {
            return false;
        }
        Long this$amountRemaining = this.getAmountRemaining();
        Long other$amountRemaining = other.getAmountRemaining();
        if (this$amountRemaining == null ? other$amountRemaining != null : !((Object)this$amountRemaining).equals(other$amountRemaining)) {
            return false;
        }
        Long this$applicationFee = this.getApplicationFee();
        Long other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !((Object)this$applicationFee).equals(other$applicationFee)) {
            return false;
        }
        Integer this$attemptCount = this.getAttemptCount();
        Integer other$attemptCount = other.getAttemptCount();
        if (this$attemptCount == null ? other$attemptCount != null : !((Object)this$attemptCount).equals(other$attemptCount)) {
            return false;
        }
        Boolean this$attempted = this.getAttempted();
        Boolean other$attempted = other.getAttempted();
        if (this$attempted == null ? other$attempted != null : !((Object)this$attempted).equals(other$attempted)) {
            return false;
        }
        String this$billing = this.getBilling();
        String other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !this$billing.equals(other$billing)) {
            return false;
        }
        String this$billingReason = this.getBillingReason();
        String other$billingReason = other.getBillingReason();
        if (this$billingReason == null ? other$billingReason != null : !this$billingReason.equals(other$billingReason)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        Boolean this$closed = this.getClosed();
        Boolean other$closed = other.getClosed();
        if (this$closed == null ? other$closed != null : !((Object)this$closed).equals(other$closed)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Discount this$discount = this.getDiscount();
        Discount other$discount = other.getDiscount();
        if (this$discount == null ? other$discount != null : !((Object)this$discount).equals(other$discount)) {
            return false;
        }
        Long this$dueDate = this.getDueDate();
        Long other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Long this$endingBalance = this.getEndingBalance();
        Long other$endingBalance = other.getEndingBalance();
        if (this$endingBalance == null ? other$endingBalance != null : !((Object)this$endingBalance).equals(other$endingBalance)) {
            return false;
        }
        Boolean this$forgiven = this.getForgiven();
        Boolean other$forgiven = other.getForgiven();
        if (this$forgiven == null ? other$forgiven != null : !((Object)this$forgiven).equals(other$forgiven)) {
            return false;
        }
        String this$hostedInvoiceURL = this.getHostedInvoiceURL();
        String other$hostedInvoiceURL = other.getHostedInvoiceURL();
        if (this$hostedInvoiceURL == null ? other$hostedInvoiceURL != null : !this$hostedInvoiceURL.equals(other$hostedInvoiceURL)) {
            return false;
        }
        String this$invoicePDF = this.getInvoicePDF();
        String other$invoicePDF = other.getInvoicePDF();
        if (this$invoicePDF == null ? other$invoicePDF != null : !this$invoicePDF.equals(other$invoicePDF)) {
            return false;
        }
        InvoiceLineItemCollection this$lines = this.getLines();
        InvoiceLineItemCollection other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !this$lines.equals(other$lines)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Long this$nextPaymentAttempt = this.getNextPaymentAttempt();
        Long other$nextPaymentAttempt = other.getNextPaymentAttempt();
        if (this$nextPaymentAttempt == null ? other$nextPaymentAttempt != null : !((Object)this$nextPaymentAttempt).equals(other$nextPaymentAttempt)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        Boolean this$paid = this.getPaid();
        Boolean other$paid = other.getPaid();
        if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
            return false;
        }
        Long this$periodEnd = this.getPeriodEnd();
        Long other$periodEnd = other.getPeriodEnd();
        if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
            return false;
        }
        Long this$periodStart = this.getPeriodStart();
        Long other$periodStart = other.getPeriodStart();
        if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        Long this$startingBalance = this.getStartingBalance();
        Long other$startingBalance = other.getStartingBalance();
        if (this$startingBalance == null ? other$startingBalance != null : !((Object)this$startingBalance).equals(other$startingBalance)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        Long this$subscriptionProrationDate = this.getSubscriptionProrationDate();
        Long other$subscriptionProrationDate = other.getSubscriptionProrationDate();
        if (this$subscriptionProrationDate == null ? other$subscriptionProrationDate != null : !((Object)this$subscriptionProrationDate).equals(other$subscriptionProrationDate)) {
            return false;
        }
        Long this$subtotal = this.getSubtotal();
        Long other$subtotal = other.getSubtotal();
        if (this$subtotal == null ? other$subtotal != null : !((Object)this$subtotal).equals(other$subtotal)) {
            return false;
        }
        Long this$tax = this.getTax();
        Long other$tax = other.getTax();
        if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
            return false;
        }
        Double this$taxPercent = this.getTaxPercent();
        Double other$taxPercent = other.getTaxPercent();
        if (this$taxPercent == null ? other$taxPercent != null : !((Object)this$taxPercent).equals(other$taxPercent)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Long this$webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        Long other$webhooksDeliveredAt = other.getWebhooksDeliveredAt();
        return !(this$webhooksDeliveredAt == null ? other$webhooksDeliveredAt != null : !((Object)this$webhooksDeliveredAt).equals(other$webhooksDeliveredAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Invoice;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amountDue = this.getAmountDue();
        result = result * 59 + ($amountDue == null ? 43 : ((Object)$amountDue).hashCode());
        Long $amountPaid = this.getAmountPaid();
        result = result * 59 + ($amountPaid == null ? 43 : ((Object)$amountPaid).hashCode());
        Long $amountRemaining = this.getAmountRemaining();
        result = result * 59 + ($amountRemaining == null ? 43 : ((Object)$amountRemaining).hashCode());
        Long $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : ((Object)$applicationFee).hashCode());
        Integer $attemptCount = this.getAttemptCount();
        result = result * 59 + ($attemptCount == null ? 43 : ((Object)$attemptCount).hashCode());
        Boolean $attempted = this.getAttempted();
        result = result * 59 + ($attempted == null ? 43 : ((Object)$attempted).hashCode());
        String $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : $billing.hashCode());
        String $billingReason = this.getBillingReason();
        result = result * 59 + ($billingReason == null ? 43 : $billingReason.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        Boolean $closed = this.getClosed();
        result = result * 59 + ($closed == null ? 43 : ((Object)$closed).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Discount $discount = this.getDiscount();
        result = result * 59 + ($discount == null ? 43 : ((Object)$discount).hashCode());
        Long $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Long $endingBalance = this.getEndingBalance();
        result = result * 59 + ($endingBalance == null ? 43 : ((Object)$endingBalance).hashCode());
        Boolean $forgiven = this.getForgiven();
        result = result * 59 + ($forgiven == null ? 43 : ((Object)$forgiven).hashCode());
        String $hostedInvoiceURL = this.getHostedInvoiceURL();
        result = result * 59 + ($hostedInvoiceURL == null ? 43 : $hostedInvoiceURL.hashCode());
        String $invoicePDF = this.getInvoicePDF();
        result = result * 59 + ($invoicePDF == null ? 43 : $invoicePDF.hashCode());
        InvoiceLineItemCollection $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : $lines.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Long $nextPaymentAttempt = this.getNextPaymentAttempt();
        result = result * 59 + ($nextPaymentAttempt == null ? 43 : ((Object)$nextPaymentAttempt).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        Boolean $paid = this.getPaid();
        result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
        Long $periodEnd = this.getPeriodEnd();
        result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
        Long $periodStart = this.getPeriodStart();
        result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        Long $startingBalance = this.getStartingBalance();
        result = result * 59 + ($startingBalance == null ? 43 : ((Object)$startingBalance).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        Long $subscriptionProrationDate = this.getSubscriptionProrationDate();
        result = result * 59 + ($subscriptionProrationDate == null ? 43 : ((Object)$subscriptionProrationDate).hashCode());
        Long $subtotal = this.getSubtotal();
        result = result * 59 + ($subtotal == null ? 43 : ((Object)$subtotal).hashCode());
        Long $tax = this.getTax();
        result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
        Double $taxPercent = this.getTaxPercent();
        result = result * 59 + ($taxPercent == null ? 43 : ((Object)$taxPercent).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Long $webhooksDeliveredAt = this.getWebhooksDeliveredAt();
        result = result * 59 + ($webhooksDeliveredAt == null ? 43 : ((Object)$webhooksDeliveredAt).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

