/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.model.BankAccount;
import com.stripe.model.Card;
import com.stripe.model.DeletedRecipient;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.RecipientCardCollection;
import com.stripe.model.RecipientCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class Recipient
extends APIResource
implements MetadataStore<Recipient>,
HasId {
    String id;
    String object;
    BankAccount activeAccount;
    RecipientCardCollection cards;
    Long created;
    ExpandableField<Card> defaultCard;
    Boolean deleted;
    String description;
    String email;
    Boolean livemode;
    Map<String, String> metadata;
    ExpandableField<Account> migratedTo;
    String name;
    String type;
    Boolean verified;

    public String getDefaultCard() {
        return this.defaultCard != null ? this.defaultCard.getId() : null;
    }

    public void setDefaultCard(String defaultCardID) {
        this.defaultCard = APIResource.setExpandableFieldID(defaultCardID, this.defaultCard);
    }

    public Card getDefaultCardObject() {
        return this.defaultCard != null ? this.defaultCard.getExpanded() : null;
    }

    public void setDefaultCardObject(Card c) {
        this.defaultCard = new ExpandableField<Card>(c.getId(), c);
    }

    public String getMigratedTo() {
        return this.migratedTo != null ? this.migratedTo.getId() : null;
    }

    public void setMigratedTo(String migratedToID) {
        this.migratedTo = APIResource.setExpandableFieldID(migratedToID, this.migratedTo);
    }

    public Account getMigratedToObject() {
        return this.migratedTo != null ? this.migratedTo.getExpanded() : null;
    }

    public void setMigratedToObject(Account c) {
        this.migratedTo = new ExpandableField<Account>(c.getId(), c);
    }

    @Deprecated
    public static RecipientCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.list(params, null);
    }

    @Deprecated
    public static RecipientCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.list(params, options);
    }

    @Deprecated
    public static RecipientCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Recipient create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.create(params, (RequestOptions)null);
    }

    public static Recipient create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.request(APIResource.RequestMethod.POST, Recipient.classURL(Recipient.class), params, Recipient.class, options);
    }

    @Deprecated
    public static Recipient create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Card createCard(String token) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(token, (RequestOptions)null);
    }

    public Card createCard(String token, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("card", token);
        return this.createCard(postParams, options);
    }

    @Deprecated
    public Card createCard(String token, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(token, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Card createCard(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(params, (RequestOptions)null);
    }

    public Card createCard(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.request(APIResource.RequestMethod.POST, String.format("%s/cards", Recipient.instanceURL(Recipient.class, this.id)), params, Card.class, options);
    }

    @Deprecated
    public Card createCard(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public DeletedRecipient delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    public DeletedRecipient delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.request(APIResource.RequestMethod.DELETE, Recipient.instanceURL(Recipient.class, this.id), null, DeletedRecipient.class, options);
    }

    @Deprecated
    public DeletedRecipient delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static RecipientCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.list(params, null);
    }

    public static RecipientCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.requestCollection(Recipient.classURL(Recipient.class), params, RecipientCollection.class, options);
    }

    public static Recipient retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.retrieve(id, (RequestOptions)null);
    }

    public static Recipient retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.request(APIResource.RequestMethod.GET, Recipient.instanceURL(Recipient.class, id), null, Recipient.class, options);
    }

    @Deprecated
    public static Recipient retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Recipient retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.request(APIResource.RequestMethod.GET, Recipient.instanceURL(Recipient.class, id), params, Recipient.class, options);
    }

    public Recipient update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Recipient update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Recipient.request(APIResource.RequestMethod.POST, Recipient.instanceURL(Recipient.class, this.id), params, Recipient.class, options);
    }

    @Deprecated
    public Recipient update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public BankAccount getActiveAccount() {
        return this.activeAccount;
    }

    @Generated
    public RecipientCardCollection getCards() {
        return this.cards;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getVerified() {
        return this.verified;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setActiveAccount(BankAccount activeAccount) {
        this.activeAccount = activeAccount;
    }

    @Generated
    public void setCards(RecipientCardCollection cards) {
        this.cards = cards;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recipient)) {
            return false;
        }
        Recipient other = (Recipient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        BankAccount this$activeAccount = this.getActiveAccount();
        BankAccount other$activeAccount = other.getActiveAccount();
        if (this$activeAccount == null ? other$activeAccount != null : !((Object)this$activeAccount).equals(other$activeAccount)) {
            return false;
        }
        RecipientCardCollection this$cards = this.getCards();
        RecipientCardCollection other$cards = other.getCards();
        if (this$cards == null ? other$cards != null : !this$cards.equals(other$cards)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$defaultCard = this.getDefaultCard();
        String other$defaultCard = other.getDefaultCard();
        if (this$defaultCard == null ? other$defaultCard != null : !this$defaultCard.equals(other$defaultCard)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$migratedTo = this.getMigratedTo();
        String other$migratedTo = other.getMigratedTo();
        if (this$migratedTo == null ? other$migratedTo != null : !this$migratedTo.equals(other$migratedTo)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Boolean this$verified = this.getVerified();
        Boolean other$verified = other.getVerified();
        return !(this$verified == null ? other$verified != null : !((Object)this$verified).equals(other$verified));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Recipient;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        BankAccount $activeAccount = this.getActiveAccount();
        result = result * 59 + ($activeAccount == null ? 43 : ((Object)$activeAccount).hashCode());
        RecipientCardCollection $cards = this.getCards();
        result = result * 59 + ($cards == null ? 43 : $cards.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $defaultCard = this.getDefaultCard();
        result = result * 59 + ($defaultCard == null ? 43 : $defaultCard.hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $migratedTo = this.getMigratedTo();
        result = result * 59 + ($migratedTo == null ? 43 : $migratedTo.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Boolean $verified = this.getVerified();
        result = result * 59 + ($verified == null ? 43 : ((Object)$verified).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

