/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;

public class RequestOptions {
    private final String apiKey;
    private final String clientId;
    private final String stripeVersion;
    private final String idempotencyKey;
    private final String stripeAccount;
    private final int connectTimeout;
    private final int readTimeout;

    public static RequestOptions getDefault() {
        return new RequestOptions(Stripe.apiKey, Stripe.clientId, Stripe.apiVersion, null, null, Stripe.getConnectTimeout(), Stripe.getReadTimeout());
    }

    private RequestOptions(String apiKey, String clientId, String stripeVersion, String idempotencyKey, String stripeAccount, int connectTimeout, int readTimeout) {
        this.apiKey = apiKey;
        this.clientId = clientId;
        this.stripeVersion = stripeVersion;
        this.idempotencyKey = idempotencyKey;
        this.stripeAccount = stripeAccount;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getStripeVersion() {
        return this.stripeVersion;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public String getStripeAccount() {
        return this.stripeAccount;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestOptions that = (RequestOptions)o;
        if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) {
            return false;
        }
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.idempotencyKey != null ? !this.idempotencyKey.equals(that.idempotencyKey) : that.idempotencyKey != null) {
            return false;
        }
        if (this.stripeVersion != null ? !this.stripeVersion.equals(that.stripeVersion) : that.stripeVersion != null) {
            return false;
        }
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        return this.readTimeout == that.readTimeout;
    }

    public int hashCode() {
        int result = this.apiKey != null ? this.apiKey.hashCode() : 0;
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.stripeVersion != null ? this.stripeVersion.hashCode() : 0);
        result = 31 * result + (this.idempotencyKey != null ? this.idempotencyKey.hashCode() : 0);
        result = 31 * result + this.readTimeout;
        result = 31 * result + this.connectTimeout;
        return result;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder().setApiKey(this.apiKey).setStripeVersion(this.stripeVersion).setStripeAccount(this.stripeAccount);
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty API key specified!");
        }
        return normalized;
    }

    private static String normalizeClientId(String clientId) {
        if (clientId == null) {
            return null;
        }
        String normalized = clientId.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty client_id specified!");
        }
        return normalized;
    }

    private static String normalizeStripeVersion(String stripeVersion) {
        if (stripeVersion == null) {
            return null;
        }
        String normalized = stripeVersion.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Stripe version specified!");
        }
        return normalized;
    }

    private static String normalizeIdempotencyKey(String idempotencyKey) {
        if (idempotencyKey == null) {
            return null;
        }
        String normalized = idempotencyKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Idempotency Key Specified!");
        }
        if (normalized.length() > 255) {
            throw new InvalidRequestOptionsException(String.format("Idempotency Key length was %d, which is larger than the 255 character maximum!", normalized.length()));
        }
        return normalized;
    }

    private static String normalizeStripeAccount(String stripeAccount) {
        if (stripeAccount == null) {
            return null;
        }
        String normalized = stripeAccount.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty stripe account specified!");
        }
        return normalized;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Stripe.apiKey;
        private String clientId = Stripe.clientId;
        private String stripeVersion = Stripe.apiVersion;
        private String idempotencyKey;
        private String stripeAccount;
        private int connectTimeout;
        private int readTimeout;

        public String getApiKey() {
            return this.apiKey;
        }

        public String getClientId() {
            return this.clientId;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public RequestOptionsBuilder setStripeVersion(String stripeVersion) {
            this.stripeVersion = RequestOptions.normalizeStripeVersion(stripeVersion);
            return this;
        }

        public RequestOptionsBuilder clearStripeVersion() {
            this.stripeVersion = null;
            return this;
        }

        public RequestOptionsBuilder setIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public RequestOptionsBuilder setConnectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public RequestOptionsBuilder setReadTimeout(int timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public RequestOptionsBuilder clearIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public String getStripeAccount() {
            return this.stripeAccount;
        }

        public RequestOptionsBuilder setStripeAccount(String stripeAccount) {
            this.stripeAccount = stripeAccount;
            return this;
        }

        public RequestOptionsBuilder clearStripeAccount() {
            return this.setStripeAccount(null);
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiKey(this.apiKey), RequestOptions.normalizeClientId(this.clientId), RequestOptions.normalizeStripeVersion(this.stripeVersion), RequestOptions.normalizeIdempotencyKey(this.idempotencyKey), RequestOptions.normalizeStripeAccount(this.stripeAccount), this.connectTimeout, this.readTimeout);
        }
    }
}

