/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BankAccount;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.Summary;
import com.stripe.model.TransferCollection;
import com.stripe.model.TransferReversalCollection;
import com.stripe.model.TransferTransactionCollection;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Transfer
extends APIResource
implements MetadataStore<Transfer>,
HasId {
    String id;
    String object;
    Long amount;
    Long amountReversed;
    String applicationFee;
    ExpandableField<BalanceTransaction> balanceTransaction;
    BankAccount bankAccount;
    Long created;
    String currency;
    Long date;
    String description;
    ExpandableField<Account> destination;
    ExpandableField<Charge> destinationPayment;
    String failureCode;
    String failureMessage;
    Boolean livemode;
    Map<String, String> metadata;
    TransferReversalCollection reversals;
    Boolean reversed;
    ExpandableField<Charge> sourceTransaction;
    String sourceType;
    String statementDescriptor;
    String status;
    String transferGroup;
    String type;
    @Deprecated
    BankAccount account;
    @Deprecated
    List<String> otherTransfers;
    @Deprecated
    String recipient;
    @Deprecated
    String statementDescription;
    @Deprecated
    Summary summary;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String balanceTransactionID) {
        this.balanceTransaction = Transfer.setExpandableFieldID(balanceTransactionID, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction c) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String destinationID) {
        this.destination = APIResource.setExpandableFieldID(destinationID, this.destination);
    }

    public Account getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account c) {
        this.destination = new ExpandableField<Account>(c.getId(), c);
    }

    public String getDestinationPayment() {
        return this.destinationPayment != null ? this.destinationPayment.getId() : null;
    }

    public void setDestinationPayment(String destinationPaymentID) {
        this.destinationPayment = Transfer.setExpandableFieldID(destinationPaymentID, this.destinationPayment);
    }

    public Charge getDestinationPaymentObject() {
        return this.destinationPayment != null ? this.destinationPayment.getExpanded() : null;
    }

    public void setDestinationPaymentObject(Charge destinationPayment) {
        this.destinationPayment = new ExpandableField<Charge>(destinationPayment.getId(), destinationPayment);
    }

    public TransferReversalCollection getReversals() {
        if (this.reversals.getURL() == null) {
            this.reversals.setURL(String.format("/v1/transfers/%s/reversals", this.getId()));
        }
        return this.reversals;
    }

    public String getSourceTransaction() {
        return this.sourceTransaction != null ? this.sourceTransaction.getId() : null;
    }

    public void setSourceTransaction(String sourceTransactionID) {
        this.sourceTransaction = Transfer.setExpandableFieldID(sourceTransactionID, this.sourceTransaction);
    }

    public Charge getSourceTransactionObject() {
        return this.sourceTransaction != null ? this.sourceTransaction.getExpanded() : null;
    }

    public void setSourceTransactionObject(Charge sourceTransaction) {
        this.sourceTransaction = new ExpandableField<Charge>(sourceTransaction.getId(), sourceTransaction);
    }

    @Deprecated
    public static TransferCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, null);
    }

    @Deprecated
    public static TransferCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, options);
    }

    @Deprecated
    public static TransferCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Transfer cancel() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel((RequestOptions)null);
    }

    @Deprecated
    public Transfer cancel(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.POST, Transfer.instanceURL(Transfer.class, this.id) + "/cancel", null, Transfer.class, options);
    }

    @Deprecated
    public Transfer cancel(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancel(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Transfer create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.create(params, (RequestOptions)null);
    }

    public static Transfer create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.POST, Transfer.classURL(Transfer.class), params, Transfer.class, options);
    }

    @Deprecated
    public static Transfer create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static TransferCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.list(params, null);
    }

    public static TransferCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.requestCollection(Transfer.classURL(Transfer.class), params, TransferCollection.class, options);
    }

    public static Transfer retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.retrieve(id, (RequestOptions)null);
    }

    public static Transfer retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.GET, Transfer.instanceURL(Transfer.class, id), null, Transfer.class, options);
    }

    @Deprecated
    public static Transfer retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Transfer retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.GET, Transfer.instanceURL(Transfer.class, id), params, Transfer.class, options);
    }

    @Deprecated
    public TransferTransactionCollection transactions(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.transactions(params, (RequestOptions)null);
    }

    @Deprecated
    public TransferTransactionCollection transactions(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String url = String.format("%s%s", Transfer.instanceURL(Transfer.class, this.getId()), "/transactions");
        return Transfer.requestCollection(url, params, TransferTransactionCollection.class, options);
    }

    @Deprecated
    public TransferTransactionCollection transactions(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.transactions(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Transfer update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Transfer update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Transfer.request(APIResource.RequestMethod.POST, Transfer.instanceURL(Transfer.class, this.id), params, Transfer.class, options);
    }

    @Deprecated
    public Transfer update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountReversed() {
        return this.amountReversed;
    }

    @Generated
    public String getApplicationFee() {
        return this.applicationFee;
    }

    @Generated
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getDate() {
        return this.date;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Boolean getReversed() {
        return this.reversed;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Deprecated
    @Generated
    public BankAccount getAccount() {
        return this.account;
    }

    @Deprecated
    @Generated
    public List<String> getOtherTransfers() {
        return this.otherTransfers;
    }

    @Deprecated
    @Generated
    public String getRecipient() {
        return this.recipient;
    }

    @Deprecated
    @Generated
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Deprecated
    @Generated
    public Summary getSummary() {
        return this.summary;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountReversed(Long amountReversed) {
        this.amountReversed = amountReversed;
    }

    @Generated
    public void setApplicationFee(String applicationFee) {
        this.applicationFee = applicationFee;
    }

    @Generated
    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDate(Long date) {
        this.date = date;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setReversals(TransferReversalCollection reversals) {
        this.reversals = reversals;
    }

    @Generated
    public void setReversed(Boolean reversed) {
        this.reversed = reversed;
    }

    @Generated
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    @Generated
    public void setAccount(BankAccount account) {
        this.account = account;
    }

    @Deprecated
    @Generated
    public void setOtherTransfers(List<String> otherTransfers) {
        this.otherTransfers = otherTransfers;
    }

    @Deprecated
    @Generated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Deprecated
    @Generated
    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    @Deprecated
    @Generated
    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transfer)) {
            return false;
        }
        Transfer other = (Transfer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountReversed = this.getAmountReversed();
        Long other$amountReversed = other.getAmountReversed();
        if (this$amountReversed == null ? other$amountReversed != null : !((Object)this$amountReversed).equals(other$amountReversed)) {
            return false;
        }
        String this$applicationFee = this.getApplicationFee();
        String other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        BankAccount this$bankAccount = this.getBankAccount();
        BankAccount other$bankAccount = other.getBankAccount();
        if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$destinationPayment = this.getDestinationPayment();
        String other$destinationPayment = other.getDestinationPayment();
        if (this$destinationPayment == null ? other$destinationPayment != null : !this$destinationPayment.equals(other$destinationPayment)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        TransferReversalCollection this$reversals = this.getReversals();
        TransferReversalCollection other$reversals = other.getReversals();
        if (this$reversals == null ? other$reversals != null : !this$reversals.equals(other$reversals)) {
            return false;
        }
        Boolean this$reversed = this.getReversed();
        Boolean other$reversed = other.getReversed();
        if (this$reversed == null ? other$reversed != null : !((Object)this$reversed).equals(other$reversed)) {
            return false;
        }
        String this$sourceTransaction = this.getSourceTransaction();
        String other$sourceTransaction = other.getSourceTransaction();
        if (this$sourceTransaction == null ? other$sourceTransaction != null : !this$sourceTransaction.equals(other$sourceTransaction)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        BankAccount this$account = this.getAccount();
        BankAccount other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        List<String> this$otherTransfers = this.getOtherTransfers();
        List<String> other$otherTransfers = other.getOtherTransfers();
        if (this$otherTransfers == null ? other$otherTransfers != null : !((Object)this$otherTransfers).equals(other$otherTransfers)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$statementDescription = this.getStatementDescription();
        String other$statementDescription = other.getStatementDescription();
        if (this$statementDescription == null ? other$statementDescription != null : !this$statementDescription.equals(other$statementDescription)) {
            return false;
        }
        Summary this$summary = this.getSummary();
        Summary other$summary = other.getSummary();
        return !(this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transfer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountReversed = this.getAmountReversed();
        result = result * 59 + ($amountReversed == null ? 43 : ((Object)$amountReversed).hashCode());
        String $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : $applicationFee.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        BankAccount $bankAccount = this.getBankAccount();
        result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $destinationPayment = this.getDestinationPayment();
        result = result * 59 + ($destinationPayment == null ? 43 : $destinationPayment.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        TransferReversalCollection $reversals = this.getReversals();
        result = result * 59 + ($reversals == null ? 43 : $reversals.hashCode());
        Boolean $reversed = this.getReversed();
        result = result * 59 + ($reversed == null ? 43 : ((Object)$reversed).hashCode());
        String $sourceTransaction = this.getSourceTransaction();
        result = result * 59 + ($sourceTransaction == null ? 43 : $sourceTransaction.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        BankAccount $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        List<String> $otherTransfers = this.getOtherTransfers();
        result = result * 59 + ($otherTransfers == null ? 43 : ((Object)$otherTransfers).hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $statementDescription = this.getStatementDescription();
        result = result * 59 + ($statementDescription == null ? 43 : $statementDescription.hashCode());
        Summary $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

