/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Charge;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.MetadataStore;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Invoice
extends APIResource
implements MetadataStore<Invoice>,
HasId {
    String id;
    String object;
    Long amountDue;
    Long applicationFee;
    Integer attemptCount;
    Boolean attempted;
    String billing;
    ExpandableField<Charge> charge;
    Boolean closed;
    Long created;
    String currency;
    String customer;
    Long date;
    String description;
    Discount discount;
    Long dueDate;
    Long endingBalance;
    Boolean forgiven;
    InvoiceLineItemCollection lines;
    Boolean livemode;
    Map<String, String> metadata;
    Long nextPaymentAttempt;
    String number;
    Boolean paid;
    Long periodEnd;
    Long periodStart;
    String receiptNumber;
    Long startingBalance;
    String statementDescriptor;
    ExpandableField<Subscription> subscription;
    Long subscriptionProrationDate;
    Long subtotal;
    Long tax;
    Double taxPercent;
    Long total;
    Long webhooksDeliveredAt;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getAmountDue() {
        return this.amountDue;
    }

    public void setAmountDue(Long amountDue) {
        this.amountDue = amountDue;
    }

    public Long getApplicationFee() {
        return this.applicationFee;
    }

    public void setApplicationFee(Long applicationFee) {
        this.applicationFee = applicationFee;
    }

    public Integer getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(Integer attemptCount) {
        this.attemptCount = attemptCount;
    }

    public Boolean getAttempted() {
        return this.attempted;
    }

    public void setAttempted(Boolean attempted) {
        this.attempted = attempted;
    }

    public String getBilling() {
        return this.billing;
    }

    public void setBilling(String billing) {
        this.billing = billing;
    }

    public String getCharge() {
        if (this.charge == null) {
            return null;
        }
        return this.charge.getId();
    }

    public void setCharge(String chargeID) {
        this.charge = Invoice.setExpandableFieldID(chargeID, this.charge);
    }

    public Charge getChargeObject() {
        if (this.charge == null) {
            return null;
        }
        return this.charge.getExpanded();
    }

    public void setChargeObject(Charge charge) {
        this.charge = new ExpandableField<Charge>(charge.getId(), charge);
    }

    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public Long getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Long dueDate) {
        this.dueDate = dueDate;
    }

    public Long getEndingBalance() {
        return this.endingBalance;
    }

    public void setEndingBalance(Long endingBalance) {
        this.endingBalance = endingBalance;
    }

    public Boolean getForgiven() {
        return this.forgiven;
    }

    public void setForgiven(Boolean forgiven) {
        this.forgiven = forgiven;
    }

    public InvoiceLineItemCollection getLines() {
        return this.lines;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Long getNextPaymentAttempt() {
        return this.nextPaymentAttempt;
    }

    public void setNextPaymentAttempt(Long nextPaymentAttempt) {
        this.nextPaymentAttempt = nextPaymentAttempt;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public Long getPeriodEnd() {
        return this.periodEnd;
    }

    public void setPeriodEnd(Long periodEnd) {
        this.periodEnd = periodEnd;
    }

    public Long getPeriodStart() {
        return this.periodStart;
    }

    public void setPeriodStart(Long periodStart) {
        this.periodStart = periodStart;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public Long getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(Long startingBalance) {
        this.startingBalance = startingBalance;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public String getSubscription() {
        if (this.subscription == null) {
            return null;
        }
        return this.subscription.getId();
    }

    public void setSubscription(String subscriptionID) {
        this.subscription = Invoice.setExpandableFieldID(subscriptionID, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        if (this.subscription == null) {
            return null;
        }
        return this.subscription.getExpanded();
    }

    public void setSubscriptionObject(Subscription subscription) {
        this.subscription = new ExpandableField<Subscription>(subscription.getId(), subscription);
    }

    public Long getSubscriptionProrationDate() {
        return this.subscriptionProrationDate;
    }

    public void setSubscriptionProrationDate(Long subscriptionProrationDate) {
        this.subscriptionProrationDate = subscriptionProrationDate;
    }

    public Long getSubtotal() {
        return this.subtotal;
    }

    public void setSubtotal(Long subtotal) {
        this.subtotal = subtotal;
    }

    public Long getTax() {
        return this.tax;
    }

    public void setTax(Long tax) {
        this.tax = tax;
    }

    public Double getTaxPercent() {
        return this.taxPercent;
    }

    public void setTaxPercent(Double taxPercent) {
        this.taxPercent = taxPercent;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Long getWebhooksDeliveredAt() {
        return this.webhooksDeliveredAt;
    }

    public void setWebhooksDeliveredAt(Long webhooksDeliveredAt) {
        this.webhooksDeliveredAt = webhooksDeliveredAt;
    }

    public static Invoice retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, (RequestOptions)null);
    }

    public static Invoice create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, (RequestOptions)null);
    }

    public static Invoice upcoming(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, (RequestOptions)null);
    }

    public Invoice pay() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay((RequestOptions)null);
    }

    public Invoice update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Deprecated
    public static Invoice retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), null, Invoice.class, options);
    }

    public static Invoice retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, Invoice.instanceURL(Invoice.class, id), params, Invoice.class, options);
    }

    @Deprecated
    public static Invoice create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.classURL(Invoice.class), params, Invoice.class, options);
    }

    @Deprecated
    public static Invoice upcoming(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.upcoming(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Invoice upcoming(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.GET, String.format("%s/upcoming", Invoice.classURL(Invoice.class)), params, Invoice.class, options);
    }

    public static InvoiceCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, null);
    }

    public static InvoiceCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.requestCollection(Invoice.classURL(Invoice.class), params, InvoiceCollection.class, options);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, null);
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static InvoiceCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.list(params, options);
    }

    @Deprecated
    public Invoice update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Invoice update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, Invoice.instanceURL(Invoice.class, this.id), params, Invoice.class, options);
    }

    @Deprecated
    public Invoice pay(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Invoice pay(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Invoice.request(APIResource.RequestMethod.POST, String.format("%s/pay", Invoice.instanceURL(Invoice.class, this.getId())), null, Invoice.class, options);
    }
}

