/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.model.AlternateStatementDescriptors;
import com.stripe.model.Application;
import com.stripe.model.ApplicationFee;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.Card;
import com.stripe.model.ChargeCollection;
import com.stripe.model.ChargeLevel3;
import com.stripe.model.ChargeOutcome;
import com.stripe.model.ChargeRefundCollection;
import com.stripe.model.Customer;
import com.stripe.model.Dispute;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.FraudDetails;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.Order;
import com.stripe.model.Review;
import com.stripe.model.ShippingDetails;
import com.stripe.model.Transfer;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;

public class Charge
extends APIResource
implements MetadataStore<Charge>,
HasId {
    public static final String FRAUD_DETAILS = "fraud_details";
    String id;
    String object;
    Long amount;
    Long amountRefunded;
    ExpandableField<Application> application;
    ExpandableField<ApplicationFee> applicationFee;
    AlternateStatementDescriptors alternateStatementDescriptors;
    ExpandableField<BalanceTransaction> balanceTransaction;
    Boolean captured;
    Long created;
    String currency;
    ExpandableField<Customer> customer;
    String description;
    ExpandableField<Account> destination;
    ExpandableField<Dispute> dispute;
    String failureCode;
    String failureMessage;
    FraudDetails fraudDetails;
    ExpandableField<Invoice> invoice;
    ChargeLevel3 level3;
    Boolean livemode;
    Map<String, String> metadata;
    ExpandableField<Account> onBehalfOf;
    ExpandableField<Order> order;
    ChargeOutcome outcome;
    Boolean paid;
    String receiptEmail;
    String receiptNumber;
    Boolean refunded;
    ChargeRefundCollection refunds;
    ExpandableField<Review> review;
    ShippingDetails shipping;
    ExternalAccount source;
    ExpandableField<Transfer> sourceTransfer;
    String statementDescriptor;
    String status;
    ExpandableField<Transfer> transfer;
    String transferGroup;
    @Deprecated
    Card card;
    @Deprecated
    Boolean disputed;
    @Deprecated
    String statementDescription;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String applicationID) {
        this.application = Charge.setExpandableFieldID(applicationID, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application c) {
        this.application = new ExpandableField<Application>(c.getId(), c);
    }

    public String getApplicationFee() {
        return this.applicationFee != null ? this.applicationFee.getId() : null;
    }

    public void setApplicationFee(String applicationFeeID) {
        this.applicationFee = Charge.setExpandableFieldID(applicationFeeID, this.applicationFee);
    }

    public ApplicationFee getApplicationFeeObject() {
        return this.applicationFee != null ? this.applicationFee.getExpanded() : null;
    }

    public void setApplicationFeeObject(ApplicationFee c) {
        this.applicationFee = new ExpandableField<ApplicationFee>(c.getId(), c);
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String balanceTransactionID) {
        this.balanceTransaction = Charge.setExpandableFieldID(balanceTransactionID, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction c) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerID) {
        this.customer = Charge.setExpandableFieldID(customerID, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String destinationID) {
        this.destination = APIResource.setExpandableFieldID(destinationID, this.destination);
    }

    public Account getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account c) {
        this.destination = new ExpandableField<Account>(c.getId(), c);
    }

    public String getDispute() {
        return this.dispute != null ? this.dispute.getId() : null;
    }

    public void setDispute(String dispute) {
        this.dispute = Charge.setExpandableFieldID(dispute, this.dispute);
    }

    public Dispute getDisputeObject() {
        return this.dispute != null ? this.dispute.getExpanded() : null;
    }

    public void setDisputeObject(Dispute dispute) {
        this.dispute = new ExpandableField<Dispute>(dispute.getId(), dispute);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String invoiceID) {
        this.invoice = Charge.setExpandableFieldID(invoiceID, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice c) {
        this.invoice = new ExpandableField<Invoice>(c.getId(), c);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String onBehalfOfID) {
        this.onBehalfOf = APIResource.setExpandableFieldID(onBehalfOfID, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account c) {
        this.onBehalfOf = new ExpandableField<Account>(c.getId(), c);
    }

    public String getOrder() {
        return this.order != null ? this.order.getId() : null;
    }

    public void setOrder(String orderID) {
        this.order = Charge.setExpandableFieldID(orderID, this.order);
    }

    public Order getOrderObject() {
        return this.order != null ? this.order.getExpanded() : null;
    }

    public void setOrderObject(Order c) {
        this.order = new ExpandableField<Order>(c.getId(), c);
    }

    public ChargeRefundCollection getRefunds() {
        if (this.refunds != null && this.refunds.getURL() == null) {
            this.refunds.setURL(String.format("/v1/charges/%s/refunds", this.getId()));
        }
        return this.refunds;
    }

    public String getReview() {
        return this.review != null ? this.review.getId() : null;
    }

    public void setReview(String reviewID) {
        this.review = Charge.setExpandableFieldID(reviewID, this.review);
    }

    public Review getReviewObject() {
        return this.review != null ? this.review.getExpanded() : null;
    }

    public void setReviewObject(Review r) {
        this.review = new ExpandableField<Review>(r.getId(), r);
    }

    public String getSourceTransfer() {
        return this.sourceTransfer != null ? this.sourceTransfer.getId() : null;
    }

    public void setSourceTransfer(String sourceTransferID) {
        this.sourceTransfer = Charge.setExpandableFieldID(sourceTransferID, this.sourceTransfer);
    }

    public Transfer getSourceTransferObject() {
        return this.sourceTransfer != null ? this.sourceTransfer.getExpanded() : null;
    }

    public void setSourceTransferObject(Transfer c) {
        this.sourceTransfer = new ExpandableField<Transfer>(c.getId(), c);
    }

    public String getTransfer() {
        return this.transfer != null ? this.transfer.getId() : null;
    }

    public void setTransfer(String transferID) {
        this.transfer = Charge.setExpandableFieldID(transferID, this.transfer);
    }

    public Transfer getTransferObject() {
        return this.transfer != null ? this.transfer.getExpanded() : null;
    }

    public void setTransferObject(Transfer c) {
        this.transfer = new ExpandableField<Transfer>(c.getId(), c);
    }

    @Deprecated
    public static ChargeCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.list(params, null);
    }

    @Deprecated
    public static ChargeCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.list(params, options);
    }

    @Deprecated
    public static ChargeCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Charge capture() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(null, (RequestOptions)null);
    }

    public Charge capture(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(null, options);
    }

    @Deprecated
    public Charge capture(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Charge capture(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(params, (RequestOptions)null);
    }

    public Charge capture(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/capture", Charge.instanceURL(Charge.class, this.getId())), params, Charge.class, options);
    }

    @Deprecated
    public Charge capture(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.capture(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Dispute closeDispute() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.closeDispute((RequestOptions)null);
    }

    @Deprecated
    public Dispute closeDispute(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/dispute/close", Charge.instanceURL(Charge.class, this.getId())), null, Dispute.class, options);
    }

    @Deprecated
    public Dispute closeDispute(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.closeDispute(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Charge create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.create(params, (RequestOptions)null);
    }

    public static Charge create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, Charge.classURL(Charge.class), params, Charge.class, options);
    }

    @Deprecated
    public static Charge create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static ChargeCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.list(params, null);
    }

    public static ChargeCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.requestCollection(Charge.classURL(Charge.class), params, ChargeCollection.class, options);
    }

    public Charge markFraudulent(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Map<String, Map<String, String>> params = Collections.singletonMap(FRAUD_DETAILS, Collections.singletonMap("user_report", "fraudulent"));
        return this.update(params, options);
    }

    public Charge markSafe(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Map<String, Map<String, String>> params = Collections.singletonMap(FRAUD_DETAILS, Collections.singletonMap("user_report", "safe"));
        return this.update(params, options);
    }

    @Deprecated
    public Charge refund() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, (RequestOptions)null);
    }

    @Deprecated
    public Charge refund(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, options);
    }

    @Deprecated
    public Charge refund(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Charge refund(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, (RequestOptions)null);
    }

    @Deprecated
    public Charge refund(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/refund", Charge.instanceURL(Charge.class, this.getId())), params, Charge.class, options);
    }

    @Deprecated
    public Charge refund(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Charge retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.retrieve(id, (RequestOptions)null);
    }

    public static Charge retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.GET, Charge.instanceURL(Charge.class, id), null, Charge.class, options);
    }

    @Deprecated
    public static Charge retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Charge retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.GET, Charge.instanceURL(Charge.class, id), params, Charge.class, options);
    }

    public Charge update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Charge update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, Charge.instanceURL(Charge.class, this.id), params, Charge.class, options);
    }

    @Deprecated
    public Charge update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public Dispute updateDispute(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateDispute(params, (RequestOptions)null);
    }

    @Deprecated
    public Dispute updateDispute(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Charge.request(APIResource.RequestMethod.POST, String.format("%s/dispute", Charge.instanceURL(Charge.class, this.id)), params, Dispute.class, options);
    }

    @Deprecated
    public Dispute updateDispute(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateDispute(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountRefunded() {
        return this.amountRefunded;
    }

    @Generated
    public AlternateStatementDescriptors getAlternateStatementDescriptors() {
        return this.alternateStatementDescriptors;
    }

    @Generated
    public Boolean getCaptured() {
        return this.captured;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public FraudDetails getFraudDetails() {
        return this.fraudDetails;
    }

    @Generated
    public ChargeLevel3 getLevel3() {
        return this.level3;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public ChargeOutcome getOutcome() {
        return this.outcome;
    }

    @Generated
    public Boolean getPaid() {
        return this.paid;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public Boolean getRefunded() {
        return this.refunded;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public ExternalAccount getSource() {
        return this.source;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Deprecated
    @Generated
    public Card getCard() {
        return this.card;
    }

    @Deprecated
    @Generated
    public Boolean getDisputed() {
        return this.disputed;
    }

    @Deprecated
    @Generated
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountRefunded(Long amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @Generated
    public void setAlternateStatementDescriptors(AlternateStatementDescriptors alternateStatementDescriptors) {
        this.alternateStatementDescriptors = alternateStatementDescriptors;
    }

    @Generated
    public void setCaptured(Boolean captured) {
        this.captured = captured;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Generated
    public void setFraudDetails(FraudDetails fraudDetails) {
        this.fraudDetails = fraudDetails;
    }

    @Generated
    public void setLevel3(ChargeLevel3 level3) {
        this.level3 = level3;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setOutcome(ChargeOutcome outcome) {
        this.outcome = outcome;
    }

    @Generated
    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    @Generated
    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    @Generated
    public void setRefunds(ChargeRefundCollection refunds) {
        this.refunds = refunds;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setSource(ExternalAccount source) {
        this.source = source;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Deprecated
    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Deprecated
    @Generated
    public void setDisputed(Boolean disputed) {
        this.disputed = disputed;
    }

    @Deprecated
    @Generated
    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Charge)) {
            return false;
        }
        Charge other = (Charge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountRefunded = this.getAmountRefunded();
        Long other$amountRefunded = other.getAmountRefunded();
        if (this$amountRefunded == null ? other$amountRefunded != null : !((Object)this$amountRefunded).equals(other$amountRefunded)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$applicationFee = this.getApplicationFee();
        String other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) {
            return false;
        }
        AlternateStatementDescriptors this$alternateStatementDescriptors = this.getAlternateStatementDescriptors();
        AlternateStatementDescriptors other$alternateStatementDescriptors = other.getAlternateStatementDescriptors();
        if (this$alternateStatementDescriptors == null ? other$alternateStatementDescriptors != null : !((Object)this$alternateStatementDescriptors).equals(other$alternateStatementDescriptors)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        Boolean this$captured = this.getCaptured();
        Boolean other$captured = other.getCaptured();
        if (this$captured == null ? other$captured != null : !((Object)this$captured).equals(other$captured)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$dispute = this.getDispute();
        String other$dispute = other.getDispute();
        if (this$dispute == null ? other$dispute != null : !this$dispute.equals(other$dispute)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        FraudDetails this$fraudDetails = this.getFraudDetails();
        FraudDetails other$fraudDetails = other.getFraudDetails();
        if (this$fraudDetails == null ? other$fraudDetails != null : !((Object)this$fraudDetails).equals(other$fraudDetails)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        ChargeLevel3 this$level3 = this.getLevel3();
        ChargeLevel3 other$level3 = other.getLevel3();
        if (this$level3 == null ? other$level3 != null : !((Object)this$level3).equals(other$level3)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        ChargeOutcome this$outcome = this.getOutcome();
        ChargeOutcome other$outcome = other.getOutcome();
        if (this$outcome == null ? other$outcome != null : !((Object)this$outcome).equals(other$outcome)) {
            return false;
        }
        Boolean this$paid = this.getPaid();
        Boolean other$paid = other.getPaid();
        if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        Boolean this$refunded = this.getRefunded();
        Boolean other$refunded = other.getRefunded();
        if (this$refunded == null ? other$refunded != null : !((Object)this$refunded).equals(other$refunded)) {
            return false;
        }
        ChargeRefundCollection this$refunds = this.getRefunds();
        ChargeRefundCollection other$refunds = other.getRefunds();
        if (this$refunds == null ? other$refunds != null : !this$refunds.equals(other$refunds)) {
            return false;
        }
        String this$review = this.getReview();
        String other$review = other.getReview();
        if (this$review == null ? other$review != null : !this$review.equals(other$review)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        ExternalAccount this$source = this.getSource();
        ExternalAccount other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$sourceTransfer = this.getSourceTransfer();
        String other$sourceTransfer = other.getSourceTransfer();
        if (this$sourceTransfer == null ? other$sourceTransfer != null : !this$sourceTransfer.equals(other$sourceTransfer)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transfer = this.getTransfer();
        String other$transfer = other.getTransfer();
        if (this$transfer == null ? other$transfer != null : !this$transfer.equals(other$transfer)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        Boolean this$disputed = this.getDisputed();
        Boolean other$disputed = other.getDisputed();
        if (this$disputed == null ? other$disputed != null : !((Object)this$disputed).equals(other$disputed)) {
            return false;
        }
        String this$statementDescription = this.getStatementDescription();
        String other$statementDescription = other.getStatementDescription();
        return !(this$statementDescription == null ? other$statementDescription != null : !this$statementDescription.equals(other$statementDescription));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Charge;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountRefunded = this.getAmountRefunded();
        result = result * 59 + ($amountRefunded == null ? 43 : ((Object)$amountRefunded).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : $applicationFee.hashCode());
        AlternateStatementDescriptors $alternateStatementDescriptors = this.getAlternateStatementDescriptors();
        result = result * 59 + ($alternateStatementDescriptors == null ? 43 : ((Object)$alternateStatementDescriptors).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        Boolean $captured = this.getCaptured();
        result = result * 59 + ($captured == null ? 43 : ((Object)$captured).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $dispute = this.getDispute();
        result = result * 59 + ($dispute == null ? 43 : $dispute.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        FraudDetails $fraudDetails = this.getFraudDetails();
        result = result * 59 + ($fraudDetails == null ? 43 : ((Object)$fraudDetails).hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        ChargeLevel3 $level3 = this.getLevel3();
        result = result * 59 + ($level3 == null ? 43 : ((Object)$level3).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        ChargeOutcome $outcome = this.getOutcome();
        result = result * 59 + ($outcome == null ? 43 : ((Object)$outcome).hashCode());
        Boolean $paid = this.getPaid();
        result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        Boolean $refunded = this.getRefunded();
        result = result * 59 + ($refunded == null ? 43 : ((Object)$refunded).hashCode());
        ChargeRefundCollection $refunds = this.getRefunds();
        result = result * 59 + ($refunds == null ? 43 : $refunds.hashCode());
        String $review = this.getReview();
        result = result * 59 + ($review == null ? 43 : $review.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        ExternalAccount $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $sourceTransfer = this.getSourceTransfer();
        result = result * 59 + ($sourceTransfer == null ? 43 : $sourceTransfer.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transfer = this.getTransfer();
        result = result * 59 + ($transfer == null ? 43 : $transfer.hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        Boolean $disputed = this.getDisputed();
        result = result * 59 + ($disputed == null ? 43 : ((Object)$disputed).hashCode());
        String $statementDescription = this.getStatementDescription();
        result = result * 59 + ($statementDescription == null ? 43 : $statementDescription.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

