/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Address;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.issuing.CardCollection;
import com.stripe.model.issuing.CardDetails;
import com.stripe.model.issuing.Cardholder;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Card
extends APIResource
implements MetadataStore<Card>,
HasId {
    String id;
    String object;
    AuthorizationControls authorizationControls;
    Billing billing;
    String brand;
    Cardholder cardholder;
    Long created;
    String currency;
    Integer expMonth;
    Integer expYear;
    String last4;
    Boolean livemode;
    Map<String, String> metadata;
    String name;
    String status;
    String type;

    public static Card create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.create(params, null);
    }

    public static Card create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.request(APIResource.RequestMethod.POST, Card.classURL(Card.class), params, Card.class, options);
    }

    public CardDetails details(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.details(params, null);
    }

    public CardDetails details(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.request(APIResource.RequestMethod.GET, String.format("%s/details", Card.instanceURL(Card.class, this.getId())), params, CardDetails.class, options);
    }

    public static CardCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.list(params, null);
    }

    public static CardCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.requestCollection(Card.classURL(Card.class), params, CardCollection.class, options);
    }

    public static Card retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.retrieve(id, null);
    }

    public static Card retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.request(APIResource.RequestMethod.GET, Card.instanceURL(Card.class, id), null, Card.class, options);
    }

    public static Card retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.request(APIResource.RequestMethod.GET, Card.instanceURL(Card.class, id), params, Card.class, options);
    }

    public Card update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Card update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Card.request(APIResource.RequestMethod.POST, Card.instanceURL(Card.class, this.id), params, Card.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public AuthorizationControls getAuthorizationControls() {
        return this.authorizationControls;
    }

    @Generated
    public Billing getBilling() {
        return this.billing;
    }

    @Generated
    public String getBrand() {
        return this.brand;
    }

    @Generated
    public Cardholder getCardholder() {
        return this.cardholder;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Integer getExpMonth() {
        return this.expMonth;
    }

    @Generated
    public Integer getExpYear() {
        return this.expYear;
    }

    @Generated
    public String getLast4() {
        return this.last4;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAuthorizationControls(AuthorizationControls authorizationControls) {
        this.authorizationControls = authorizationControls;
    }

    @Generated
    public void setBilling(Billing billing) {
        this.billing = billing;
    }

    @Generated
    public void setBrand(String brand) {
        this.brand = brand;
    }

    @Generated
    public void setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setExpMonth(Integer expMonth) {
        this.expMonth = expMonth;
    }

    @Generated
    public void setExpYear(Integer expYear) {
        this.expYear = expYear;
    }

    @Generated
    public void setLast4(String last4) {
        this.last4 = last4;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Card)) {
            return false;
        }
        Card other = (Card)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        AuthorizationControls this$authorizationControls = this.getAuthorizationControls();
        AuthorizationControls other$authorizationControls = other.getAuthorizationControls();
        if (this$authorizationControls == null ? other$authorizationControls != null : !((Object)this$authorizationControls).equals(other$authorizationControls)) {
            return false;
        }
        Billing this$billing = this.getBilling();
        Billing other$billing = other.getBilling();
        if (this$billing == null ? other$billing != null : !((Object)this$billing).equals(other$billing)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        Cardholder this$cardholder = this.getCardholder();
        Cardholder other$cardholder = other.getCardholder();
        if (this$cardholder == null ? other$cardholder != null : !((Object)this$cardholder).equals(other$cardholder)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Integer this$expMonth = this.getExpMonth();
        Integer other$expMonth = other.getExpMonth();
        if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
            return false;
        }
        Integer this$expYear = this.getExpYear();
        Integer other$expYear = other.getExpYear();
        if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
            return false;
        }
        String this$last4 = this.getLast4();
        String other$last4 = other.getLast4();
        if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Card;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        AuthorizationControls $authorizationControls = this.getAuthorizationControls();
        result = result * 59 + ($authorizationControls == null ? 43 : ((Object)$authorizationControls).hashCode());
        Billing $billing = this.getBilling();
        result = result * 59 + ($billing == null ? 43 : ((Object)$billing).hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        Cardholder $cardholder = this.getCardholder();
        result = result * 59 + ($cardholder == null ? 43 : ((Object)$cardholder).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Integer $expMonth = this.getExpMonth();
        result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
        Integer $expYear = this.getExpYear();
        result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
        String $last4 = this.getLast4();
        result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public final class Shipping
    extends StripeObject {
        Address address;
        String carrier;
        Long eta;
        String name;
        String phone;
        String status;
        String trackingNumber;
        String trackingURL;
        String type;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getCarrier() {
            return this.carrier;
        }

        @Generated
        public Long getEta() {
            return this.eta;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getTrackingNumber() {
            return this.trackingNumber;
        }

        @Generated
        public String getTrackingURL() {
            return this.trackingURL;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        @Generated
        public void setEta(Long eta) {
            this.eta = eta;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        @Generated
        public void setTrackingURL(String trackingURL) {
            this.trackingURL = trackingURL;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Shipping)) {
                return false;
            }
            Shipping other = (Shipping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$carrier = this.getCarrier();
            String other$carrier = other.getCarrier();
            if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) {
                return false;
            }
            Long this$eta = this.getEta();
            Long other$eta = other.getEta();
            if (this$eta == null ? other$eta != null : !((Object)this$eta).equals(other$eta)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$trackingNumber = this.getTrackingNumber();
            String other$trackingNumber = other.getTrackingNumber();
            if (this$trackingNumber == null ? other$trackingNumber != null : !this$trackingNumber.equals(other$trackingNumber)) {
                return false;
            }
            String this$trackingURL = this.getTrackingURL();
            String other$trackingURL = other.getTrackingURL();
            if (this$trackingURL == null ? other$trackingURL != null : !this$trackingURL.equals(other$trackingURL)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Shipping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $carrier = this.getCarrier();
            result = result * 59 + ($carrier == null ? 43 : $carrier.hashCode());
            Long $eta = this.getEta();
            result = result * 59 + ($eta == null ? 43 : ((Object)$eta).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $trackingNumber = this.getTrackingNumber();
            result = result * 59 + ($trackingNumber == null ? 43 : $trackingNumber.hashCode());
            String $trackingURL = this.getTrackingURL();
            result = result * 59 + ($trackingURL == null ? 43 : $trackingURL.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public final class Billing
    extends StripeObject {
        Address address;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Billing)) {
                return false;
            }
            Billing other = (Billing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Billing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            return result;
        }
    }

    public final class AuthorizationControls
    extends StripeObject {
        List<String> allowedCategories;
        List<String> blockedCategories;
        String currency;
        Long maxAmount;
        Long maxApprovals;

        @Generated
        public List<String> getAllowedCategories() {
            return this.allowedCategories;
        }

        @Generated
        public List<String> getBlockedCategories() {
            return this.blockedCategories;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public Long getMaxAmount() {
            return this.maxAmount;
        }

        @Generated
        public Long getMaxApprovals() {
            return this.maxApprovals;
        }

        @Generated
        public void setAllowedCategories(List<String> allowedCategories) {
            this.allowedCategories = allowedCategories;
        }

        @Generated
        public void setBlockedCategories(List<String> blockedCategories) {
            this.blockedCategories = blockedCategories;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setMaxAmount(Long maxAmount) {
            this.maxAmount = maxAmount;
        }

        @Generated
        public void setMaxApprovals(Long maxApprovals) {
            this.maxApprovals = maxApprovals;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthorizationControls)) {
                return false;
            }
            AuthorizationControls other = (AuthorizationControls)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedCategories = this.getAllowedCategories();
            List<String> other$allowedCategories = other.getAllowedCategories();
            if (this$allowedCategories == null ? other$allowedCategories != null : !((Object)this$allowedCategories).equals(other$allowedCategories)) {
                return false;
            }
            List<String> this$blockedCategories = this.getBlockedCategories();
            List<String> other$blockedCategories = other.getBlockedCategories();
            if (this$blockedCategories == null ? other$blockedCategories != null : !((Object)this$blockedCategories).equals(other$blockedCategories)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            Long this$maxAmount = this.getMaxAmount();
            Long other$maxAmount = other.getMaxAmount();
            if (this$maxAmount == null ? other$maxAmount != null : !((Object)this$maxAmount).equals(other$maxAmount)) {
                return false;
            }
            Long this$maxApprovals = this.getMaxApprovals();
            Long other$maxApprovals = other.getMaxApprovals();
            return !(this$maxApprovals == null ? other$maxApprovals != null : !((Object)this$maxApprovals).equals(other$maxApprovals));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthorizationControls;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedCategories = this.getAllowedCategories();
            result = result * 59 + ($allowedCategories == null ? 43 : ((Object)$allowedCategories).hashCode());
            List<String> $blockedCategories = this.getBlockedCategories();
            result = result * 59 + ($blockedCategories == null ? 43 : ((Object)$blockedCategories).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            Long $maxAmount = this.getMaxAmount();
            result = result * 59 + ($maxAmount == null ? 43 : ((Object)$maxAmount).hashCode());
            Long $maxApprovals = this.getMaxApprovals();
            result = result * 59 + ($maxApprovals == null ? 43 : ((Object)$maxApprovals).hashCode());
            return result;
        }
    }
}

