/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.Customer;
import com.stripe.model.ExternalAccount;
import com.stripe.model.HasSourceTypeData;
import com.stripe.model.SourceTransactionCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class Source
extends ExternalAccount
implements HasSourceTypeData {
    Long amount;
    String clientSecret;
    CodeVerificationFlow codeVerification;
    Long created;
    String currency;
    String flow;
    Boolean livemode;
    Owner owner;
    ReceiverFlow receiver;
    RedirectFlow redirect;
    String statementDescriptor;
    String status;
    String type;
    String usage;
    Map<String, String> typeData;

    public String getSourceInstanceUrl() throws InvalidRequestException {
        return Source.instanceUrl(Source.class, this.getId());
    }

    public static Source create(Map<String, Object> params) throws StripeException {
        return Source.create(params, null);
    }

    public static Source create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Source.request(ApiResource.RequestMethod.POST, Source.classUrl(Source.class), params, Source.class, options);
    }

    @Override
    public Source delete(RequestOptions options) throws StripeException {
        throw new InvalidRequestException("Source objects cannot be deleted. If you want to detach the source from a customer object, use detach().", null, null, null, 0, null);
    }

    public Source detach() throws StripeException {
        return this.detach(null, null);
    }

    public Source detach(Map<String, Object> params) throws StripeException {
        return this.detach(params, null);
    }

    public Source detach(Map<String, Object> params, RequestOptions options) throws StripeException {
        if (this.getCustomer() != null) {
            String url = String.format("%s/%s/sources/%s", Source.classUrl(Customer.class), this.getCustomer(), this.getId());
            return Source.request(ApiResource.RequestMethod.DELETE, url, params, Source.class, options);
        }
        throw new InvalidRequestException("This source object does not appear to be currently attached to a customer object.", null, null, null, 0, null);
    }

    public static Source retrieve(String id) throws StripeException {
        return Source.retrieve(id, null);
    }

    public static Source retrieve(String id, RequestOptions options) throws StripeException {
        return Source.request(ApiResource.RequestMethod.GET, Source.instanceUrl(Source.class, id), null, Source.class, options);
    }

    public SourceTransactionCollection sourceTransactions(Map<String, Object> params) throws StripeException {
        return this.sourceTransactions(params, null);
    }

    public SourceTransactionCollection sourceTransactions(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = Source.instanceUrl(Source.class, this.getId()) + "/source_transactions";
        return Source.requestCollection(url, params, SourceTransactionCollection.class, options);
    }

    @Override
    public Source update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public Source update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Source.request(ApiResource.RequestMethod.POST, this.getSourceInstanceUrl(), params, Source.class, options);
    }

    @Override
    public Source verify(Map<String, Object> params) throws StripeException {
        return this.verify((Map)params, (RequestOptions)null);
    }

    @Override
    public Source verify(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Source.request(ApiResource.RequestMethod.POST, String.format("%s/verify", this.getSourceInstanceUrl()), params, Source.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public CodeVerificationFlow getCodeVerification() {
        return this.codeVerification;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getFlow() {
        return this.flow;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Owner getOwner() {
        return this.owner;
    }

    @Generated
    public ReceiverFlow getReceiver() {
        return this.receiver;
    }

    @Generated
    public RedirectFlow getRedirect() {
        return this.redirect;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setCodeVerification(CodeVerificationFlow codeVerification) {
        this.codeVerification = codeVerification;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setFlow(String flow) {
        this.flow = flow;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Generated
    public void setReceiver(ReceiverFlow receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setRedirect(RedirectFlow redirect) {
        this.redirect = redirect;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source other = (Source)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        CodeVerificationFlow this$codeVerification = this.getCodeVerification();
        CodeVerificationFlow other$codeVerification = other.getCodeVerification();
        if (this$codeVerification == null ? other$codeVerification != null : !((Object)this$codeVerification).equals(other$codeVerification)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Owner this$owner = this.getOwner();
        Owner other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        ReceiverFlow this$receiver = this.getReceiver();
        ReceiverFlow other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !((Object)this$receiver).equals(other$receiver)) {
            return false;
        }
        RedirectFlow this$redirect = this.getRedirect();
        RedirectFlow other$redirect = other.getRedirect();
        if (this$redirect == null ? other$redirect != null : !((Object)this$redirect).equals(other$redirect)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        Map<String, String> this$typeData = this.getTypeData();
        Map<String, String> other$typeData = other.getTypeData();
        return !(this$typeData == null ? other$typeData != null : !((Object)this$typeData).equals(other$typeData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Source;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        CodeVerificationFlow $codeVerification = this.getCodeVerification();
        result = result * 59 + ($codeVerification == null ? 43 : ((Object)$codeVerification).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Owner $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        ReceiverFlow $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : ((Object)$receiver).hashCode());
        RedirectFlow $redirect = this.getRedirect();
        result = result * 59 + ($redirect == null ? 43 : ((Object)$redirect).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        Map<String, String> $typeData = this.getTypeData();
        result = result * 59 + ($typeData == null ? 43 : ((Object)$typeData).hashCode());
        return result;
    }

    @Override
    @Generated
    public Map<String, String> getTypeData() {
        return this.typeData;
    }

    @Override
    @Generated
    public void setTypeData(Map<String, String> typeData) {
        this.typeData = typeData;
    }

    public static class RedirectFlow
    extends StripeObject {
        String failureReason;
        String returnUrl;
        String status;
        String url;

        @Generated
        public String getFailureReason() {
            return this.failureReason;
        }

        @Generated
        public String getReturnUrl() {
            return this.returnUrl;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Generated
        public void setReturnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RedirectFlow)) {
                return false;
            }
            RedirectFlow other = (RedirectFlow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$failureReason = this.getFailureReason();
            String other$failureReason = other.getFailureReason();
            if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) {
                return false;
            }
            String this$returnUrl = this.getReturnUrl();
            String other$returnUrl = other.getReturnUrl();
            if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RedirectFlow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $failureReason = this.getFailureReason();
            result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
            String $returnUrl = this.getReturnUrl();
            result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    public static class ReceiverFlow
    extends StripeObject {
        String refundAttributesStatus;
        String refundAttributesMethod;
        Long amountReceived;
        Long amountReturned;
        Long amountCharged;
        String address;

        @Generated
        public String getRefundAttributesStatus() {
            return this.refundAttributesStatus;
        }

        @Generated
        public String getRefundAttributesMethod() {
            return this.refundAttributesMethod;
        }

        @Generated
        public Long getAmountReceived() {
            return this.amountReceived;
        }

        @Generated
        public Long getAmountReturned() {
            return this.amountReturned;
        }

        @Generated
        public Long getAmountCharged() {
            return this.amountCharged;
        }

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public void setRefundAttributesStatus(String refundAttributesStatus) {
            this.refundAttributesStatus = refundAttributesStatus;
        }

        @Generated
        public void setRefundAttributesMethod(String refundAttributesMethod) {
            this.refundAttributesMethod = refundAttributesMethod;
        }

        @Generated
        public void setAmountReceived(Long amountReceived) {
            this.amountReceived = amountReceived;
        }

        @Generated
        public void setAmountReturned(Long amountReturned) {
            this.amountReturned = amountReturned;
        }

        @Generated
        public void setAmountCharged(Long amountCharged) {
            this.amountCharged = amountCharged;
        }

        @Generated
        public void setAddress(String address) {
            this.address = address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiverFlow)) {
                return false;
            }
            ReceiverFlow other = (ReceiverFlow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$refundAttributesStatus = this.getRefundAttributesStatus();
            String other$refundAttributesStatus = other.getRefundAttributesStatus();
            if (this$refundAttributesStatus == null ? other$refundAttributesStatus != null : !this$refundAttributesStatus.equals(other$refundAttributesStatus)) {
                return false;
            }
            String this$refundAttributesMethod = this.getRefundAttributesMethod();
            String other$refundAttributesMethod = other.getRefundAttributesMethod();
            if (this$refundAttributesMethod == null ? other$refundAttributesMethod != null : !this$refundAttributesMethod.equals(other$refundAttributesMethod)) {
                return false;
            }
            Long this$amountReceived = this.getAmountReceived();
            Long other$amountReceived = other.getAmountReceived();
            if (this$amountReceived == null ? other$amountReceived != null : !((Object)this$amountReceived).equals(other$amountReceived)) {
                return false;
            }
            Long this$amountReturned = this.getAmountReturned();
            Long other$amountReturned = other.getAmountReturned();
            if (this$amountReturned == null ? other$amountReturned != null : !((Object)this$amountReturned).equals(other$amountReturned)) {
                return false;
            }
            Long this$amountCharged = this.getAmountCharged();
            Long other$amountCharged = other.getAmountCharged();
            if (this$amountCharged == null ? other$amountCharged != null : !((Object)this$amountCharged).equals(other$amountCharged)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReceiverFlow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $refundAttributesStatus = this.getRefundAttributesStatus();
            result = result * 59 + ($refundAttributesStatus == null ? 43 : $refundAttributesStatus.hashCode());
            String $refundAttributesMethod = this.getRefundAttributesMethod();
            result = result * 59 + ($refundAttributesMethod == null ? 43 : $refundAttributesMethod.hashCode());
            Long $amountReceived = this.getAmountReceived();
            result = result * 59 + ($amountReceived == null ? 43 : ((Object)$amountReceived).hashCode());
            Long $amountReturned = this.getAmountReturned();
            result = result * 59 + ($amountReturned == null ? 43 : ((Object)$amountReturned).hashCode());
            Long $amountCharged = this.getAmountCharged();
            result = result * 59 + ($amountCharged == null ? 43 : ((Object)$amountCharged).hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }
    }

    public static class Owner
    extends StripeObject {
        Address address;
        Address verifiedAddress;
        String name;
        String verifiedName;
        String phone;
        String verifiedPhone;
        String email;
        String verifiedEmail;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public Address getVerifiedAddress() {
            return this.verifiedAddress;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVerifiedName() {
            return this.verifiedName;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public String getVerifiedPhone() {
            return this.verifiedPhone;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getVerifiedEmail() {
            return this.verifiedEmail;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setVerifiedAddress(Address verifiedAddress) {
            this.verifiedAddress = verifiedAddress;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setVerifiedName(String verifiedName) {
            this.verifiedName = verifiedName;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setVerifiedPhone(String verifiedPhone) {
            this.verifiedPhone = verifiedPhone;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setVerifiedEmail(String verifiedEmail) {
            this.verifiedEmail = verifiedEmail;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Owner)) {
                return false;
            }
            Owner other = (Owner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Address this$verifiedAddress = this.getVerifiedAddress();
            Address other$verifiedAddress = other.getVerifiedAddress();
            if (this$verifiedAddress == null ? other$verifiedAddress != null : !((Object)this$verifiedAddress).equals(other$verifiedAddress)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$verifiedName = this.getVerifiedName();
            String other$verifiedName = other.getVerifiedName();
            if (this$verifiedName == null ? other$verifiedName != null : !this$verifiedName.equals(other$verifiedName)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            String this$verifiedPhone = this.getVerifiedPhone();
            String other$verifiedPhone = other.getVerifiedPhone();
            if (this$verifiedPhone == null ? other$verifiedPhone != null : !this$verifiedPhone.equals(other$verifiedPhone)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$verifiedEmail = this.getVerifiedEmail();
            String other$verifiedEmail = other.getVerifiedEmail();
            return !(this$verifiedEmail == null ? other$verifiedEmail != null : !this$verifiedEmail.equals(other$verifiedEmail));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Owner;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Address $verifiedAddress = this.getVerifiedAddress();
            result = result * 59 + ($verifiedAddress == null ? 43 : ((Object)$verifiedAddress).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $verifiedName = this.getVerifiedName();
            result = result * 59 + ($verifiedName == null ? 43 : $verifiedName.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            String $verifiedPhone = this.getVerifiedPhone();
            result = result * 59 + ($verifiedPhone == null ? 43 : $verifiedPhone.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $verifiedEmail = this.getVerifiedEmail();
            result = result * 59 + ($verifiedEmail == null ? 43 : $verifiedEmail.hashCode());
            return result;
        }
    }

    public static class CodeVerificationFlow
    extends StripeObject {
        Long attemptsRemaining;
        String status;

        @Generated
        public Long getAttemptsRemaining() {
            return this.attemptsRemaining;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setAttemptsRemaining(Long attemptsRemaining) {
            this.attemptsRemaining = attemptsRemaining;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CodeVerificationFlow)) {
                return false;
            }
            CodeVerificationFlow other = (CodeVerificationFlow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$attemptsRemaining = this.getAttemptsRemaining();
            Long other$attemptsRemaining = other.getAttemptsRemaining();
            if (this$attemptsRemaining == null ? other$attemptsRemaining != null : !((Object)this$attemptsRemaining).equals(other$attemptsRemaining)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CodeVerificationFlow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $attemptsRemaining = this.getAttemptsRemaining();
            result = result * 59 + ($attemptsRemaining == null ? 43 : ((Object)$attemptsRemaining).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }
}

